/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.extension.CustomBuildingDefinitionProviderModelProperty;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.property.XmlExtensionModelProperty;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.config.ExtensionBuildingDefinitionProvider;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionDefinitionParser;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionParsingContext;
import org.mule.runtime.module.extension.internal.config.dsl.config.ConfigurationDefinitionParser;
import org.mule.runtime.module.extension.internal.config.dsl.connection.ConnectionProviderDefinitionParser;
import org.mule.runtime.module.extension.internal.config.dsl.construct.ConstructDefinitionParser;
import org.mule.runtime.module.extension.internal.config.dsl.operation.OperationDefinitionParser;
import org.mule.runtime.module.extension.internal.config.dsl.parameter.ObjectTypeParameterParser;
import org.mule.runtime.module.extension.internal.config.dsl.source.SourceDefinitionParser;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class DefaultExtensionBuildingDefinitionProvider
implements ExtensionBuildingDefinitionProvider {
    private final List<ComponentBuildingDefinition> definitions = new LinkedList<ComponentBuildingDefinition>();
    private Set<ExtensionModel> extensions = Collections.emptySet();

    public void init() {
        Preconditions.checkState((this.extensions != null ? 1 : 0) != 0, (String)"extensions cannot be null");
        this.extensions.stream().forEach(this::registerExtensionParsers);
    }

    public List<ComponentBuildingDefinition> getComponentBuildingDefinitions() {
        return this.definitions;
    }

    private void registerExtensionParsers(final ExtensionModel extensionModel) {
        XmlDslModel xmlDslModel = extensionModel.getXmlDslModel();
        final ExtensionParsingContext parsingContext = this.createParsingContext(extensionModel);
        final ComponentBuildingDefinition.Builder definitionBuilder = new ComponentBuildingDefinition.Builder().withNamespace(xmlDslModel.getPrefix());
        final DslSyntaxResolver dslSyntaxResolver = DslSyntaxResolver.getDefault((ExtensionModel)extensionModel, (DslResolvingContext)DslResolvingContext.getDefault(this.extensions));
        if (extensionModel.getModelProperty(CustomBuildingDefinitionProviderModelProperty.class).isPresent()) {
            return;
        }
        if (!extensionModel.getModelProperty(XmlExtensionModelProperty.class).isPresent()) {
            final ClassLoader extensionClassLoader = MuleExtensionUtils.getClassLoader((ExtensionModel)extensionModel);
            ClassUtils.withContextClassLoader((ClassLoader)extensionClassLoader, () -> {
                final ReflectionCache reflectionCache = new ReflectionCache();
                new IdempotentExtensionWalker(){

                    public void onConfiguration(ConfigurationModel model) {
                        DefaultExtensionBuildingDefinitionProvider.this.parseWith(new ConfigurationDefinitionParser(definitionBuilder, extensionModel, model, dslSyntaxResolver, parsingContext));
                    }

                    protected void onConstruct(ConstructModel model) {
                        DefaultExtensionBuildingDefinitionProvider.this.parseWith(new ConstructDefinitionParser(definitionBuilder, extensionModel, model, dslSyntaxResolver, parsingContext));
                    }

                    public void onOperation(OperationModel model) {
                        DefaultExtensionBuildingDefinitionProvider.this.parseWith(new OperationDefinitionParser(definitionBuilder, extensionModel, model, dslSyntaxResolver, parsingContext));
                    }

                    public void onConnectionProvider(ConnectionProviderModel model) {
                        DefaultExtensionBuildingDefinitionProvider.this.parseWith(new ConnectionProviderDefinitionParser(definitionBuilder, model, extensionModel, dslSyntaxResolver, parsingContext));
                    }

                    public void onSource(SourceModel model) {
                        DefaultExtensionBuildingDefinitionProvider.this.parseWith(new SourceDefinitionParser(definitionBuilder, extensionModel, model, dslSyntaxResolver, parsingContext));
                    }

                    protected void onParameter(ParameterGroupModel groupModel, ParameterModel model) {
                        DefaultExtensionBuildingDefinitionProvider.this.registerTopLevelParameter(model.getType(), definitionBuilder, extensionClassLoader, dslSyntaxResolver, parsingContext, reflectionCache);
                    }
                }.walk(extensionModel);
                this.registerExportedTypesTopLevelParsers(extensionModel, definitionBuilder, extensionClassLoader, dslSyntaxResolver, parsingContext, reflectionCache);
                this.registerSubTypes(definitionBuilder, extensionClassLoader, dslSyntaxResolver, parsingContext, reflectionCache);
            });
        }
    }

    private void registerSubTypes(MetadataType type, final ComponentBuildingDefinition.Builder definitionBuilder, final ClassLoader extensionClassLoader, final DslSyntaxResolver dslSyntaxResolver, final ExtensionParsingContext parsingContext, final ReflectionCache reflectionCache) {
        type.accept(new MetadataTypeVisitor(){

            public void visitUnion(UnionType unionType) {
                unionType.getTypes().forEach(type -> type.accept((MetadataTypeVisitor)this));
            }

            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept((MetadataTypeVisitor)this);
            }

            public void visitObject(ObjectType objectType) {
                if (objectType.isOpen()) {
                    ((MetadataType)objectType.getOpenRestriction().get()).accept((MetadataTypeVisitor)this);
                } else {
                    parsingContext.getSubTypes(objectType).forEach(subtype -> DefaultExtensionBuildingDefinitionProvider.this.registerTopLevelParameter((MetadataType)subtype, definitionBuilder, extensionClassLoader, dslSyntaxResolver, parsingContext, reflectionCache));
                }
            }
        });
    }

    private void parseWith(ExtensionDefinitionParser parser) {
        try {
            this.definitions.addAll(parser.parse());
        }
        catch (ConfigurationException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private void registerTopLevelParameter(MetadataType parameterType, final ComponentBuildingDefinition.Builder definitionBuilder, final ClassLoader extensionClassLoader, final DslSyntaxResolver dslSyntaxResolver, final ExtensionParsingContext parsingContext, final ReflectionCache reflectionCache) {
        final Optional dslElement = dslSyntaxResolver.resolve(parameterType);
        if (!dslElement.isPresent() || parsingContext.isRegistered(((DslElementSyntax)dslElement.get()).getElementName(), ((DslElementSyntax)dslElement.get()).getPrefix()) || !IntrospectionUtils.isInstantiable((MetadataType)parameterType, (ReflectionCache)reflectionCache)) {
            return;
        }
        parameterType.accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                DslElementSyntax pojoDsl = (DslElementSyntax)dslElement.get();
                if (pojoDsl.supportsTopLevelDeclaration() || pojoDsl.supportsChildDeclaration() && pojoDsl.isWrapped() || ExtensionMetadataTypeUtils.getSubstitutionGroup((MetadataType)objectType).isPresent() || parsingContext.getAllSubTypes().contains(objectType)) {
                    DefaultExtensionBuildingDefinitionProvider.this.parseWith(new ObjectTypeParameterParser(definitionBuilder, objectType, extensionClassLoader, dslSyntaxResolver, parsingContext));
                }
                DefaultExtensionBuildingDefinitionProvider.this.registerSubTypes((MetadataType)objectType, definitionBuilder, extensionClassLoader, dslSyntaxResolver, parsingContext, reflectionCache);
            }

            public void visitArrayType(ArrayType arrayType) {
                DefaultExtensionBuildingDefinitionProvider.this.registerTopLevelParameter(arrayType.getType(), definitionBuilder, extensionClassLoader, dslSyntaxResolver, parsingContext, reflectionCache);
            }

            public void visitUnion(UnionType unionType) {
                unionType.getTypes().forEach(type -> type.accept((MetadataTypeVisitor)this));
            }
        });
    }

    private void registerExportedTypesTopLevelParsers(ExtensionModel extensionModel, ComponentBuildingDefinition.Builder definitionBuilder, ClassLoader extensionClassLoader, DslSyntaxResolver dslSyntaxResolver, ExtensionParsingContext parsingContext, ReflectionCache reflectionCache) {
        this.registerTopLevelParameters(extensionModel.getTypes().stream(), definitionBuilder, extensionClassLoader, dslSyntaxResolver, parsingContext, reflectionCache);
    }

    private void registerSubTypes(ComponentBuildingDefinition.Builder definitionBuilder, ClassLoader extensionClassLoader, DslSyntaxResolver dslSyntaxResolver, ExtensionParsingContext parsingContext, ReflectionCache reflectionCache) {
        ImmutableList mappedTypes = new ImmutableList.Builder().addAll(parsingContext.getAllSubTypes()).addAll(parsingContext.getAllBaseTypes()).build();
        this.registerTopLevelParameters(mappedTypes.stream(), definitionBuilder, extensionClassLoader, dslSyntaxResolver, parsingContext, reflectionCache);
    }

    private void registerTopLevelParameters(Stream<? extends MetadataType> parameters, ComponentBuildingDefinition.Builder definitionBuilder, ClassLoader extensionClassLoader, DslSyntaxResolver dslSyntaxResolver, ExtensionParsingContext parsingContext, ReflectionCache reflectionCache) {
        parameters.filter(p -> IntrospectionUtils.isInstantiable((MetadataType)p, (ReflectionCache)reflectionCache)).forEach(subType -> this.registerTopLevelParameter((MetadataType)subType, definitionBuilder, extensionClassLoader, dslSyntaxResolver, parsingContext, reflectionCache));
    }

    private ExtensionParsingContext createParsingContext(ExtensionModel extensionModel) {
        return new ExtensionParsingContext(extensionModel);
    }

    public void setExtensionModels(Set<ExtensionModel> extensionModels) {
        this.extensions = extensionModels;
    }
}

