/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.classloading;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.StringContains;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.util.TestConnectivityUtils;
import org.mule.test.classloading.api.ClassLoadingHelper;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class ClassLoadingOnConnectionsTestCase
extends AbstractExtensionFunctionalTestCase {
    @Rule
    public SystemProperty disableTestConnectivity = TestConnectivityUtils.disableAutomaticTestConnectivity();

    protected void doTearDown() throws Exception {
        ClassLoadingHelper.createdClassLoaders.clear();
    }

    protected String getConfigFile() {
        return "classloading/classloading-extension-config.xml";
    }

    @Test
    public void noneConnectionProvider() throws Exception {
        this.flowRunner("none-operation").run();
        this.verifyUsedClassLoaders("allOptionalParameterGroup", "Connect", "Disconnect");
    }

    @Test
    public void cachedConnectionProvider() throws Exception {
        this.flowRunner("cached-operation").run();
        this.verifyUsedClassLoaders("allOptionalParameterGroup", "Connect");
    }

    @Test
    public void poolingConnectionProvider() throws Exception {
        this.flowRunner("pooling-operation").run();
        this.verifyUsedClassLoaders("allOptionalParameterGroup", "Connect", "OnBorrow", "OnReturn");
    }

    @Test
    public void allOptionalParameterGroup() throws Exception {
        this.verifyUsedClassLoaders("allOptionalParameterGroup");
    }

    void verifyUsedClassLoaders(String ... phasesToExecute) {
        Map createdClassLoaders = ClassLoadingHelper.createdClassLoaders;
        List<ClassLoader> collect = createdClassLoaders.values().stream().distinct().collect(Collectors.toList());
        collect.forEach(this::assertExtensionClassLoader);
        Set executedPhases = createdClassLoaders.keySet();
        MatcherAssert.assertThat(executedPhases, (Matcher)CoreMatchers.is((Matcher)IsCollectionContaining.hasItems((Matcher[])((Matcher[])Arrays.stream(phasesToExecute).map(StringContains::containsString).toArray(Matcher[]::new)))));
    }

    private void assertExtensionClassLoader(ClassLoader classLoader) {
        MatcherAssert.assertThat((Object)classLoader.toString(), (Matcher)AllOf.allOf((Matcher)StringContains.containsString((String)"classloading-extension"), (Matcher)CoreMatchers.anyOf((Matcher)StringContains.containsString((String)".TestRegionClassLoader[Region] @"), (Matcher)StringContains.containsString((String)"MuleArtifactClassLoader"))));
    }
}

