/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.PollingProber;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class ContentTypeHandlingTestCase
extends AbstractExtensionFunctionalTestCase {
    private static Charset customEncoding;
    private static final long PROBER_TIMEOUT = 15000L;
    private static final long PROBER_FREQUENCY = 1000L;
    @Rule
    public SystemProperty customEncodingProperty = new SystemProperty("customEncoding", customEncoding.name());

    protected String getConfigFile() {
        return "content-type-handling-config.xml";
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @BeforeClass
    public static void before() throws Exception {
        customEncoding = Charset.defaultCharset().equals(StandardCharsets.UTF_8) ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1;
    }

    @Before
    public void clearMediaTypes() {
        MediaTypeCollectorProcessor.clearMediaTypes();
    }

    @Test
    public void setsContentTypeOnXml() throws Exception {
        CoreEvent response = this.runFlow("setsContentTypeOnXml");
        DataType dataType = response.getMessage().getPayload().getDataType();
        this.assertCustomEncoding(dataType);
        Assert.assertThat((Object)dataType.getMediaType().getPrimaryType(), (Matcher)CoreMatchers.is((Object)MediaType.TEXT.getPrimaryType()));
        Assert.assertThat((Object)dataType.getMediaType().getSubType(), (Matcher)CoreMatchers.is((Object)MediaType.TEXT.getSubType()));
    }

    @Test
    public void onlySetEncodingOnXml() throws Exception {
        CoreEvent response = this.runFlow("onlySetEncodingOnXml");
        DataType dataType = response.getMessage().getPayload().getDataType();
        this.assertCustomEncoding(dataType);
    }

    @Test
    public void onlySetMimeTypeOnXml() throws Exception {
        CoreEvent response = this.runFlow("onlySetMimeTypeOnXml");
        DataType dataType = response.getMessage().getPayload().getDataType();
        this.assertDefaultEncoding(dataType);
        this.assertCustomMimeType(dataType);
    }

    @Test
    public void maintainsContentType() throws Exception {
        CoreEvent response = ((FlowRunner)this.flowRunner("defaultContentType").withPayload((Object)"")).run();
        DataType responseDataType = response.getMessage().getPayload().getDataType();
        this.assertDefaultEncoding(responseDataType);
        this.assertDefaultMimeType(responseDataType);
    }

    @Test
    public void setEncodingInMimeTypeAndParam() throws Exception {
        CoreEvent response = this.runFlow("setEncodingInMimeTypeAndParam");
        DataType dataType = response.getMessage().getPayload().getDataType();
        Assert.assertThat((Object)dataType.getMediaType().getPrimaryType(), (Matcher)CoreMatchers.is((Object)"application"));
        Assert.assertThat((Object)dataType.getMediaType().getSubType(), (Matcher)CoreMatchers.is((Object)"json"));
        Assert.assertThat(dataType.getMediaType().getCharset().get(), (Matcher)CoreMatchers.is((Object)StandardCharsets.UTF_16));
    }

    @Test
    public void overridesContentType() throws Exception {
        Charset lastSupportedEncoding = Charset.availableCharsets().values().stream().reduce((first, last) -> last).get();
        CoreEvent response = this.runFlow("setsContentTypeProgrammatically");
        DataType dataType = response.getMessage().getPayload().getDataType();
        this.assertCustomMimeType(dataType);
        Assert.assertThat(dataType.getMediaType().getCharset().get(), (Matcher)CoreMatchers.is((Object)lastSupportedEncoding));
    }

    @Test
    public void sourceOverridesContentType() throws Exception {
        this.startFlow("sourceMimeType");
        PollingProber.check((long)15000L, (long)1000L, () -> {
            if (MediaTypeCollectorProcessor.getMediaTypes().size() == 2) {
                return true;
            }
            return false;
        });
        Assert.assertThat((Object)((Charset)MediaTypeCollectorProcessor.getMediaTypes().get(0).getCharset().get()).displayName(), (Matcher)CoreMatchers.is((Object)"UTF-16"));
        Assert.assertThat((Object)MediaTypeCollectorProcessor.getMediaTypes().get(0).getPrimaryType(), (Matcher)CoreMatchers.is((Object)"pet"));
        Assert.assertThat((Object)MediaTypeCollectorProcessor.getMediaTypes().get(0).getSubType(), (Matcher)CoreMatchers.is((Object)"plain"));
        Assert.assertThat((Object)MediaTypeCollectorProcessor.getMediaTypes().get(0).getParameter("header"), (Matcher)CoreMatchers.is((Object)"false"));
        Assert.assertThat((Object)MediaTypeCollectorProcessor.getMediaTypes().get(1).getPrimaryType(), (Matcher)CoreMatchers.is((Object)"dead"));
        Assert.assertThat((Object)MediaTypeCollectorProcessor.getMediaTypes().get(1).getSubType(), (Matcher)CoreMatchers.is((Object)"json"));
    }

    @Test
    public void sourceWithAListAsResultOverridesContentType() throws Exception {
        this.startFlow("sourceListMimeType");
        PollingProber.check((long)15000L, (long)1000L, () -> MediaTypeCollectorProcessor.getMediaTypes().size() == 3);
        Assert.assertTrue((boolean)MediaTypeCollectorProcessor.getMediaTypes().stream().allMatch(mediaType -> mediaType.getPrimaryType().equals("pet")));
        Assert.assertTrue((boolean)MediaTypeCollectorProcessor.getMediaTypes().stream().allMatch(mediaType -> mediaType.getSubType().equals("plain")));
    }

    @Test
    public void operationWithListResultStringOutputOverridesContentType() throws Exception {
        this.runFlow("listStringMediaType");
        Assert.assertTrue((boolean)MediaTypeCollectorProcessor.getMediaTypes().stream().allMatch(mediaType -> mediaType.getPrimaryType().equals("application")));
        Assert.assertTrue((boolean)MediaTypeCollectorProcessor.getMediaTypes().stream().allMatch(mediaType -> mediaType.getSubType().equals("java")));
    }

    @Test
    public void operationWithListResultStreamOutputOverridesContentType() throws Exception {
        this.runFlow("listStreamMediaType");
        Assert.assertTrue((boolean)MediaTypeCollectorProcessor.getMediaTypes().stream().allMatch(mediaType -> ((Charset)mediaType.getCharset().get()).displayName().equals("UTF-16")));
        Assert.assertTrue((boolean)MediaTypeCollectorProcessor.getMediaTypes().stream().allMatch(mediaType -> mediaType.getPrimaryType().equals("application")));
        Assert.assertTrue((boolean)MediaTypeCollectorProcessor.getMediaTypes().stream().allMatch(mediaType -> mediaType.getSubType().equals("java")));
    }

    @Test
    public void operationWithPagingProviderResultCursorProviderOutputOverridesContentType() throws Exception {
        this.runFlow("pagedCursorProviderMediaType");
        Assert.assertTrue((boolean)MediaTypeCollectorProcessor.getMediaTypes().stream().allMatch(mediaType -> ((Charset)mediaType.getCharset().get()).displayName().equals("UTF-16")));
        Assert.assertTrue((boolean)MediaTypeCollectorProcessor.getMediaTypes().stream().allMatch(mediaType -> mediaType.getPrimaryType().equals("application")));
        Assert.assertTrue((boolean)MediaTypeCollectorProcessor.getMediaTypes().stream().allMatch(mediaType -> mediaType.getSubType().equals("java")));
    }

    @Test
    public void strictMimeType() throws Exception {
        CoreEvent response = this.runFlow("strictMimeType");
        Assert.assertThat((Object)response.getMessage().getPayload().getDataType().getMediaType().matches(MediaType.TEXT), (Matcher)CoreMatchers.is((Object)true));
    }

    private void startFlow(String flowName) throws Exception {
        ((Startable)this.getFlowConstruct(flowName)).start();
    }

    private void assertCustomMimeType(DataType dataType) {
        Assert.assertThat((Object)dataType.getMediaType().getPrimaryType(), (Matcher)CoreMatchers.is((Object)"dead"));
        Assert.assertThat((Object)dataType.getMediaType().getSubType(), (Matcher)CoreMatchers.is((Object)"dead"));
    }

    private void assertCustomEncoding(DataType dataType) {
        Assert.assertThat(dataType.getMediaType().getCharset().get(), (Matcher)CoreMatchers.is((Object)customEncoding));
    }

    private void assertDefaultEncoding(DataType dataType) throws Exception {
        Assert.assertThat(dataType.getMediaType().getCharset().get(), (Matcher)CoreMatchers.is((Object)SystemUtils.getDefaultEncoding((MuleContext)muleContext)));
    }

    private void assertDefaultMimeType(DataType dataType) throws Exception {
        Assert.assertThat((Object)dataType.getMediaType().getPrimaryType(), (Matcher)CoreMatchers.is((Object)this.getDefaultDataType().getMediaType().getPrimaryType()));
        Assert.assertThat((Object)dataType.getMediaType().getSubType(), (Matcher)CoreMatchers.is((Object)this.getDefaultDataType().getMediaType().getSubType()));
    }

    private DataType getDefaultDataType() {
        FlowRunner runner = (FlowRunner)this.flowRunner("defaultContentType").withPayload((Object)"");
        return runner.buildEvent().getMessage().getPayload().getDataType();
    }

    private static class MediaTypeCollectorProcessor
    extends AbstractComponent
    implements Processor {
        private static List<MediaType> MEDIA_TYPES = new LinkedList<MediaType>();

        private MediaTypeCollectorProcessor() {
        }

        public static List<MediaType> getMediaTypes() {
            return MEDIA_TYPES;
        }

        public static void clearMediaTypes() {
            MEDIA_TYPES = new LinkedList<MediaType>();
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            MEDIA_TYPES.add(event.getMessage().getPayload().getDataType().getMediaType());
            return event;
        }
    }
}

