/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.data.sample;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.data.sample.SampleDataService;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.data.sample.SampleDataTestUtils;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.test.runner.ArtifactClassLoaderRunnerConfig;

@ArtifactClassLoaderRunnerConfig(applicationSharedRuntimeLibs={"org.mule.tests:mule-tests-model"})
public abstract class AbstractSampleDataTestCase
extends MuleArtifactFunctionalTestCase {
    protected static final String EXPECTED_PAYLOAD = "my payload";
    protected static final String EXPECTED_ATTRIBUTES = "my attributes";
    protected static final String CONF_PREFIX = "from-conf-";
    protected static final String NULL_VALUE = "<<null>>";
    @Inject
    @Named(value="_muleSampleDataService")
    private SampleDataService sampleDataService;
    @Inject
    private ExtensionManager extensionManager;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public boolean disableXmlValidations() {
        return true;
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    protected void assertMessage(Message message, String payload, String attributes) {
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)payload));
        Assert.assertThat((Object)message.getPayload().getDataType().getMediaType().matches(MediaType.APPLICATION_JSON), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.equalTo((Object)attributes));
        Assert.assertThat((Object)message.getAttributes().getDataType().getMediaType().matches(MediaType.APPLICATION_XML), (Matcher)CoreMatchers.is((Object)true));
    }

    protected Message getOperationSampleByLocation(String flowName) throws SampleDataException {
        Location location = Location.builder().globalName(flowName).addProcessorsPart().addIndexPart(0).build();
        return this.sampleDataService.getSampleData(location);
    }

    protected Message getSourceSampleByLocation(String flowName) throws SampleDataException {
        Location location = Location.builder().globalName(flowName).addSourcePart().build();
        return this.sampleDataService.getSampleData(location);
    }

    protected Message getSampleByComponentName(String componentName, Map<String, Object> parameters, String configName) throws SampleDataException {
        return this.sampleDataService.getSampleData("SampleData", componentName, parameters, this.getConfigurationSupplier(configName));
    }

    private Supplier<Optional<ConfigurationInstance>> getConfigurationSupplier(String configName) {
        if (configName == null) {
            return Optional::empty;
        }
        return () -> Optional.of(this.extensionManager.getConfiguration(configName, this.testEvent()));
    }

    protected void expectSampleDataException(String failureCode) {
        this.expectedException.expect(SampleDataException.class);
        this.expectedException.expect(SampleDataTestUtils.exceptionMatcher((String)failureCode));
    }

    protected void expectSampleDataException(Class<? extends SampleDataException> sampleDataExceptionClass, String failureCode, String errorMessage, Optional<Class<? extends Throwable>> causeClass) {
        this.expectedException.expect(sampleDataExceptionClass);
        this.expectedException.expect(SampleDataTestUtils.exceptionMatcher((String)failureCode));
        this.expectedException.expectMessage(errorMessage);
        if (causeClass.isPresent()) {
            this.expectedException.expectCause(CoreMatchers.instanceOf(causeClass.get()));
        } else {
            this.expectedException.expectCause(CoreMatchers.nullValue(Throwable.class));
        }
    }

    protected Map<String, Object> getDefaultParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("payload", EXPECTED_PAYLOAD);
        params.put("attributes", EXPECTED_ATTRIBUTES);
        return params;
    }

    protected Map<String, Object> getGroupParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("groupParameter", EXPECTED_PAYLOAD);
        params.put("optionalParameter", EXPECTED_ATTRIBUTES);
        return params;
    }
}

