/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.metadata;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.tck.junit4.matcher.metadata.MetadataKeyResultSuccessMatcher;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class ConfigMetadataKeysTestCase
extends AbstractExtensionFunctionalTestCase {
    @Inject
    private MetadataService metadataManager;

    protected String getConfigFile() {
        return "vegan-config.xml";
    }

    @Test
    public void getMetadataKeysForConfig() throws Exception {
        MetadataResult metadataKeysResult = this.metadataManager.getMetadataKeys(Location.builder().globalName("apple").build());
        Assert.assertThat((Object)metadataKeysResult, (Matcher)MetadataKeyResultSuccessMatcher.isSuccess());
        Map<String, Set<MetadataKey>> metadataKeys = this.getKeyMapFromContainer((MetadataResult<MetadataKeysContainer>)metadataKeysResult);
        Assert.assertThat((Object)metadataKeys.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)metadataKeys.get("HarvestedKeys").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void getMetadataKeysForConfigWithoutResolvers() throws Exception {
        MetadataResult metadataKeysResult = this.metadataManager.getMetadataKeys(Location.builder().globalName("banana").build());
        Assert.assertThat((Object)metadataKeysResult, (Matcher)MetadataKeyResultSuccessMatcher.isSuccess());
        Map<String, Set<MetadataKey>> metadataKeys = this.getKeyMapFromContainer((MetadataResult<MetadataKeysContainer>)metadataKeysResult);
        Assert.assertThat((Object)metadataKeys.isEmpty(), (Matcher)Is.is((Object)true));
    }

    private Map<String, Set<MetadataKey>> getKeyMapFromContainer(MetadataResult<MetadataKeysContainer> metadataKeysResult) {
        return ((MetadataKeysContainer)metadataKeysResult.get()).getCategories().stream().collect(Collectors.toMap(resolver -> resolver, resolver -> (Set)((MetadataKeysContainer)metadataKeysResult.get()).getKeys(resolver).get()));
    }
}

