/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.module.extension.api.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.runtime.module.extension.internal.capability.xml.extension.multiple.config.TestExtensionWithDocumentationAndMultipleConfig;
import org.mule.runtime.module.extension.internal.capability.xml.schema.DefaultExtensionSchemaGenerator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

@SmallTest
public class ExtensionResourcesGeneratorAnnotationProcessorTestCase
extends AbstractMuleTestCase {
    private static final String GROUP_PARAMETER_1 = "Group parameter 1";
    private static final String GROUP_PARAMETER_2 = "Group parameter 2";
    private XPath xpath;
    private DocumentBuilderFactory builderFactory;

    @Before
    public void before() throws Exception {
        XPathFactoryImpl xpathFactory = new XPathFactoryImpl();
        this.xpath = xpathFactory.newXPath();
        this.builderFactory = DocumentBuilderFactory.newInstance();
        this.builderFactory.setNamespaceAware(true);
    }

    @Test
    public void generateDocumentedSchema() throws Exception {
        ArgumentCaptor byteSourceCaptor = ArgumentCaptor.forClass(ByteSource.class);
        ByteSource byteSource = (ByteSource)Mockito.mock(ByteSource.class);
        Mockito.when((Object)byteSource.contentEquals((ByteSource)byteSourceCaptor.capture())).thenReturn((Object)true);
        DefaultJavaExtensionModelLoader loader = new DefaultJavaExtensionModelLoader();
        ExtensionModel model = loader.loadExtensionModel(TestExtensionWithDocumentationAndMultipleConfig.class.getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet()), (Map)ImmutableMap.builder().put((Object)"type", (Object)TestExtensionWithDocumentationAndMultipleConfig.class.getName()).put((Object)"version", (Object)"4.0.0").put((Object)"COMPILATION_MODE", (Object)true).build());
        String generatedSchema = new DefaultExtensionSchemaGenerator().generate(model, DslResolvingContext.getDefault(Collections.emptySet()));
        Assert.assertThat((Object)generatedSchema, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.assertXpath(generatedSchema, "//xs:attribute[@name='configParameter']/xs:annotation/xs:documentation", "Config parameter");
        this.assertXpath(generatedSchema, "//xs:attribute[@name='configParameterWithComplexJavadoc']/xs:annotation/xs:documentation", "Config Parameter with an Optional value");
        this.assertXpath(generatedSchema, "//xs:attribute[@name='value1']/xs:annotation/xs:documentation", GROUP_PARAMETER_1);
        this.assertXpath(generatedSchema, "//xs:attribute[@name='value2']/xs:annotation/xs:documentation", GROUP_PARAMETER_2);
        this.assertXpath(generatedSchema, "//xs:element[@name='operation']/xs:annotation/xs:documentation", "Test Operation");
        this.assertXpath(generatedSchema, "//xs:complexType[@name='OperationType']/xs:complexContent/xs:extension/xs:attribute[@name='value']/xs:annotation/xs:documentation", "test value");
        this.assertXpath(generatedSchema, "//xs:complexType[@name='OperationType']/xs:complexContent/xs:extension/xs:attribute[@name='value1']/xs:annotation/xs:documentation", GROUP_PARAMETER_1);
        this.assertXpath(generatedSchema, "//xs:complexType[@name='OperationType']/xs:complexContent/xs:extension/xs:attribute[@name='value2']/xs:annotation/xs:documentation", GROUP_PARAMETER_2);
        this.assertXpath(generatedSchema, "//xs:element[@name='ignore-operation-should-be-ignored']/xs:annotation/xs:documentation", "");
        this.assertXpath(generatedSchema, "//xs:element[@name='private-operation-should-be-ignored']/xs:annotation/xs:documentation", "");
        this.assertXpath(generatedSchema, "//xs:element[@name='operation-with-blank-parameter-description']/xs:annotation/xs:documentation", "Test Operation with blank parameter description");
        this.assertXpath(generatedSchema, "//xs:complexType[@name='OperationWithBlankParameterDescriptionType']/xs:complexContent/xs:extension/xs:attribute[@name='value']/xs:annotation/xs:documentation", "");
        this.assertXpath(generatedSchema, "//xs:element[@name='operation-with-javadoc-link-references']/xs:annotation/xs:documentation", "Operation that returns a String value");
        this.assertXpath(generatedSchema, "//xs:complexType[@name='OperationWithJavadocLinkReferencesType']/xs:complexContent/xs:extension/xs:attribute[@name='value']/xs:annotation/xs:documentation", "this is the String to be returned");
    }

    private void assertXpath(String input, String expression, String expected) throws Exception {
        Assert.assertThat((Object)this.xpath(input, expression), (Matcher)CoreMatchers.is((Object)expected));
    }

    private String xpath(String input, String expression) throws Exception {
        Document node = this.builderFactory.newDocumentBuilder().parse(new InputSource(new StringReader(input)));
        return (String)this.xpath.evaluate(expression, node, XPathConstants.STRING);
    }
}

