/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml;

import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.extension.api.annotation.dsl.xml.Xml;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaXmlDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class JavaXmlDeclarationEnricherTestCase
extends AbstractMuleTestCase {
    private static final String NAMESPACE = "namespace";
    private static final String NAMESPACE_LOCATION = "NAMESPACE_LOCATION";
    private static final String DEFAULT_NAMESPACE_LOCATION_MASK = "http://www.mulesoft.org/schema/mule/%s";
    private static final String DEFAULT_SCHEMA_LOCATION_MASK = "%s/current/%s";
    private static final String XSD_FILENAME_MASK = "mule-%s.xsd";
    private static final String EXTENSION = "Extension";
    private static final String EXTENSION_NAME = "Xml Model Extension";
    private static final String EXTENSION_HYPHENAZED_NAME = "xml-model";
    private static final String EXTENSION_VERSION = "3.7";
    private ExtensionDeclarer extensionDeclarer = new ExtensionDeclarer();
    private DeclarationEnricher declarationEnricher = new JavaXmlDeclarationEnricher();

    @Test
    public void enrichWithCustomValues() {
        this.extensionDeclarer.named(EXTENSION_NAME).onVersion(EXTENSION_VERSION);
        XmlDslModel dslModel = this.enrich(XmlSupport.class);
        Assert.assertThat((Object)dslModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)dslModel.getSchemaVersion(), (Matcher)CoreMatchers.is((Object)EXTENSION_VERSION));
        Assert.assertThat((Object)dslModel.getPrefix(), (Matcher)CoreMatchers.is((Object)NAMESPACE));
        Assert.assertThat((Object)dslModel.getNamespace(), (Matcher)CoreMatchers.is((Object)NAMESPACE_LOCATION));
        Assert.assertThat((Object)dslModel.getXsdFileName(), (Matcher)CoreMatchers.is((Object)String.format(XSD_FILENAME_MASK, NAMESPACE)));
        Assert.assertThat((Object)dslModel.getSchemaLocation(), (Matcher)CoreMatchers.is((Object)String.format(DEFAULT_SCHEMA_LOCATION_MASK, NAMESPACE_LOCATION, String.format(XSD_FILENAME_MASK, NAMESPACE))));
    }

    @Test
    public void enrichWithDefaultValues() {
        this.extensionDeclarer.named(EXTENSION_NAME).onVersion(EXTENSION_VERSION);
        XmlDslModel dslModel = this.enrich(NoXmlSupport.class);
        Assert.assertThat((Object)dslModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)dslModel.getSchemaVersion(), (Matcher)CoreMatchers.is((Object)EXTENSION_VERSION));
        Assert.assertThat((Object)dslModel.getPrefix(), (Matcher)CoreMatchers.is((Object)EXTENSION_HYPHENAZED_NAME));
        Assert.assertThat((Object)dslModel.getNamespace(), (Matcher)CoreMatchers.equalTo((Object)String.format(DEFAULT_NAMESPACE_LOCATION_MASK, EXTENSION_HYPHENAZED_NAME)));
        Assert.assertThat((Object)dslModel.getXsdFileName(), (Matcher)CoreMatchers.is((Object)String.format(XSD_FILENAME_MASK, EXTENSION_HYPHENAZED_NAME)));
        Assert.assertThat((Object)dslModel.getSchemaLocation(), (Matcher)CoreMatchers.is((Object)String.format(DEFAULT_SCHEMA_LOCATION_MASK, String.format(DEFAULT_NAMESPACE_LOCATION_MASK, EXTENSION_HYPHENAZED_NAME), String.format(XSD_FILENAME_MASK, EXTENSION_HYPHENAZED_NAME))));
    }

    @Test
    public void enrichWithCustomNamespaceValue() {
        this.extensionDeclarer.named(EXTENSION_NAME).onVersion(EXTENSION_VERSION);
        XmlDslModel dslModel = this.enrich(DefaultXmlExtension.class);
        Assert.assertThat((Object)dslModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)dslModel.getSchemaVersion(), (Matcher)CoreMatchers.is((Object)EXTENSION_VERSION));
        Assert.assertThat((Object)dslModel.getPrefix(), (Matcher)CoreMatchers.is((Object)NAMESPACE));
        Assert.assertThat((Object)dslModel.getNamespace(), (Matcher)CoreMatchers.equalTo((Object)String.format(DEFAULT_NAMESPACE_LOCATION_MASK, NAMESPACE)));
        Assert.assertThat((Object)dslModel.getXsdFileName(), (Matcher)CoreMatchers.is((Object)String.format(XSD_FILENAME_MASK, NAMESPACE)));
        Assert.assertThat((Object)dslModel.getSchemaLocation(), (Matcher)CoreMatchers.is((Object)String.format(DEFAULT_SCHEMA_LOCATION_MASK, String.format(DEFAULT_NAMESPACE_LOCATION_MASK, NAMESPACE), String.format(XSD_FILENAME_MASK, NAMESPACE))));
    }

    @Test
    public void enrichWithCustomSchemaLocationValue() {
        this.extensionDeclarer.named(EXTENSION).onVersion(EXTENSION_VERSION);
        XmlDslModel dslModel = this.enrich(CustomSchemaLocationXmlExtension.class);
        Assert.assertThat((Object)dslModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)dslModel.getSchemaVersion(), (Matcher)CoreMatchers.is((Object)EXTENSION_VERSION));
        Assert.assertThat((Object)dslModel.getPrefix(), (Matcher)CoreMatchers.is((Object)EXTENSION.toLowerCase()));
        Assert.assertThat((Object)dslModel.getNamespace(), (Matcher)CoreMatchers.equalTo((Object)NAMESPACE_LOCATION));
        Assert.assertThat((Object)dslModel.getXsdFileName(), (Matcher)CoreMatchers.is((Object)String.format(XSD_FILENAME_MASK, NameUtils.hyphenize((String)EXTENSION))));
        Assert.assertThat((Object)dslModel.getSchemaLocation(), (Matcher)CoreMatchers.is((Object)String.format(DEFAULT_SCHEMA_LOCATION_MASK, NAMESPACE_LOCATION, String.format(XSD_FILENAME_MASK, NameUtils.hyphenize((String)EXTENSION)))));
    }

    private XmlDslModel enrich(Class<?> type) {
        this.extensionDeclarer.withModelProperty((ModelProperty)new ImplementingTypeModelProperty(type));
        this.declarationEnricher.enrich((ExtensionLoadingContext)new DefaultExtensionLoadingContext(this.extensionDeclarer, type.getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet())));
        return ((ExtensionDeclaration)this.extensionDeclarer.getDeclaration()).getXmlDslModel();
    }

    private static class NoXmlSupport {
        private NoXmlSupport() {
        }
    }

    @Xml(namespace="NAMESPACE_LOCATION")
    private static class CustomSchemaLocationXmlExtension {
        private CustomSchemaLocationXmlExtension() {
        }
    }

    @Xml(prefix="namespace")
    private static class DefaultXmlExtension {
        private DefaultXmlExtension() {
        }
    }

    @Xml(prefix="namespace", namespace="NAMESPACE_LOCATION")
    private static class XmlSupport {
        private XmlSupport() {
        }
    }
}

