/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.connectivity.schema;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assume;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.extension.test.extension.reconnection.ReconnectionExtension;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.declaration.fluent.HasSemanticTerms;
import org.mule.runtime.api.util.NameUtils;
import org.mule.runtime.connectivity.api.platform.schema.ConnectivitySchema;
import org.mule.runtime.connectivity.api.platform.schema.ExchangeAssetDescriptor;
import org.mule.runtime.connectivity.api.platform.schema.generator.ConnectivitySchemaGenerator;
import org.mule.runtime.connectivity.api.platform.schema.generator.ConnectivitySchemaGeneratorBuilder;
import org.mule.runtime.connectivity.api.platform.schema.persistence.ConnectivitySchemaJsonSerializer;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.FileGenerationParameterizedExtensionModelTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.data.sample.extension.SampleDataExtension;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.implicit.config.extension.extension.api.ImplicitConfigExtension;
import org.mule.test.marvel.MarvelExtension;
import org.mule.test.metadata.extension.MetadataExtension;
import org.mule.test.nonimplicit.config.extension.extension.api.NonImplicitConfigExtension;
import org.mule.test.oauth.TestOAuthExtension;
import org.mule.test.petstore.extension.PetStoreConnector;
import org.mule.test.ram.RickAndMortyExtension;
import org.mule.test.semantic.extension.SemanticTermsExtension;
import org.mule.test.subtypes.extension.SubTypesMappingConnector;
import org.mule.test.transactional.TransactionalExtension;
import org.mule.test.values.extension.ValuesExtension;
import org.mule.test.vegan.extension.VeganExtension;
import org.skyscreamer.jsonassert.JSONAssert;

@SmallTest
@RunWith(value=Parameterized.class)
public class ConnectivitySchemaGeneratorTestCase
extends FileGenerationParameterizedExtensionModelTestCase {
    private static final boolean UPDATE_EXPECTED_FILES_ON_ERROR = Boolean.getBoolean("mule.connectivitySchemas.updateExpectedFilesOnError");
    private final ConnectivitySchemaGenerator generator = ConnectivitySchemaGeneratorBuilder.newInstance().setConnectionTermsExtractor(HasSemanticTerms::getSemanticTerms).setParameterTermsExtractor(HasSemanticTerms::getSemanticTerms).setTypeTermsExtractor(ExtensionMetadataTypeUtils::getSemanticTerms).build();
    private final ConnectivitySchemaJsonSerializer serializer = ConnectivitySchemaJsonSerializer.builder().build();

    @Before
    public void setUp() throws Exception {
        Assume.assumeThat((Object)SystemUtils.IS_JAVA_1_8, (Matcher)Matchers.is((Object)true));
    }

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() {
        List<FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest> extensions = Arrays.asList(FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, VeganExtension.class, "vegan.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, PetStoreConnector.class, "petstore.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, MetadataExtension.class, "metadata.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, HeisenbergExtension.class, "heisenberg.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, TransactionalExtension.class, "tx-ext.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, SubTypesMappingConnector.class, "subtypes.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, MarvelExtension.class, "marvel.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(SOAP_LOADER, RickAndMortyExtension.class, "ram.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, TestOAuthExtension.class, "test-oauth.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, ValuesExtension.class, "values.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, SampleDataExtension.class, "sample-data.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, ImplicitConfigExtension.class, "implicit-config.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, NonImplicitConfigExtension.class, "non-implicit-config.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, SemanticTermsExtension.class, "semantic-terms-extension.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, ReconnectionExtension.class, "reconnection-extension.json"));
        return ConnectivitySchemaGeneratorTestCase.createExtensionModels(extensions);
    }

    @Override
    protected String getExpectedFilesDir() {
        return "connectivity-schemas/";
    }

    @Override
    protected boolean shouldUpdateExpectedFilesOnError() {
        return UPDATE_EXPECTED_FILES_ON_ERROR;
    }

    @Override
    protected String doGenerate(ExtensionModel extensionUnderTest) throws Exception {
        ExchangeAssetDescriptor exchangeAssetDescriptor = new ExchangeAssetDescriptor("org.mule.runtime.test.extension", "mule-connector-" + NameUtils.hyphenize((String)extensionUnderTest.getName().toLowerCase()).replaceAll(" ", "-"), "1.0.0");
        JSONArray array = new JSONArray();
        List schemas = this.generator.generateSchemas(extensionUnderTest, exchangeAssetDescriptor);
        for (ConnectivitySchema schema : schemas) {
            array.put((Object)new JSONObject(this.serializer.serialize(schema)));
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson(JsonParser.parseString((String)array.toString()));
    }

    @Override
    protected void assertEquals(String expectedContent, String actualContent) throws Exception {
        JSONAssert.assertEquals((String)expectedContent, (String)actualContent, (boolean)true);
    }
}

