/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.parameter.resolver;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.mule.test.heisenberg.extension.model.KnockeableDoor;
import org.mule.test.module.extension.parameter.resolver.AbstractParameterResolverTestCase;
import org.mule.test.parameter.resolver.extension.extension.ParameterResolverConfig;
import org.mule.test.parameter.resolver.extension.extension.SomeSource;

@Feature(value="Java SDK")
@Story(value="Parameters definitions in Java SDK")
public class ParameterResolverOnConfigTestCase
extends AbstractParameterResolverTestCase {
    protected String getConfigFile() {
        return "parameter/parameter-resolver-on-pojo-config.xml";
    }

    @Override
    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @Test
    public void configurationWithDynamicParameterResolvers() throws Exception {
        ParameterResolverConfig config = (ParameterResolverConfig)this.getPayload("configurationWithDynamicParameterResolvers");
        ParameterResolver doorResolver = config.getDoorResolver();
        ParameterResolver stringResolver = config.getStringResolver();
        this.assertParameterResolver(doorResolver, Optional.of("#[app.registry.staticDoor]"), CoreMatchers.is((Matcher)CoreMatchers.instanceOf(KnockeableDoor.class)));
        this.assertParameterResolver(stringResolver, Optional.of("#[payload]"), CoreMatchers.is((Object)"this is the payload"));
        Assert.assertThat(config.getLiteralDoor().getLiteralValue().get(), (Matcher)CoreMatchers.equalTo((Object)"#[aDoor]"));
    }

    @Test
    public void configurationWithStaticParameterResolvers() throws Exception {
        ParameterResolverConfig config = (ParameterResolverConfig)this.getPayload("configurationWithStaticParameterResolvers");
        ParameterResolver doorResolver = config.getDoorResolver();
        ParameterResolver stringResolver = config.getStringResolver();
        this.assertParameterResolver(doorResolver, Optional.empty(), CoreMatchers.is((Matcher)CoreMatchers.instanceOf(KnockeableDoor.class)));
        this.assertParameterResolver(stringResolver, Optional.empty(), CoreMatchers.is((Object)"this is a string"));
    }

    @Test
    public void sourceWithParameterResolver() {
        this.assertParameterResolver(SomeSource.someString, Optional.empty(), CoreMatchers.is((Object)"this is not an expression"));
    }

    @Test
    public void sourceWithLiteral() {
        Assert.assertThat(SomeSource.literalString.getLiteralValue().get(), (Matcher)CoreMatchers.equalTo((Object)"#[literal]"));
    }
}

