/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.transaction;

import javax.transaction.TransactionManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.transactional.TransactionalSource;
import org.mule.test.transactional.connection.MessageStorage;
import org.mule.test.transactional.connection.TestTransactionalConnection;

public class TransactionalSourceTestCase
extends AbstractExtensionFunctionalTestCase {
    @Rule
    public SystemProperty systemProperty = new SystemProperty("mule.tx.error.when.timeout", "true");

    protected String getConfigFile() {
        return "source-transaction-config.xml";
    }

    @Before
    public void setUp() throws Exception {
        MessageStorage.clean();
        TransactionalSource.isSuccess = null;
        muleContext.setTransactionManager((TransactionManager)Mockito.mock(TransactionManager.class));
    }

    @After
    public void tearDown() {
        MessageStorage.clean();
        TransactionalSource.isSuccess = null;
    }

    @Test
    public void sourceStartsALocalTxAndGetsCommitted() throws Exception {
        this.startFlow("sourceStartsALocalTxAndGetsCommitted");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> !MessageStorage.messages.isEmpty()));
        this.validateSuccessFlow();
        this.validateCommittedTransaction((TestTransactionalConnection)MessageStorage.messages.poll());
    }

    @Test
    public void sourceStartsALocalTxAndGetsRollBacked() throws Exception {
        this.startFlow("sourceStartsALocalTxAndGetsRollBacked");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> !MessageStorage.messages.isEmpty()));
        this.validateErrorFlow();
        this.validateRolledBackedTransaction((TestTransactionalConnection)MessageStorage.messages.poll());
    }

    @Test
    public void sourceStartsALocalTxAndOperationsCanJointIt() throws Exception {
        this.startFlow("sourceStartsALocalTxAndOperationsCanJointIt");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> MessageStorage.messages.size() == 2));
        this.validateSuccessFlow();
        this.validateCommittedTransaction((TestTransactionalConnection)MessageStorage.messages.peek());
    }

    @Test
    public void sourceStartsALocalTxAndOperationsWithDifferentConnectionCanTJoinIt() throws Exception {
        this.startFlow("sourceStartsALocalTxAndOperationsWithDifferentConnectionCanTJoinIt");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> MessageStorage.exception != null));
        MatcherAssert.assertThat((Object)MessageStorage.exception, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TransactionException.class)));
        this.validateErrorFlow();
        this.validateRolledBackedTransaction((TestTransactionalConnection)MessageStorage.messages.poll());
    }

    @Test
    public void nonTxSourceDoesntBeginTx() throws Exception {
        this.startFlow("nonTxSourceDoesntBeginTx");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> !MessageStorage.messages.isEmpty()));
        this.validateSuccessFlow();
        this.validateNonTxConnection((TestTransactionalConnection)MessageStorage.messages.poll());
    }

    @Test
    public void nonTxSourceWithNonTxOperation() throws Exception {
        this.startFlow("nonTxSourceWithNonTxOperation");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> !MessageStorage.messages.isEmpty()));
        this.validateSuccessFlow();
        this.validateNonTxConnection((TestTransactionalConnection)MessageStorage.messages.poll());
    }

    @Test
    public void nonTxSourceWithTxInside() throws Exception {
        this.startFlow("nonTxSourceWithTxInside");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> !MessageStorage.messages.isEmpty()));
        this.validateSuccessFlow();
        this.validateNonTxConnection((TestTransactionalConnection)MessageStorage.messages.poll());
    }

    @Test
    public void sourceWithTxAndTimeout() throws Exception {
        this.startFlow("sourceWithTimeout");
        this.validateErrorFlow();
        this.validateRolledBackedTransaction((TestTransactionalConnection)MessageStorage.messages.poll());
    }

    private void startFlow(String flowName) throws Exception {
        ((Flow)this.getFlowConstruct(flowName)).start();
    }

    private void validate(CheckedSupplier<Boolean> validation) {
        new PollingProber(10000L, 100L).check((Probe)new JUnitLambdaProbe(validation));
    }

    private void validateCommittedTransaction(TestTransactionalConnection connection) {
        MatcherAssert.assertThat((Object)connection.isTransactionBegun(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)connection.isTransactionCommited(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)connection.isTransactionRolledback(), (Matcher)CoreMatchers.is((Object)false));
    }

    private void validateRolledBackedTransaction(TestTransactionalConnection connection) {
        MatcherAssert.assertThat((Object)connection.isTransactionBegun(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)connection.isTransactionCommited(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)connection.isTransactionRolledback(), (Matcher)CoreMatchers.is((Object)true));
    }

    private void validateNonTxConnection(TestTransactionalConnection connection) {
        MatcherAssert.assertThat((Object)connection.isTransactionBegun(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)connection.isTransactionCommited(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)connection.isTransactionRolledback(), (Matcher)CoreMatchers.is((Object)false));
    }

    private void validateSuccessFlow() {
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> TransactionalSource.isSuccess != null));
        MatcherAssert.assertThat((Object)TransactionalSource.isSuccess, (Matcher)CoreMatchers.is((Object)true));
    }

    private void validateErrorFlow() {
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> TransactionalSource.isSuccess != null));
        MatcherAssert.assertThat((Object)TransactionalSource.isSuccess, (Matcher)CoreMatchers.is((Object)false));
    }

    public static class SleepProcessor
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return event;
        }
    }
}

