/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runners.Parameterized;
import org.mockito.Mock;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.heisenberg.extension.MoneyLaunderingOperation;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class PagedOperationExecutionTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String SAUL_NEW_NUMBER = "123-12-3";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public SystemProperty withStatistics;
    @Mock
    private ConnectionManager connectionManager;

    @Parameterized.Parameters
    public static List<Object[]> data() {
        return Arrays.asList({"true"}, {"false"});
    }

    public PagedOperationExecutionTestCase(String enableStatistics) {
        this.withStatistics = new SystemProperty("mule.enable.statistics", enableStatistics);
    }

    protected String getConfigFile() {
        return "heisenberg-paged-operation-config.xml";
    }

    @Test
    public void basicPagedOperation() throws Exception {
        CursorIterator streamingIterator = this.getCursor("getPersonalInfo");
        MatcherAssert.assertThat((Object)streamingIterator.getSize(), (Matcher)Is.is((Object)11));
        while (streamingIterator.hasNext()) {
            MatcherAssert.assertThat((Object)streamingIterator.next(), (Matcher)Matchers.isIn((Collection)MoneyLaunderingOperation.INVOLVED_PEOPLE));
        }
    }

    @Test
    public void emptyPagedOperation() throws Exception {
        CursorIterator iterator = this.getCursor("emptyPagedOperation");
        MatcherAssert.assertThat((Object)iterator.hasNext(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)iterator.getSize(), (Matcher)Is.is((Object)0));
        MatcherAssert.assertThat((Object)MoneyLaunderingOperation.closeEmptyOperationCalls, (Matcher)Is.is((Object)1));
    }

    @Test
    public void pagedOperationException() throws Exception {
        this.expectedException.expectCause(Is.is((Matcher)Matchers.instanceOf(ConnectionException.class)));
        this.getCursor("failingPagedOperation").next();
    }

    @Test
    public void pagedOperationUsingConnection() throws Exception {
        CursorIterator iterator = this.getCursor("pagedOperationUsingConnection");
        MatcherAssert.assertThat((Object)iterator.next().toString(), (Matcher)Matchers.containsString((String)SAUL_NEW_NUMBER));
    }

    @Test
    public void pagedOperationWithStickyConnection() throws Exception {
        CursorIterator iterator = this.getCursor("pagedOperationWithStickyConnection");
        Integer connectionId1 = (Integer)iterator.next();
        Integer connectionId2 = (Integer)iterator.next();
        MatcherAssert.assertThat((Object)connectionId1, (Matcher)Matchers.equalTo((Object)connectionId2));
    }

    @Test
    public void pagedOperationWithExtensionClassLoader() throws Exception {
        CursorIterator iterator = this.getCursor("pagedOperationWithExtensionClassLoader");
        MatcherAssert.assertThat(iterator.next(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void pagingProviderIsClosedSafelyDuringExceptionOnFirstPage() throws Exception {
        PagedOperationExecutionTestCase.resetCounters();
        CursorIterator iterator = this.getCursorWithPayload("failAtClosePagedOperation", 1);
        iterator.next();
        MatcherAssert.assertThat((String)"Paging provider was not closed.", (Object)MoneyLaunderingOperation.closePagingProviderCalls, (Matcher)Is.is((Object)1));
    }

    @Test
    public void pagingProviderIsClosedSafelyAfterDataSourceIsFullyConsumed() throws Exception {
        PagedOperationExecutionTestCase.resetCounters();
        ((FlowRunner)this.flowRunner("consumeFailAtClosePagedOperation").withPayload((Object)4)).run();
        MatcherAssert.assertThat((String)"Paging provider was not closed.", (Object)MoneyLaunderingOperation.closePagingProviderCalls, (Matcher)Is.is((Object)1));
    }

    private <T> CursorIterator<T> getCursorWithPayload(String flowName, Object payload) throws Exception {
        CursorIteratorProvider provider = (CursorIteratorProvider)((FlowRunner)this.flowRunner(flowName).keepStreamsOpen().withPayload(payload)).run().getMessage().getPayload().getValue();
        return (CursorIterator)provider.openCursor();
    }

    private <T> CursorIterator<T> getCursor(String flowName) throws Exception {
        return this.getCursorWithPayload(flowName, "");
    }

    public static void resetCounters() {
        MoneyLaunderingOperation.closePagingProviderCalls = 0;
        MoneyLaunderingOperation.getPageCalls = 0;
    }
}

