/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.metadata;

import java.lang.reflect.Type;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.tck.junit4.matcher.MetadataKeyMatcher;
import org.mule.tck.junit4.matcher.metadata.MetadataKeyResultSuccessMatcher;
import org.mule.tck.message.StringAttributes;
import org.mule.test.metadata.extension.MetadataConnectionProvider;
import org.mule.test.metadata.extension.MetadataSource;
import org.mule.test.module.extension.metadata.MetadataExtensionFunctionalTestCase;

public class SourceMetadataTestCase
extends MetadataExtensionFunctionalTestCase<SourceModel> {
    private static final String EXPECTED_STARTED_SOURCE_KEY_ID = String.format("Source Started = [%s]", false);
    private static final String EXPECTED_STARTED_CONNECTION_PROVIDER_KEY_ID = String.format("Connection Provider Started = [%s]", true);

    public SourceMetadataTestCase(MetadataExtensionFunctionalTestCase.ResolutionType resolutionType) {
        super(resolutionType);
        this.provider = resolutionType == MetadataExtensionFunctionalTestCase.ResolutionType.EXPLICIT_RESOLUTION ? MetadataService::getSourceMetadata : (metadataService, componentId, key) -> metadataService.getSourceMetadata(componentId);
        this.location = Location.builder().globalName("sourceMetadata").addSourcePart().build();
    }

    @Before
    public void before() {
        MetadataConnectionProvider.STARTED = false;
        MetadataSource.STARTED = false;
    }

    protected String getConfigFile() {
        return "metadata-tests.xml";
    }

    @Test
    public void getSourceMetadataKeys() {
        MetadataResult metadataKeysResult = this.metadataService.getMetadataKeys(this.location);
        MatcherAssert.assertThat((Object)metadataKeysResult, (Matcher)MetadataKeyResultSuccessMatcher.isSuccess());
        Set<MetadataKey> metadataKeys = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        MatcherAssert.assertThat((Object)metadataKeys.size(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat(metadataKeys, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{MetadataKeyMatcher.metadataKeyWithId((String)"PERSON"), MetadataKeyMatcher.metadataKeyWithId((String)"CAR"), MetadataKeyMatcher.metadataKeyWithId((String)"HOUSE"), MetadataKeyMatcher.metadataKeyWithId((String)EXPECTED_STARTED_SOURCE_KEY_ID), MetadataKeyMatcher.metadataKeyWithId((String)EXPECTED_STARTED_CONNECTION_PROVIDER_KEY_ID)}));
    }

    @Test
    public void getSourceMetadataKeysMultiLevelExplicitResolution() {
        Location location = Location.builder().globalName("sourceMetadataWithPartialMultilevel").addSourcePart().build();
        MetadataResult metadataKeysResult = this.metadataService.getMetadataKeys(location, MetadataKeyBuilder.newKey((String)"AMERICA").withPartName("continent").build());
        MatcherAssert.assertThat((Object)metadataKeysResult, (Matcher)MetadataKeyResultSuccessMatcher.isSuccess());
        Set<MetadataKey> continents = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        MatcherAssert.assertThat(continents, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(continents, (Matcher)Matchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)"AMERICA").withDisplayName("AMERICA").withPartName("continent")));
        MatcherAssert.assertThat(continents, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)"EUROPE").withDisplayName("EUROPE").withPartName("continent"))));
    }

    @Test
    public void getSourceMetadataKeysMultiLevelShowInDsl() {
        Location location = Location.builder().globalName("sourceMetadataWithPartialMultiLevelShowInDsl").addSourcePart().build();
        MetadataResult metadataKeysResult = this.metadataService.getMetadataKeys(location);
        MatcherAssert.assertThat((Object)metadataKeysResult, (Matcher)MetadataKeyResultSuccessMatcher.isSuccess());
        Set<MetadataKey> continents = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        MatcherAssert.assertThat(continents, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(continents, (Matcher)Matchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)"AMERICA").withDisplayName("AMERICA").withPartName("continent")));
        MatcherAssert.assertThat(continents, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)"EUROPE").withDisplayName("EUROPE").withPartName("continent"))));
    }

    @Test
    public void twoLevelPartialMultilevelSourceMetadataKeysExplicitResolution() throws Exception {
        Location location = Location.builder().globalName("sourceMetadataWithPartialMultilevel").addSourcePart().build();
        MetadataResult metadataKeysResult = this.metadataService.getMetadataKeys(location, MetadataKeyBuilder.newKey((String)"AMERICA").withPartName("continent").withChild(MetadataKeyBuilder.newKey((String)"ARGENTINA").withPartName("country")).build());
        this.assertSuccessResult(metadataKeysResult);
        Set<MetadataKey> continents = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        MatcherAssert.assertThat(continents, (Matcher)Matchers.hasSize((int)1));
        Set countries = continents.iterator().next().getChilds();
        MatcherAssert.assertThat((Object)countries, (Matcher)Matchers.hasSize((int)1));
        Set cities = ((MetadataKey)countries.iterator().next()).getChilds();
        MatcherAssert.assertThat((Object)cities, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)cities, (Matcher)Matchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)"BA").withPartName("city")));
        MatcherAssert.assertThat((Object)cities, (Matcher)Matchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)"LPLT").withPartName("city")));
    }

    @Test
    public void getSourceDynamicOutputMetadata() throws Exception {
        MetadataResult result = this.getComponentDynamicMetadata(PERSON_METADATA_KEY);
        MatcherAssert.assertThat(result, (Matcher)MetadataKeyResultSuccessMatcher.isSuccess());
        ComponentMetadataDescriptor componentMetadata = (ComponentMetadataDescriptor)result.get();
        this.assertExpectedOutput((ConnectableComponentModel)componentMetadata.getModel(), this.personType, this.typeLoader.load(StringAttributes.class));
        MatcherAssert.assertThat(componentMetadata.getMetadataAttributes().getKey().get(), (Matcher)CoreMatchers.is((Object)PERSON_METADATA_KEY));
    }

    @Test
    public void getSourceDynamicOutputMetadataExplicitResolution() throws Exception {
        MetadataResult outputMetadataResult = this.metadataService.getOutputMetadata(this.location, PERSON_METADATA_KEY);
        MatcherAssert.assertThat((Object)outputMetadataResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        OutputMetadataDescriptor outputMetadataDescriptor = (OutputMetadataDescriptor)outputMetadataResult.get();
        MatcherAssert.assertThat((Object)outputMetadataDescriptor.getPayloadMetadata().isDynamic(), (Matcher)CoreMatchers.is((Object)true));
        this.assertExpectedType(outputMetadataDescriptor.getPayloadMetadata().getType(), this.personType);
    }

    @Test
    public void getSourceDynamicOutputAttributesMetadataExplicitResolution() throws Exception {
        MetadataResult outputMetadataResult = this.metadataService.getOutputMetadata(this.location, PERSON_METADATA_KEY);
        MatcherAssert.assertThat((Object)outputMetadataResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        OutputMetadataDescriptor outputMetadataDescriptor = (OutputMetadataDescriptor)outputMetadataResult.get();
        this.assertExpectedType(outputMetadataDescriptor.getAttributesMetadata().getType(), (Type)((Object)StringAttributes.class));
    }

    @Test
    public void getSourceMultilevelDynamicOutputMetadataImplicitResolution() throws Exception {
        Location location = Location.builder().globalName("sourceMetadataWithMultilevel").addSourcePart().build();
        MetadataResult outputMetadataResult = this.metadataService.getSourceMetadata(location);
        MatcherAssert.assertThat((Object)outputMetadataResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        SourceModel sourceModel = (SourceModel)((ComponentMetadataDescriptor)outputMetadataResult.get()).getModel();
        MetadataType outputType = sourceModel.getOutput().getType();
        MatcherAssert.assertThat((Object)outputType, (Matcher)CoreMatchers.instanceOf(ObjectType.class));
        ObjectType outputObjectType = (ObjectType)outputType;
        MatcherAssert.assertThat((Object)outputObjectType.getFieldByName("AMERICA").isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)outputObjectType.getFieldByName("ARGENTINA").isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)outputObjectType.getFieldByName("BA").isPresent(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void sourcesMustNotStartWhenResolvingMetadata() {
        MetadataResult metadataKeysResult = this.metadataService.getMetadataKeys(this.location);
        Set<MetadataKey> metadataKeys = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        MatcherAssert.assertThat(metadataKeys, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{MetadataKeyMatcher.metadataKeyWithId((String)EXPECTED_STARTED_SOURCE_KEY_ID)}));
    }

    @Test
    public void sourcesMustStartConnectionProvidersWhenResolvingMetadata() {
        MetadataResult metadataKeysResult = this.metadataService.getMetadataKeys(this.location);
        Set<MetadataKey> metadataKeys = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        MatcherAssert.assertThat(metadataKeys, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{MetadataKeyMatcher.metadataKeyWithId((String)EXPECTED_STARTED_CONNECTION_PROVIDER_KEY_ID)}));
    }
}

