/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.connector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.module.extension.config.PetStoreConnectionTestCase;
import org.mule.test.petstore.extension.PetStoreClient;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class PetStoreConnectionPoolingTestCase
extends PetStoreConnectionTestCase {
    private static final String CUSTOM_POOLING_CONFIG = "customPooling";
    private static final String CUSTOM_POOLING_POOLABLE_CONFIG = "customPoolingPoolable";
    private static final String NO_POOLING = "noPooling";
    @Rule
    public SystemProperty configNameProperty;
    private ExecutorService executorService = null;
    private Latch connectionLatch = new Latch();
    private CountDownLatch testLatch;
    protected int poolSize;
    protected String name;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({CUSTOM_POOLING_POOLABLE_CONFIG, 3}, {NO_POOLING, 0});
    }

    public PetStoreConnectionPoolingTestCase(String name, int poolSize) {
        this.name = name;
        this.poolSize = poolSize;
        this.configNameProperty = new SystemProperty("configName", name);
        this.testLatch = new CountDownLatch(poolSize);
    }

    protected String[] getConfigFiles() {
        return new String[]{"petstore-pooling-connection.xml", "petstore.xml"};
    }

    protected void doTearDown() throws Exception {
        super.doTearDown();
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    @Test
    public void exhaustion() throws Exception {
        if (NO_POOLING.equals(this.name)) {
            return;
        }
        this.executorService = Executors.newFixedThreadPool(this.poolSize);
        ArrayList<Future<PetStoreClient>> clients = new ArrayList<Future<PetStoreClient>>(this.poolSize);
        for (int i = 0; i < this.poolSize; ++i) {
            clients.add(this.getClientOnLatch());
        }
        this.testLatch.await();
        try {
            this.getClient();
            Assert.fail((String)("was expecting pool to be exhausted when using config: " + this.name));
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ConnectionException.class)));
        }
        this.connectionLatch.release();
        for (final Future future : clients) {
            PollingProber prober = new PollingProber(1000L, 100L);
            prober.check((Probe)new JUnitProbe(){

                protected boolean test() throws Exception {
                    PetStoreClient client = (PetStoreClient)future.get(100L, TimeUnit.MILLISECONDS);
                    PetStoreConnectionPoolingTestCase.this.assertValidClient(client);
                    return true;
                }

                public String describeFailure() {
                    return "Could not obtain valid client";
                }
            });
        }
        this.assertValidClient(this.getClient());
    }

    protected Future<PetStoreClient> getClientOnLatch() {
        return this.executorService.submit(() -> (PetStoreClient)((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner("getClientOnLatch").withPayload((Object)"")).withVariable("testLatch", (Object)this.testLatch)).withVariable("connectionLatch", (Object)this.connectionLatch)).run().getMessage().getPayload().getValue());
    }

    @Override
    protected void assertConnected(PetStoreClient client) {
        if (NO_POOLING.equals(this.name)) {
            Assert.assertThat((Object)client.hasActiveConnection(), (Matcher)CoreMatchers.is((Object)false));
        } else {
            super.assertConnected(client);
        }
    }

    @Override
    protected String getConfigName() {
        return this.name;
    }
}

