/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml;

import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.dsl.xml.Xml;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class JavaXmlModelDeclarationTestCase
extends AbstractMuleTestCase {
    private static final String NAMESPACE = "namespace";
    private static final String NAMESPACE_LOCATION = "NAMESPACE_LOCATION";
    private static final String DEFAULT_NAMESPACE_LOCATION_MASK = "http://www.mulesoft.org/schema/mule/%s";
    private static final String DEFAULT_SCHEMA_LOCATION_MASK = "%s/current/%s";
    private static final String XSD_FILENAME_MASK = "mule-%s.xsd";
    private static final String EXTENSION = "Extension";
    private static final String EXTENSION_NAME = "Xml Model Extension";
    private static final String EXTENSION_HYPHENAZED_NAME = "xml-model";
    private static final String EXTENSION_VERSION = "3.7";

    @Test
    public void withCustomValues() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(XmlSupport.class);
        XmlDslModel dslModel = extensionDeclaration.getXmlDslModel();
        Assert.assertThat((Object)dslModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)dslModel.getSchemaVersion(), (Matcher)CoreMatchers.is((Object)EXTENSION_VERSION));
        Assert.assertThat((Object)dslModel.getPrefix(), (Matcher)CoreMatchers.is((Object)NAMESPACE));
        Assert.assertThat((Object)dslModel.getNamespace(), (Matcher)CoreMatchers.is((Object)NAMESPACE_LOCATION));
        Assert.assertThat((Object)dslModel.getXsdFileName(), (Matcher)CoreMatchers.is((Object)String.format(XSD_FILENAME_MASK, NAMESPACE)));
        Assert.assertThat((Object)dslModel.getSchemaLocation(), (Matcher)CoreMatchers.is((Object)String.format(DEFAULT_SCHEMA_LOCATION_MASK, NAMESPACE_LOCATION, String.format(XSD_FILENAME_MASK, NAMESPACE))));
    }

    @Test
    public void withDefaultValues() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(NoXmlSupport.class);
        XmlDslModel dslModel = extensionDeclaration.getXmlDslModel();
        Assert.assertThat((Object)dslModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)dslModel.getSchemaVersion(), (Matcher)CoreMatchers.is((Object)EXTENSION_VERSION));
        Assert.assertThat((Object)dslModel.getPrefix(), (Matcher)CoreMatchers.is((Object)EXTENSION_HYPHENAZED_NAME));
        Assert.assertThat((Object)dslModel.getNamespace(), (Matcher)CoreMatchers.equalTo((Object)String.format(DEFAULT_NAMESPACE_LOCATION_MASK, EXTENSION_HYPHENAZED_NAME)));
        Assert.assertThat((Object)dslModel.getXsdFileName(), (Matcher)CoreMatchers.is((Object)String.format(XSD_FILENAME_MASK, EXTENSION_HYPHENAZED_NAME)));
        Assert.assertThat((Object)dslModel.getSchemaLocation(), (Matcher)CoreMatchers.is((Object)String.format(DEFAULT_SCHEMA_LOCATION_MASK, String.format(DEFAULT_NAMESPACE_LOCATION_MASK, EXTENSION_HYPHENAZED_NAME), String.format(XSD_FILENAME_MASK, EXTENSION_HYPHENAZED_NAME))));
    }

    @Test
    public void withCustomNamespaceValue() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(DefaultXmlExtension.class);
        XmlDslModel dslModel = extensionDeclaration.getXmlDslModel();
        Assert.assertThat((Object)dslModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)dslModel.getSchemaVersion(), (Matcher)CoreMatchers.is((Object)EXTENSION_VERSION));
        Assert.assertThat((Object)dslModel.getPrefix(), (Matcher)CoreMatchers.is((Object)NAMESPACE));
        Assert.assertThat((Object)dslModel.getNamespace(), (Matcher)CoreMatchers.equalTo((Object)String.format(DEFAULT_NAMESPACE_LOCATION_MASK, NAMESPACE)));
        Assert.assertThat((Object)dslModel.getXsdFileName(), (Matcher)CoreMatchers.is((Object)String.format(XSD_FILENAME_MASK, NAMESPACE)));
        Assert.assertThat((Object)dslModel.getSchemaLocation(), (Matcher)CoreMatchers.is((Object)String.format(DEFAULT_SCHEMA_LOCATION_MASK, String.format(DEFAULT_NAMESPACE_LOCATION_MASK, NAMESPACE), String.format(XSD_FILENAME_MASK, NAMESPACE))));
    }

    @Test
    public void withCustomSchemaLocationValue() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(CustomSchemaLocationXmlExtension.class);
        XmlDslModel dslModel = extensionDeclaration.getXmlDslModel();
        Assert.assertThat((Object)dslModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)dslModel.getSchemaVersion(), (Matcher)CoreMatchers.is((Object)EXTENSION_VERSION));
        Assert.assertThat((Object)dslModel.getPrefix(), (Matcher)CoreMatchers.is((Object)EXTENSION.toLowerCase()));
        Assert.assertThat((Object)dslModel.getNamespace(), (Matcher)CoreMatchers.equalTo((Object)NAMESPACE_LOCATION));
        Assert.assertThat((Object)dslModel.getXsdFileName(), (Matcher)CoreMatchers.is((Object)String.format(XSD_FILENAME_MASK, NameUtils.hyphenize((String)EXTENSION))));
        Assert.assertThat((Object)dslModel.getSchemaLocation(), (Matcher)CoreMatchers.is((Object)String.format(DEFAULT_SCHEMA_LOCATION_MASK, NAMESPACE_LOCATION, String.format(XSD_FILENAME_MASK, NameUtils.hyphenize((String)EXTENSION)))));
    }

    @Test
    public void withCustomValuesWithSdkAnnotation() {
        ExtensionDeclaration extensionDeclaration = this.getExtensionDeclaration(XmlSupportUsingSdkApi.class);
        XmlDslModel dslModel = extensionDeclaration.getXmlDslModel();
        Assert.assertThat((Object)dslModel, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)dslModel.getSchemaVersion(), (Matcher)CoreMatchers.is((Object)EXTENSION_VERSION));
        Assert.assertThat((Object)dslModel.getPrefix(), (Matcher)CoreMatchers.is((Object)NAMESPACE));
        Assert.assertThat((Object)dslModel.getNamespace(), (Matcher)CoreMatchers.is((Object)NAMESPACE_LOCATION));
        Assert.assertThat((Object)dslModel.getXsdFileName(), (Matcher)CoreMatchers.is((Object)String.format(XSD_FILENAME_MASK, NAMESPACE)));
        Assert.assertThat((Object)dslModel.getSchemaLocation(), (Matcher)CoreMatchers.is((Object)String.format(DEFAULT_SCHEMA_LOCATION_MASK, NAMESPACE_LOCATION, String.format(XSD_FILENAME_MASK, NAMESPACE))));
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void withSdkXmlAndLegacyXmlAnnotation() {
        this.getExtensionDeclaration(InvalidXmlSupport.class);
    }

    private ExtensionDeclaration getExtensionDeclaration(Class<?> extensionClass) {
        ExtensionDeclarer declarer = new DefaultJavaModelLoaderDelegate(extensionClass, EXTENSION_VERSION).declare((ExtensionLoadingContext)new DefaultExtensionLoadingContext(((Object)((Object)this)).getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet())));
        return (ExtensionDeclaration)declarer.getDeclaration();
    }

    @Extension(name="Xml Model Extension")
    @Xml(prefix="namespace", namespace="NAMESPACE_LOCATION")
    @org.mule.sdk.api.annotation.dsl.xml.Xml(prefix="namespace", namespace="NAMESPACE_LOCATION")
    public static class InvalidXmlSupport {
    }

    @Extension(name="Xml Model Extension")
    @org.mule.sdk.api.annotation.dsl.xml.Xml(prefix="namespace", namespace="NAMESPACE_LOCATION")
    public static class XmlSupportUsingSdkApi {
    }

    @Extension(name="Xml Model Extension")
    public static class NoXmlSupport {
    }

    @Extension(name="Extension")
    @Xml(namespace="NAMESPACE_LOCATION")
    public static class CustomSchemaLocationXmlExtension {
    }

    @Extension(name="Xml Model Extension")
    @Xml(prefix="namespace")
    public static class DefaultXmlExtension {
    }

    @Extension(name="Xml Model Extension")
    @Xml(prefix="namespace", namespace="NAMESPACE_LOCATION")
    public static class XmlSupport {
    }
}

