/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.metadata;

import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.tck.junit4.matcher.MetadataKeyMatcher;
import org.mule.tck.junit4.matcher.metadata.MetadataKeyResultSuccessMatcher;
import org.mule.test.metadata.extension.model.shapes.Circle;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.module.extension.metadata.AbstractMetadataOperationTestCase;
import org.mule.test.module.extension.metadata.MetadataExtensionFunctionalTestCase;

public class QueryMetadataTestCase
extends AbstractMetadataOperationTestCase {
    private static final MetadataKey CIRCLE_METADATA_KEY = MetadataKeyBuilder.newKey((String)"Circle").build();
    private static final Location QUERY_LOCATION = Location.builder().globalName("queryListOperation").addProcessorsPart().addIndexPart(0).build();

    public QueryMetadataTestCase(MetadataExtensionFunctionalTestCase.ResolutionType resolutionType) {
        super(resolutionType);
    }

    protected String getConfigFile() {
        return "metadata-tests.xml";
    }

    @Test
    public void getEntityKeys() throws Exception {
        MetadataResult metadataKeysResult = this.metadataService.getEntityKeys(QUERY_LOCATION);
        Assert.assertThat((Object)metadataKeysResult, (Matcher)MetadataKeyResultSuccessMatcher.isSuccess());
        MetadataKeysContainer container = (MetadataKeysContainer)metadataKeysResult.get();
        Set metadataKeys = (Set)container.getKeys((String)container.getCategories().iterator().next()).get();
        Assert.assertThat((Object)metadataKeys.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)metadataKeys, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{MetadataKeyMatcher.metadataKeyWithId((String)"Circle"), MetadataKeyMatcher.metadataKeyWithId((String)"Square")}));
    }

    @Test
    public void getEntityMetadata() throws Exception {
        MetadataResult entityMetadata = this.metadataService.getEntityMetadata(QUERY_LOCATION, CIRCLE_METADATA_KEY);
        Assert.assertThat((Object)entityMetadata, (Matcher)MetadataKeyResultSuccessMatcher.isSuccess());
        TypeMetadataDescriptor descriptor = (TypeMetadataDescriptor)entityMetadata.get();
        Assert.assertThat((Object)descriptor.getType(), (Matcher)Matchers.is((Object)ExtensionsTestUtils.toMetadataType(Circle.class)));
    }

    @Test
    public void getDsqlQueryAutomaticGeneratedOutputMetadata() throws Exception {
        this.location = QUERY_LOCATION;
        MetadataKey dsqlKey = MetadataKeyBuilder.newKey((String)"dsql:SELECT id FROM Circle WHERE (diameter < 18)").build();
        MetadataResult entityMetadata = this.getComponentDynamicMetadata(dsqlKey);
        Assert.assertThat(entityMetadata, (Matcher)MetadataKeyResultSuccessMatcher.isSuccess());
        MetadataType generatedType = ((OperationModel)((ComponentMetadataDescriptor)entityMetadata.get()).getModel()).getOutput().getType();
        Assert.assertThat((Object)generatedType, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(ArrayType.class)));
        this.assertCircleType((ObjectType)((ArrayType)generatedType).getType());
    }

    @Test
    public void getNativeQueryOutputArrayMetadata() throws Exception {
        this.location = Location.builder().globalName("nativeQueryListOperation").addProcessorsPart().addIndexPart(0).build();
        MetadataKey nativeKey = MetadataKeyBuilder.newKey((String)"SELECT FIELDS: field-id FROM TYPE: Circle DO WHERE field-diameter < 18").build();
        MetadataResult entityMetadata = this.getComponentDynamicMetadata(nativeKey);
        Assert.assertThat(entityMetadata, (Matcher)MetadataKeyResultSuccessMatcher.isSuccess());
        MetadataType generatedType = ((OperationModel)((ComponentMetadataDescriptor)entityMetadata.get()).getModel()).getOutput().getType();
        Assert.assertThat((Object)generatedType, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(ArrayType.class)));
        this.assertCircleType((ObjectType)((ArrayType)generatedType).getType());
    }

    @Test
    public void getNativeQueryOutputMetadata() throws Exception {
        this.location = Location.builder().globalName("nativeQueryOperation").addProcessorsPart().addIndexPart(0).build();
        MetadataKey nativeKey = MetadataKeyBuilder.newKey((String)"SELECT FIELDS: field-id FROM TYPE: Circle DO WHERE field-diameter < 18").build();
        MetadataResult entityMetadata = this.getComponentDynamicMetadata(nativeKey);
        Assert.assertThat(entityMetadata, (Matcher)MetadataKeyResultSuccessMatcher.isSuccess());
        MetadataType generatedType = ((OperationModel)((ComponentMetadataDescriptor)entityMetadata.get()).getModel()).getOutput().getType();
        this.assertCircleType((ObjectType)generatedType);
    }

    private void assertCircleType(ObjectType fields) {
        Assert.assertThat((Object)fields.getFields(), (Matcher)Matchers.hasSize((int)1));
        ObjectFieldType field = (ObjectFieldType)fields.getFields().iterator().next();
        Assert.assertThat((Object)field.getKey().getName().getLocalPart(), (Matcher)Matchers.is((Object)"id"));
        Assert.assertThat((Object)field.getValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(NumberType.class)));
    }
}

