/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.dsl;

import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.NameUtils;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.dsl.syntax.resolver.ImportTypesStrategy;
import org.mule.runtime.extension.api.dsl.syntax.resolver.SingleExtensionImportTypesStrategy;
import org.mule.test.heisenberg.extension.model.CarWash;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class ComplexPojoDslSyntaxResolverTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String INVESTMENT_PLAN_B_NAME = "investmentPlanB";
    @Inject
    private ExtensionManager extensionManager;
    private ExtensionModel heisenbergExtensionModel;
    private DslSyntaxResolver dslSyntaxResolver;

    protected String getConfigFile() {
        return "source/heisenberg-source-config.xml";
    }

    @Before
    public void setup() {
        this.heisenbergExtensionModel = (ExtensionModel)this.extensionManager.getExtension("Heisenberg").get();
        this.dslSyntaxResolver = DslSyntaxResolver.getDefault((ExtensionModel)this.heisenbergExtensionModel, (ImportTypesStrategy)new SingleExtensionImportTypesStrategy());
    }

    @Test
    public void innerWrapperPojoIsShownAsChild() {
        MetadataType carWashType = (MetadataType)this.heisenbergExtensionModel.getTypes().stream().filter(metadataType -> metadataType.toString().contains(CarWash.class.getName())).findFirst().get();
        DslElementSyntax carWashDslElementSyntax = (DslElementSyntax)this.dslSyntaxResolver.resolve(carWashType).get();
        Assert.assertThat((Object)carWashDslElementSyntax.getChild(INVESTMENT_PLAN_B_NAME).isPresent(), (Matcher)CoreMatchers.is((Object)true));
        DslElementSyntax investmentPlanBElementSyntax = (DslElementSyntax)carWashDslElementSyntax.getChild(INVESTMENT_PLAN_B_NAME).get();
        Assert.assertThat((Object)investmentPlanBElementSyntax.supportsChildDeclaration(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)investmentPlanBElementSyntax.getElementName(), (Matcher)CoreMatchers.is((Object)NameUtils.hyphenize((String)INVESTMENT_PLAN_B_NAME)));
    }
}

