/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.transaction;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.extension.api.tx.SourceTransactionalAction;
import org.mule.sdk.api.tx.OperationTransactionalAction;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.transactional.TransactionalSourceWithTXParameters;

public class TransactionalActionParameterTestCase
extends AbstractExtensionFunctionalTestCase {
    protected String getConfigFile() {
        return "transactional-parameters-injection-config.xml";
    }

    @Test
    public void injectAlwaysBeginSourceTransactionalAction() throws Exception {
        Reference sourceTransactionalAction = new Reference();
        TransactionalSourceWithTXParameters.responseCallback = tx -> (SourceTransactionalAction)sourceTransactionalAction.set((Object)((SourceTransactionalAction)tx));
        this.startFlow("alwaysBeginTxAction");
        MatcherAssert.assertThat((Object)sourceTransactionalAction.get(), (Matcher)Is.is((Object)SourceTransactionalAction.ALWAYS_BEGIN));
    }

    @Test
    public void injectDefaultOperationTransactionalAction() throws Exception {
        org.mule.runtime.extension.api.tx.OperationTransactionalAction value = (org.mule.runtime.extension.api.tx.OperationTransactionalAction)this.flowRunner("injectInOperationDefaultValue").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)Is.is((Object)org.mule.runtime.extension.api.tx.OperationTransactionalAction.JOIN_IF_POSSIBLE));
    }

    @Test
    public void injectInOperationJoinNotSupported() throws Exception {
        org.mule.runtime.extension.api.tx.OperationTransactionalAction value = (org.mule.runtime.extension.api.tx.OperationTransactionalAction)this.flowRunner("injectInOperationJoinNotSupported").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)Is.is((Object)org.mule.runtime.extension.api.tx.OperationTransactionalAction.NOT_SUPPORTED));
    }

    @Test
    public void sdkInjectDefaultOperationTransactionalAction() throws Exception {
        OperationTransactionalAction value = (OperationTransactionalAction)this.flowRunner("sdkInjectInOperationDefaultValue").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)Is.is((Object)OperationTransactionalAction.JOIN_IF_POSSIBLE));
    }

    @Test
    public void sdkInjectInOperationJoinNotSupported() throws Exception {
        OperationTransactionalAction value = (OperationTransactionalAction)this.flowRunner("sdkInjectInOperationJoinNotSupported").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)Is.is((Object)OperationTransactionalAction.NOT_SUPPORTED));
    }

    private void startFlow(String flowName) throws Exception {
        ((Flow)this.getFlowConstruct(flowName)).start();
    }
}

