/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal;

import java.io.File;
import java.io.IOException;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.module.extension.internal.ParameterizedExtensionModelTestCase;

public abstract class FileGenerationParameterizedExtensionModelTestCase
extends ParameterizedExtensionModelTestCase {
    @Parameterized.Parameter(value=1)
    public String expectedFilePath;
    protected String expectedContent;

    @Before
    public void setup() throws IOException {
        this.expectedContent = IOUtils.getResourceAsString((String)(this.getExpectedFilesDir() + this.expectedFilePath), ((Object)((Object)this)).getClass());
    }

    @Test
    public final void generate() throws Exception {
        String actual = this.doGenerate(this.extensionUnderTest);
        try {
            this.assertEquals(this.expectedContent, actual);
        }
        catch (Throwable t) {
            if (this.shouldUpdateExpectedFilesOnError()) {
                File root = new File(IOUtils.getResourceAsUrl((String)(this.getExpectedFilesDir() + this.expectedFilePath), ((Object)((Object)this)).getClass()).toURI());
                root = root.getParentFile();
                while (!root.getName().equals("target")) {
                    root = root.getParentFile();
                }
                root = root.getParentFile();
                File testDir = new File(root, "src/test/resources/" + this.getExpectedFilesDir());
                File target = new File(testDir, this.expectedFilePath);
                FileUtils.stringToFile((String)target.getAbsolutePath(), (String)actual);
                System.out.println(this.expectedFilePath + " fixed");
            }
            throw t;
        }
    }

    protected abstract String doGenerate(ExtensionModel var1) throws Exception;

    protected abstract void assertEquals(String var1, String var2) throws Exception;

    protected abstract String getExpectedFilesDir();

    protected boolean shouldUpdateExpectedFilesOnError() {
        return false;
    }

    public static class ResourceExtensionUnitTest
    extends ParameterizedExtensionModelTestCase.ExtensionUnitTest {
        private final String filename;

        public static ResourceExtensionUnitTest newUnitTest(ExtensionModelLoader loader, Class<?> extensionClass, String filename) {
            return ResourceExtensionUnitTest.newUnitTest(loader, extensionClass, filename, null);
        }

        public static ResourceExtensionUnitTest newUnitTest(ExtensionModelLoader loader, Class<?> extensionClass, String filename, ArtifactCoordinates artifactCoordinates) {
            return new ResourceExtensionUnitTest(loader, extensionClass, filename, artifactCoordinates);
        }

        protected ResourceExtensionUnitTest(ExtensionModelLoader loader, Class<?> extensionClass, String filename, ArtifactCoordinates artifactCoordinates) {
            super(loader, extensionClass, artifactCoordinates);
            this.filename = filename;
        }

        public String getFilename() {
            return this.filename;
        }

        @Override
        protected Object[] buildTestParams(ExtensionModel extensionModel) {
            return new Object[]{extensionModel, this.filename};
        }
    }
}

