/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapWithSize;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;
import org.mule.tck.probe.PollingProber;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

@Feature(value="EventContext")
@Story(value="Distributed Trace Context")
public class SpanContextPropagationTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final List<CoreEvent> EVENTS = new LinkedList<CoreEvent>();
    public static final String TRACE_CONTEXT_PROPAGATION = "traceContextPropagation";
    public static final String TRACE_CONTEXT_PROPAGATION_THROUGH_HELPER = "traceContextPropagationThroughHelper";
    public static final String TRACE_CONTEXT_PROPAGATION_THROUGH_HELPER_SDK_API_CORRELATION_INFO = "traceContextPropagationThroughHelperSdkApi";
    public static final String TRACE_CONTEXT_PROPAGATION_LEGACY_CALLBACK = "traceContextPropagationLegacyCallback";
    public static final String TRACE_CONTEXT_PROPAGATION_LEGACY_CALLBACK_THROUGH_HELPER = "traceContextPropagationLegacyCallbackThroughHelper";
    public static final String TRACE_CONTEXT_PROPAGATION_LEGACY_CALLBACK_THROUGH_HELPER_SDK_API_CORRELATION_INFO = "traceContextPropagationLegacyCallbackThroughHelperSdkApiCorrelationInfo";
    private static final long PROBER_TIMEOUT = 15000L;
    private static final long PROBER_FREQUENCY = 1000L;

    protected String getConfigFile() {
        return "distributed-trace-context-propagation-test.xml";
    }

    protected void doTearDown() throws Exception {
        EVENTS.clear();
    }

    @Test
    public void defaultTraceContextPropagatorThroughImplicitParameter() throws Exception {
        this.startFlow(TRACE_CONTEXT_PROPAGATION);
        this.checkEventProcessed();
        this.assertEventPayload(EVENTS);
    }

    @Test
    public void defaultTraceContextPropagatorThroughForwardCompatibilityHelper() throws Exception {
        this.startFlow(TRACE_CONTEXT_PROPAGATION_THROUGH_HELPER);
        this.checkEventProcessed();
        this.assertEventPayload(EVENTS);
    }

    @Test
    public void defaultTraceContextPropagatorThroughForwardCompatibilityHelperWithSdkApiCorrelationInfo() throws Exception {
        this.startFlow(TRACE_CONTEXT_PROPAGATION_THROUGH_HELPER_SDK_API_CORRELATION_INFO);
        this.checkEventProcessed();
        this.assertEventPayload(EVENTS);
    }

    @Test
    public void defaultTraceContextPropagatorThroughImplicitParameterWithLegacySourceCallback() throws Exception {
        this.startFlow(TRACE_CONTEXT_PROPAGATION_LEGACY_CALLBACK);
        this.checkEventProcessed();
        this.assertEventPayload(EVENTS);
    }

    @Test
    public void defaultTraceContextPropagatorThroughForwardCompatibilityHelperWithLegacySourceCallback() throws Exception {
        this.startFlow(TRACE_CONTEXT_PROPAGATION_LEGACY_CALLBACK_THROUGH_HELPER);
        this.checkEventProcessed();
        this.assertEventPayload(EVENTS);
    }

    @Test
    public void defaultTraceContextPropagatorThroughForwardCompatibilityHelperWithLegacySourceCallbackWithSdkApiCorrelationInfo() throws Exception {
        this.startFlow(TRACE_CONTEXT_PROPAGATION_LEGACY_CALLBACK_THROUGH_HELPER_SDK_API_CORRELATION_INFO);
        this.checkEventProcessed();
        this.assertEventPayload(EVENTS);
    }

    private void startFlow(String flowName) throws Exception {
        ((Startable)this.getFlowConstruct(flowName)).start();
    }

    private void checkEventProcessed() {
        PollingProber.check((long)15000L, (long)1000L, () -> {
            List<CoreEvent> list = EVENTS;
            synchronized (list) {
                return EVENTS.size() == 1;
            }
        });
    }

    private void assertEventPayload(List<CoreEvent> events) {
        for (CoreEvent event : events) {
            DistributedTraceContextManager distributedTraceContextManager = (DistributedTraceContextManager)event.getMessage().getPayload().getValue();
            Assert.assertThat((Object)distributedTraceContextManager.getClass().getName(), (Matcher)Matchers.equalTo((Object)"org.mule.runtime.module.extension.internal.runtime.parameter.PropagateAllDistributedTraceContextManager"));
            Assert.assertThat((Object)distributedTraceContextManager.getRemoteTraceContextMap(), (Matcher)IsMapWithSize.aMapWithSize((int)1));
            Assert.assertThat((Object)distributedTraceContextManager.getRemoteTraceContextMap(), (Matcher)Matchers.hasEntry((Object)"X-Correlation-ID", (Object)"0000-0000"));
        }
    }

    private static class EventCollectorProcessor
    extends AbstractComponent
    implements Processor {
        private EventCollectorProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CoreEvent process(CoreEvent event) throws MuleException {
            List list = EVENTS;
            synchronized (list) {
                EVENTS.add(event);
            }
            return event;
        }
    }
}

