/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.client;

import io.qameta.allure.Feature;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.util.DataSize;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.bytes.ByteStreamingManager;
import org.mule.runtime.core.api.streaming.bytes.FileStoreCursorStreamConfig;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamConfig;
import org.mule.runtime.core.api.streaming.object.FileStoreCursorIteratorConfig;
import org.mule.runtime.core.api.streaming.object.InMemoryCursorIteratorConfig;
import org.mule.runtime.core.api.streaming.object.ObjectStreamingManager;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.test.module.extension.AbstractHeisenbergConfigTestCase;

@Feature(value="Extensions Client")
public class ExtensionClientStreamingConfigurationTestCase
extends AbstractHeisenbergConfigTestCase {
    private static final String HEISENBERG_EXT_NAME = "Heisenberg";
    private static final String HEISENBERG_CONFIG = "heisenberg";
    private static final String ITERABLE_OPERATION = "getPagedBlocklist";
    private static final String STREAMING_OPERATION = "nameAsStream";
    @Inject
    private ExtensionsClient client;
    private StreamingManager streamingManager;

    protected String[] getConfigFiles() {
        return new String[]{"heisenberg-config.xml"};
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        this.streamingManager = (StreamingManager)Mockito.mock(StreamingManager.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        builders.add((ConfigurationBuilder)new AbstractConfigurationBuilder(){

            public void doConfigure(MuleContext muleContext) {
                muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleStreamingManager", (Object)ExtensionClientStreamingConfigurationTestCase.this.streamingManager);
            }
        });
        super.addBuilders(builders);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.setDisposeContextPerClass(true);
        Mockito.when((Object)this.streamingManager.manage((CursorProvider)ArgumentMatchers.any(CursorProvider.class), (EventContext)ArgumentMatchers.any(EventContext.class))).thenAnswer(inv -> inv.getArguments()[0]);
    }

    @Test
    public void customInMemoryRepeatableIterable() throws Exception {
        int initialBufferSize = 3;
        int initialBufferSizeIncrement = 5;
        int maxBufferSize = 11;
        ArgumentCaptor captor = ArgumentCaptor.forClass(InMemoryCursorIteratorConfig.class);
        this.client.execute(HEISENBERG_EXT_NAME, ITERABLE_OPERATION, params -> params.withConfigRef(HEISENBERG_CONFIG).withInMemoryRepeatableIterables(3, 5, 11)).get();
        ((ObjectStreamingManager)Mockito.verify((Object)this.streamingManager.forObjects())).getInMemoryCursorProviderFactory((InMemoryCursorIteratorConfig)captor.capture());
        InMemoryCursorIteratorConfig config = (InMemoryCursorIteratorConfig)captor.getValue();
        MatcherAssert.assertThat((Object)config.getInitialBufferSize(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)config.getBufferSizeIncrement(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat((Object)config.getMaxBufferSize(), (Matcher)CoreMatchers.is((Object)11));
    }

    @Test
    public void customFileStoreRepeatableIterable() throws Exception {
        int maxBufferSize = 11;
        ArgumentCaptor captor = ArgumentCaptor.forClass(FileStoreCursorIteratorConfig.class);
        this.client.execute(HEISENBERG_EXT_NAME, ITERABLE_OPERATION, params -> params.withConfigRef(HEISENBERG_CONFIG).withFileStoreRepeatableIterables(11)).get();
        ((ObjectStreamingManager)Mockito.verify((Object)this.streamingManager.forObjects())).getFileStoreCursorIteratorProviderFactory((FileStoreCursorIteratorConfig)captor.capture());
        FileStoreCursorIteratorConfig config = (FileStoreCursorIteratorConfig)captor.getValue();
        MatcherAssert.assertThat((Object)config.getMaxInMemoryInstances(), (Matcher)CoreMatchers.is((Object)11));
    }

    @Test
    public void customInMemoryRepeatableStream() throws Throwable {
        DataSize initialBufferSize = new DataSize(3, DataUnit.BYTE);
        DataSize initialBufferSizeIncrement = new DataSize(5, DataUnit.BYTE);
        DataSize maxBufferSize = new DataSize(11, DataUnit.BYTE);
        ArgumentCaptor captor = ArgumentCaptor.forClass(InMemoryCursorStreamConfig.class);
        this.client.execute(HEISENBERG_EXT_NAME, STREAMING_OPERATION, params -> params.withConfigRef(HEISENBERG_CONFIG).withInMemoryRepeatableStreaming(initialBufferSize, initialBufferSizeIncrement, maxBufferSize)).get();
        ((ByteStreamingManager)Mockito.verify((Object)this.streamingManager.forBytes())).getInMemoryCursorProviderFactory((InMemoryCursorStreamConfig)captor.capture());
        InMemoryCursorStreamConfig config = (InMemoryCursorStreamConfig)captor.getValue();
        MatcherAssert.assertThat((Object)config.getInitialBufferSize(), (Matcher)CoreMatchers.equalTo((Object)initialBufferSize));
        MatcherAssert.assertThat((Object)config.getBufferSizeIncrement(), (Matcher)CoreMatchers.equalTo((Object)initialBufferSizeIncrement));
        MatcherAssert.assertThat((Object)config.getMaxBufferSize(), (Matcher)CoreMatchers.equalTo((Object)maxBufferSize));
    }

    @Test
    public void customFileStoreRepeatableStream() throws Throwable {
        DataSize maxInMemorySize = new DataSize(3, DataUnit.BYTE);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FileStoreCursorStreamConfig.class);
        this.client.execute(HEISENBERG_EXT_NAME, STREAMING_OPERATION, params -> params.withConfigRef(HEISENBERG_CONFIG).withFileStoreRepeatableStreaming(maxInMemorySize)).get();
        ((ByteStreamingManager)Mockito.verify((Object)this.streamingManager.forBytes())).getFileStoreCursorStreamProviderFactory((FileStoreCursorStreamConfig)captor.capture());
        FileStoreCursorStreamConfig config = (FileStoreCursorStreamConfig)captor.getValue();
        MatcherAssert.assertThat((Object)config.getMaxInMemorySize(), (Matcher)CoreMatchers.equalTo((Object)maxInMemorySize));
    }
}

