/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.source;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.api.notification.PipelineMessageNotificationListener;
import org.mule.runtime.api.notification.PollingSourceItemNotification;
import org.mule.runtime.api.notification.PollingSourceItemNotificationListener;
import org.mule.runtime.api.notification.PollingSourceNotification;
import org.mule.runtime.api.notification.PollingSourceNotificationListener;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.petstore.extension.PetAdoptionSource;
import org.mule.test.petstore.extension.WatermarkingPetAdoptionSource;

@Feature(value="Sources")
@Story(value="Polling")
public class PollingSourceNotificationsTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final List<CoreEvent> ADOPTION_EVENTS = new LinkedList<CoreEvent>();
    private static final int TIMEOUT = 10000;
    private static final String POLL_STARTED_MESSAGE = "poll started";
    private static final String POLL_SUCCESS_MESSAGE = "poll successfully completed";
    private static final String POLL_FAILED_MESSAGE = "poll failed to complete";
    private static final String ITEM_DISPATCHED_MESSAGE = "item dispatched to flow";
    private static final String ITEM_REJECTED_IDEMPOTENCY_MESSAGE = "item rejected due to idempotency";
    private static final String ITEM_REJECTED_WATERMARK_MESSAGE = "item rejected due to watermark";
    @Rule
    public SystemProperty emitNotifications = new SystemProperty("mule.emit.polling.source.notifications", "true");

    protected void doTearDown() throws Exception {
        ADOPTION_EVENTS.clear();
        WatermarkingPetAdoptionSource.resetSource();
    }

    protected String getConfigFile() {
        return "source/polling-source-notifications-config.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pollSuccessNotifications() throws Exception {
        Latch latch = new Latch();
        ArrayList sourceNotifications = new ArrayList();
        PollingSourceNotificationListener sourceListener = notification -> {
            sourceNotifications.add(notification);
            if (String.valueOf(2302).equals(notification.getAction().getIdentifier())) {
                latch.release();
            }
        };
        this.notificationListenerRegistry.registerListener((NotificationListener)sourceListener);
        try {
            this.startFlow("oneItemPoll");
            boolean timeout = !latch.await(10000L, TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat((Object)timeout, (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)sourceNotifications.size(), (Matcher)Matchers.is((Object)2));
            MatcherAssert.assertThat((Object)((PollingSourceNotification)sourceNotifications.get(0)).getActionName(), (Matcher)Matchers.is((Object)POLL_STARTED_MESSAGE));
            MatcherAssert.assertThat((Object)((PollingSourceNotification)sourceNotifications.get(1)).getActionName(), (Matcher)Matchers.is((Object)POLL_SUCCESS_MESSAGE));
        }
        finally {
            this.notificationListenerRegistry.unregisterListener((NotificationListener)sourceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pollFailureNotifications() throws Exception {
        Latch latch = new Latch();
        ArrayList sourceNotifications = new ArrayList();
        PollingSourceNotificationListener sourceListener = notification -> {
            sourceNotifications.add(notification);
            if (String.valueOf(2303).equals(notification.getAction().getIdentifier())) {
                latch.release();
            }
        };
        this.notificationListenerRegistry.registerListener((NotificationListener)sourceListener);
        try {
            this.startFlow("pet-whale");
            boolean timeout = !latch.await(10000L, TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat((Object)timeout, (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)sourceNotifications.size(), (Matcher)Matchers.is((Object)2));
            MatcherAssert.assertThat((Object)((PollingSourceNotification)sourceNotifications.get(0)).getActionName(), (Matcher)Matchers.is((Object)POLL_STARTED_MESSAGE));
            MatcherAssert.assertThat((Object)((PollingSourceNotification)sourceNotifications.get(1)).getActionName(), (Matcher)Matchers.is((Object)POLL_FAILED_MESSAGE));
        }
        finally {
            this.notificationListenerRegistry.unregisterListener((NotificationListener)sourceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void matchEventIdFromNotifications() throws Exception {
        Latch latch = new Latch();
        ArrayList pipelineNotifications = new ArrayList();
        PipelineMessageNotificationListener pipelineListener = notification -> {
            pipelineNotifications.add(notification);
            if (String.valueOf(1804).equals(notification.getAction().getIdentifier())) {
                latch.release();
            }
        };
        this.notificationListenerRegistry.registerListener((NotificationListener)pipelineListener);
        ArrayList sourceNotifications = new ArrayList();
        PollingSourceItemNotificationListener sourceListener = sourceNotifications::add;
        this.notificationListenerRegistry.registerListener((NotificationListener)sourceListener);
        try {
            this.startFlow("oneItemPoll");
            boolean timeout = !latch.await(10000L, TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat((Object)timeout, (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)sourceNotifications.isEmpty(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)pipelineNotifications.isEmpty(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)((PipelineMessageNotification)pipelineNotifications.get(0)).getEvent().getContext().getRootId(), (Matcher)Matchers.is(((PollingSourceItemNotification)sourceNotifications.get(0)).getEventId().get()));
        }
        finally {
            this.notificationListenerRegistry.unregisterListener((NotificationListener)pipelineListener);
            this.notificationListenerRegistry.unregisterListener((NotificationListener)sourceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void itemIdempotencyNotifications() throws Exception {
        Latch latch = new Latch();
        ArrayList sourceNotifications = new ArrayList();
        PollingSourceItemNotificationListener sourceListener = notification -> {
            sourceNotifications.add(notification);
            if (String.valueOf(2306).equals(notification.getAction().getIdentifier()) && sourceNotifications.size() >= PetAdoptionSource.ALL_PETS.size() * 2) {
                latch.release();
            }
        };
        this.notificationListenerRegistry.registerListener((NotificationListener)sourceListener);
        try {
            this.startFlow("idempotent");
            boolean timeout = !latch.await(10000L, TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat((Object)timeout, (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)((PollingSourceItemNotification)sourceNotifications.get(0)).getActionName(), (Matcher)Matchers.is((Object)ITEM_DISPATCHED_MESSAGE));
            MatcherAssert.assertThat((Object)((PollingSourceItemNotification)sourceNotifications.get(PetAdoptionSource.ALL_PETS.size() - 1)).getActionName(), (Matcher)Matchers.is((Object)ITEM_DISPATCHED_MESSAGE));
            MatcherAssert.assertThat((Object)((PollingSourceItemNotification)sourceNotifications.get(PetAdoptionSource.ALL_PETS.size())).getActionName(), (Matcher)Matchers.is((Object)ITEM_REJECTED_IDEMPOTENCY_MESSAGE));
            MatcherAssert.assertThat((Object)((PollingSourceItemNotification)sourceNotifications.get(PetAdoptionSource.ALL_PETS.size() * 2 - 1)).getActionName(), (Matcher)Matchers.is((Object)ITEM_REJECTED_IDEMPOTENCY_MESSAGE));
        }
        finally {
            this.notificationListenerRegistry.unregisterListener((NotificationListener)sourceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void itemWatermarkNotifications() throws Exception {
        Latch latch = new Latch();
        ArrayList sourceNotifications = new ArrayList();
        PollingSourceItemNotificationListener sourceListener = notification -> {
            sourceNotifications.add(notification);
            if (String.valueOf(2307).equals(notification.getAction().getIdentifier())) {
                latch.release();
            }
        };
        this.notificationListenerRegistry.registerListener((NotificationListener)sourceListener);
        try {
            this.startFlow("watermarkPoll");
            boolean timeout = !latch.await(10000L, TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat((Object)timeout, (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)((PollingSourceItemNotification)sourceNotifications.get(0)).getActionName(), (Matcher)Matchers.is((Object)ITEM_DISPATCHED_MESSAGE));
            MatcherAssert.assertThat((Object)((PollingSourceItemNotification)sourceNotifications.get(1)).getActionName(), (Matcher)Matchers.is((Object)ITEM_REJECTED_WATERMARK_MESSAGE));
        }
        finally {
            this.notificationListenerRegistry.unregisterListener((NotificationListener)sourceListener);
        }
    }

    private void startFlow(String flowName) throws Exception {
        ((Startable)this.getFlowConstruct(flowName)).start();
    }

    public static class AdoptionProcessor
    implements Processor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CoreEvent process(CoreEvent event) throws MuleException {
            List list = ADOPTION_EVENTS;
            synchronized (list) {
                ADOPTION_EVENTS.add(event);
            }
            return event;
        }
    }
}

