/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.client.source;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.client.source.SourceParameterizer;
import org.mule.runtime.extension.api.client.source.SourceResultHandler;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.module.extension.client.source.BaseExtensionClientSourceTestCase;
import org.mule.test.petstore.extension.PetAdoptionSource;

@Feature(value="Extensions Client")
@Story(value="Extension Client with Message sources")
public class ExtensionClientConnectedPollingSourceTestCase
extends BaseExtensionClientSourceTestCase {
    @Rule
    public SystemProperty configProperty = new SystemProperty("configName", "petstore");
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String getConfigFile() {
        return "petstore.xml";
    }

    @Test
    public void initPollingSource() throws Exception {
        Consumer<SourceParameterizer> parameterizer = parameters -> ((SourceParameterizer)((SourceParameterizer)((SourceParameterizer)parameters.withConfigRef(this.configProperty.getValue())).withParameter("watermark", (Object)true)).withParameter("idempotent", (Object)true)).withFixedSchedulingStrategy(1L, TimeUnit.SECONDS, 0L);
        this.assertPolling(parameterizer);
    }

    @Test
    public void pollingSourceWithoutSchedulingStrategy() throws Exception {
        Consumer<SourceParameterizer> parameterizer = parameters -> ((SourceParameterizer)((SourceParameterizer)parameters.withConfigRef(this.configProperty.getValue())).withParameter("watermark", (Object)true)).withParameter("idempotent", (Object)true);
        this.assertPolling(parameterizer);
    }

    private void assertPolling(Consumer<SourceParameterizer> parameterizer) throws MuleException, InterruptedException {
        CopyOnWriteArrayList results = new CopyOnWriteArrayList();
        int petCount = PetAdoptionSource.ALL_PETS.size();
        CountDownLatch latch = new CountDownLatch(petCount);
        Consumer<SourceResultHandler> handlerConsumer = handler -> {
            results.add(handler.getResult());
            handler.completeWithSuccess(params -> {});
            latch.countDown();
        };
        this.handler = this.extensionsClient.createSource("petstore", "ConnectedPetAdoptionSource", handlerConsumer, parameterizer);
        this.handler.start();
        Assert.assertThat((Object)latch.await(5L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)results.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(petCount)));
        for (int i = 0; i < petCount; ++i) {
            Result result = (Result)results.get(i);
            Assert.assertThat((Object)((String)result.getOutput()), (Matcher)CoreMatchers.equalTo((Object)((String)PetAdoptionSource.ALL_PETS.get(i))));
            Assert.assertThat((Object)((MediaType)result.getMediaType().get()).matches(MediaType.TEXT), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)result.getAttributes().isPresent(), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)result.getAttributesMediaType().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        }
    }
}

