/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.client.operation;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.client.OperationParameterizer;
import org.mule.runtime.extension.api.client.OperationParameters;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.test.module.extension.client.operation.ExtensionsClientTestCase;

@Feature(value="Extensions Client")
@Story(value="Blocking Extension Client")
public class BlockingExtensionsClientTestCase
extends ExtensionsClientTestCase {
    @Override
    <T, A> Result<T, A> doExecute(String extension, String operation, OperationParameters params) throws MuleException {
        return this.client.execute(extension, operation, params);
    }

    @Override
    @Test
    public void executeNonRepeatablePagedOperation() throws Throwable {
        Result result = (Result)this.client.execute("Heisenberg", "getPagedBlocklist", params -> params.withConfigRef("heisenberg")).get();
        AtomicInteger count = new AtomicInteger(0);
        ((Iterator)result.getOutput()).forEachRemaining(m -> count.addAndGet(1));
        MatcherAssert.assertThat((Object)count.get(), (Matcher)CoreMatchers.is((Object)6));
    }

    @Override
    @Test
    public void executeNonRepeatableInputStreamOperation() throws Throwable {
        Result result = (Result)this.client.execute("Heisenberg", "nameAsStream", params -> params.withConfigRef("heisenberg")).get();
        String value = IOUtils.toString((InputStream)((InputStream)result.getOutput()));
        try {
            MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)"Heisenberg"));
        }
        finally {
            IOUtils.closeQuietly((Closeable)((Closeable)result.getOutput()));
        }
    }

    @Test
    public void executeOperationWithInternalParameterGroup() throws Throwable {
        String message = "Skyler cheated on you";
        Result result = (Result)this.client.execute("Heisenberg", "whisperSecret", params -> ((OperationParameterizer)params.withConfigRef("heisenberg")).withParameter("internalGroup", "secret", (Object)"Skyler cheated on you")).get();
        MatcherAssert.assertThat((Object)((String)result.getOutput()), (Matcher)CoreMatchers.equalTo((Object)"Skyler cheated on you"));
    }
}

