/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.FileGenerationParameterizedExtensionModelTestCase;
import org.mule.test.vegan.extension.VeganExtension;
import org.skyscreamer.jsonassert.JSONAssert;

@SmallTest
@RunWith(value=Parameterized.class)
public class ExtensionModelJsonGeneratorWithNullArtifactCoordinateTestCase
extends FileGenerationParameterizedExtensionModelTestCase {
    private static final boolean UPDATE_EXPECTED_FILES_ON_ERROR = Boolean.getBoolean("mule.extensionModelJson.updateExpectedFilesOnError");
    private final ExtensionModelJsonSerializer generator = new ExtensionModelJsonSerializer(true);

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() {
        List<FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest> extensions = Collections.singletonList(FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, VeganExtension.class, "vegan-without-artifact-coordinates.json"));
        return ExtensionModelJsonGeneratorWithNullArtifactCoordinateTestCase.createExtensionModels(extensions);
    }

    @Override
    protected boolean shouldUpdateExpectedFilesOnError() {
        return UPDATE_EXPECTED_FILES_ON_ERROR;
    }

    @Override
    protected String getExpectedFilesDir() {
        return "models/";
    }

    @Override
    protected String doGenerate(ExtensionModel extensionUnderTest) {
        return this.generator.serialize(extensionUnderTest).trim();
    }

    @Override
    protected void assertEquals(String expectedContent, String actualContent) throws Exception {
        JSONAssert.assertEquals((String)expectedContent, (String)actualContent, (boolean)true);
    }

    @Test
    public void load() {
        ExtensionModel result = this.generator.deserialize(this.expectedContent);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)this.extensionUnderTest));
    }
}

