/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.data.sample;

import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Story;
import java.util.HashMap;
import java.util.Map;
import org.junit.Test;
import org.mule.test.data.sample.extension.ComplexActingParameter;
import org.mule.test.module.extension.data.sample.AbstractSampleDataTestCase;

@Features(value={@Feature(value="Sources"), @Feature(value="SDK Tooling Support")})
@Story(value="Resolve through Tooling API")
public class SourcesSampleDataThroughApiTestCase
extends AbstractSampleDataTestCase {
    protected String getConfigFile() {
        return "data/sample/source-sample-data.xml";
    }

    @Test
    public void connectionLess() throws Exception {
        this.assertMessage(this.getSampleByComponentName("listener", this.getDefaultParameters(), null), "my payload", "my attributes");
    }

    @Test
    public void useConnection() throws Exception {
        this.assertMessage(this.getSampleByComponentName("connected-listener", this.getDefaultParameters(), "config"), "my payload", "my attributes");
    }

    @Test
    public void useConfig() throws Exception {
        this.assertMessage(this.getSampleByComponentName("config-listener", this.getDefaultParameters(), "config"), "from-conf-my payload", "from-conf-my attributes");
    }

    @Test
    public void parameterGroup() throws Exception {
        this.assertMessage(this.getSampleByComponentName("parameter-group-listener", this.getGroupParameters(), null), "my payload", "my attributes");
    }

    @Test
    public void parameterGroupWithOptional() throws Exception {
        Map<String, Object> params = this.getGroupParameters();
        params.remove("optionalParameter");
        this.assertMessage(this.getSampleByComponentName("parameter-group-listener", params, "config"), "my payload", "<<null>>");
    }

    @Test
    public void showInDslParameterGroup() throws Exception {
        this.assertMessage(this.getSampleByComponentName("show-in-dsl-parameter-group-listener", this.getGroupParameters(), "config"), "my payload", "my attributes");
    }

    @Test
    public void aliasedGroup() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("aliasedPayload", "my payload");
        params.put("aliasedAttributes", "my attributes");
        this.assertMessage(this.getSampleByComponentName("aliased-group-listener", params, "config"), "my payload", "my attributes");
    }

    @Test
    public void missingActingParameter() throws Exception {
        this.expectSampleDataException("MISSING_REQUIRED_PARAMETERS");
        this.expectedException.expectMessage("Unable to retrieve Sample Data. There are missing required parameters for the resolution: [attributes]");
        Map<String, Object> params = this.getDefaultParameters();
        params.remove("attributes");
        this.assertMessage(this.getSampleByComponentName("connected-listener", params, "config"), "my payload", "my attributes");
    }

    @Test
    public void muleContextAwareSampleData() throws Exception {
        this.assertMessage(this.getSampleByComponentName("mule-context-aware-listener", this.getDefaultParameters(), null), "my payload", "my attributes");
    }

    @Test
    public void complexActingParameter() throws Exception {
        ComplexActingParameter complexActingParameter = new ComplexActingParameter();
        complexActingParameter.setPayload("my payload");
        complexActingParameter.setAttributes("my attributes");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("complex", complexActingParameter);
        this.assertMessage(this.getSampleByComponentName("complex-acting-parameter-listener", params, null), "my payload", "my attributes");
    }
}

