/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComposableModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.construct.HasConstructModels;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.function.HasFunctionModels;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=Parameterized.class)
public class LegacyJsonDeserializationTestCase {
    @Parameterized.Parameter(value=0)
    public String fileName;
    private String fileContent;
    private final ExtensionModelJsonSerializer generator = new ExtensionModelJsonSerializer(true);

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"vegan.json"}, {"petstore.json"}, {"metadata.json"}, {"heisenberg.json"}, {"substitutiongroup.json"}, {"tx-ext.json"}, {"subtypes.json"}, {"marvel.json"}, {"ram.json"}, {"typed-value.json"}, {"test-oauth.json"}, {"test-oauth-ocs.json"}, {"test-fn.json"}, {"values.json"}, {"implicit-config.json"}, {"non-implicit-config.json"}, {"reconnection-extension.json"});
    }

    @Before
    public void setup() throws IOException {
        this.fileContent = IOUtils.getResourceAsString((String)(this.getExpectedFilesDir() + this.fileName), this.getClass());
    }

    protected String getExpectedFilesDir() {
        return "models/legacy/";
    }

    @Test
    public void load() {
        ExtensionModel result = this.generator.deserialize(this.fileContent);
        this.assertLegacyExtensionModelCollections(result);
    }

    private void assertLegacyExtensionModelCollections(ExtensionModel result) {
        new ExtensionWalker(){

            protected void onConfiguration(ConfigurationModel model) {
                LegacyJsonDeserializationTestCase.this.assertParameterizedModel((ParameterizedModel)model);
                LegacyJsonDeserializationTestCase.this.assertEnrichableModel((EnrichableModel)model);
                LegacyJsonDeserializationTestCase.this.assertNotNull(model.getOperationModels());
                LegacyJsonDeserializationTestCase.this.assertNotNull(model.getConnectionProviders());
                LegacyJsonDeserializationTestCase.this.assertNotNull(model.getExternalLibraryModels());
                LegacyJsonDeserializationTestCase.this.assertNotNull(model.getSourceModels());
            }

            protected void onOperation(HasOperationModels owner, OperationModel model) {
                LegacyJsonDeserializationTestCase.this.assertComponentModel((ComponentModel)model);
                LegacyJsonDeserializationTestCase.this.assertNotNull(model.getNotificationModels());
                LegacyJsonDeserializationTestCase.this.assertSampleDataProviderModel((HasOutputModel)model);
            }

            protected void onFunction(HasFunctionModels owner, FunctionModel model) {
                LegacyJsonDeserializationTestCase.this.assertParameterizedModel((ParameterizedModel)model);
                LegacyJsonDeserializationTestCase.this.assertEnrichableModel((EnrichableModel)model);
            }

            protected void onConstruct(HasConstructModels owner, ConstructModel model) {
                LegacyJsonDeserializationTestCase.this.assertComponentModel((ComponentModel)model);
            }

            protected void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                LegacyJsonDeserializationTestCase.this.assertParameterizedModel((ParameterizedModel)model);
                LegacyJsonDeserializationTestCase.this.assertEnrichableModel((EnrichableModel)model);
                LegacyJsonDeserializationTestCase.this.assertNotNull(model.getExternalLibraryModels());
                LegacyJsonDeserializationTestCase.this.assertNotNull(model.getSemanticTerms());
            }

            protected void onSource(HasSourceModels owner, SourceModel model) {
                LegacyJsonDeserializationTestCase.this.assertComponentModel((ComponentModel)model);
                LegacyJsonDeserializationTestCase.this.assertSampleDataProviderModel((HasOutputModel)model);
                LegacyJsonDeserializationTestCase.this.assertNotNull(model.getNotificationModels());
                model.getErrorCallback().ifPresent(x$0 -> LegacyJsonDeserializationTestCase.this.assertSourceCallbackModel(x$0));
                model.getSuccessCallback().ifPresent(x$0 -> LegacyJsonDeserializationTestCase.this.assertSourceCallbackModel(x$0));
                model.getTerminateCallback().ifPresent(x$0 -> LegacyJsonDeserializationTestCase.this.assertSourceCallbackModel(x$0));
            }

            protected void onParameterGroup(ParameterizedModel owner, ParameterGroupModel model) {
                LegacyJsonDeserializationTestCase.this.assertEnrichableModel((EnrichableModel)model);
                LegacyJsonDeserializationTestCase.this.assertNotNull(model.getParameterModels());
                LegacyJsonDeserializationTestCase.this.assertNotNull(model.getExclusiveParametersModels());
            }

            protected void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                LegacyJsonDeserializationTestCase.this.assertEnrichableModel((EnrichableModel)model);
                LegacyJsonDeserializationTestCase.this.assertNotNull(model.getAllowedStereotypes());
                LegacyJsonDeserializationTestCase.this.assertNotNull(model.getSemanticTerms());
                LegacyJsonDeserializationTestCase.this.assertFieldValueProviderModels(model);
                model.getValueProviderModel().ifPresent(valueProviderModel -> valueProviderModel.getParameters());
            }

            protected void onNestable(ComposableModel owner, NestableElementModel model) {
                LegacyJsonDeserializationTestCase.this.assertComponentModel((ComponentModel)model);
            }
        }.walk(result);
    }

    public void assertParameterizedModel(ParameterizedModel model) {
        this.assertNotNull(model.getAllParameterModels());
        this.assertNotNull(model.getParameterGroupModels());
    }

    public void assertEnrichableModel(EnrichableModel model) {
        this.assertNotNull(model.getModelProperties());
    }

    public void assertComponentModel(ComponentModel model) {
        this.assertParameterizedModel((ParameterizedModel)model);
        this.assertEnrichableModel((EnrichableModel)model);
        this.assertNotNull(model.getErrorModels());
        this.assertNotNull(model.getNestedComponents());
        this.assertNotNull(model.getSemanticTerms());
    }

    private void assertSampleDataProviderModel(HasOutputModel model) {
        this.assertNotNull(model.getSampleDataProviderModel());
        model.getSampleDataProviderModel().ifPresent(sampleDataProviderModel -> this.assertNotNull(sampleDataProviderModel.getParameters()));
    }

    private void assertSourceCallbackModel(SourceCallbackModel sourceCallbackModel) {
        this.assertParameterizedModel((ParameterizedModel)sourceCallbackModel);
        this.assertEnrichableModel((EnrichableModel)sourceCallbackModel);
    }

    private void assertFieldValueProviderModels(ParameterModel model) {
        this.assertNotNull(model.getFieldValueProviderModels());
        model.getFieldValueProviderModels().forEach(fieldValueProviderModel -> this.assertValueProviderModel((ValueProviderModel)fieldValueProviderModel));
    }

    private void assertValueProviderModel(ValueProviderModel model) {
        this.assertEnrichableModel((EnrichableModel)model);
        this.assertNotNull(model.getParameters());
    }

    public void assertNotNull(Object value) {
        MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

