/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources;

import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.resources.MulePluginDescriptorGenerator;
import org.mule.runtime.module.extension.internal.resources.test.AbstractGeneratedResourceFactoryTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.skyscreamer.jsonassert.JSONAssert;

@SmallTest
public class MulePluginDescriptorGeneratorTestCase
extends AbstractGeneratedResourceFactoryTestCase {
    private MulePluginDescriptorGenerator generator = new MulePluginDescriptorGenerator();
    private ExtensionModel extensionModel;

    @Before
    public void before() {
        this.extensionModel = MuleExtensionUtils.loadExtension(HeisenbergExtension.class);
    }

    protected Class<? extends GeneratedResourceFactory>[] getResourceFactoryTypes() {
        return new Class[]{MulePluginDescriptorGenerator.class};
    }

    @Test
    public void generate() throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/heisenberg-test-mule-artifact.json");
        Assert.assertThat((Object)in, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        String expectedDescriptor = IOUtils.toString((InputStream)in);
        Optional resource = this.generator.generateResource(this.extensionModel);
        Assert.assertThat((Object)resource.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        String actualDescriptor = new String(((GeneratedResource)resource.get()).getContent());
        JSONAssert.assertEquals((String)expectedDescriptor, (String)actualDescriptor, (boolean)true);
    }
}

