/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.config;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.model.HealthStatus;
import org.mule.test.heisenberg.extension.model.Ricin;
import org.mule.test.module.extension.config.AbstractConfigParserTestCase;

public class SingleConfigParserTestCase
extends AbstractConfigParserTestCase {
    protected boolean isDisposeContextPerClass() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void configWithExpressionFunctionIsSameInstanceForDifferentEvents() throws Exception {
        CoreEvent event = null;
        try {
            event = this.getHeisenbergEvent();
            CoreEvent anotherEvent = this.testEvent();
            HeisenbergExtension config = this.lookupHeisenberg("heisenberg", event);
            HeisenbergExtension anotherConfig = this.lookupHeisenberg("heisenberg", anotherEvent);
            Assert.assertThat((Object)config, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)anotherConfig)));
        }
        finally {
            if (event != null) {
                ((BaseEventContext)event.getContext()).success();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void configWithExpressionFunctionStillDynamic() throws Exception {
        CoreEvent event = null;
        CoreEvent anotherEvent = null;
        try {
            event = this.getHeisenbergEvent();
            anotherEvent = CoreEvent.builder((CoreEvent)this.getHeisenbergEvent()).addVariable("age", (Object)40).build();
            HeisenbergExtension config = this.lookupHeisenberg("expressionHeisenberg", event);
            HeisenbergExtension anotherConfig = this.lookupHeisenberg("expressionHeisenberg", anotherEvent);
            Assert.assertThat((Object)config, (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)CoreMatchers.sameInstance((Object)anotherConfig))));
        }
        finally {
            if (event != null) {
                ((BaseEventContext)event.getContext()).success();
            }
            if (anotherEvent != null) {
                ((BaseEventContext)anotherEvent.getContext()).success();
            }
        }
    }

    @Test
    public void initializedOptionalValueWithoutDefaultValue() throws Exception {
        CoreEvent event = null;
        try {
            event = this.getHeisenbergEvent();
            HeisenbergExtension config = this.lookupHeisenberg("expressionHeisenbergByRef", event);
            Assert.assertThat((Object)config.getWeapon(), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)CoreMatchers.nullValue())));
            Assert.assertThat((Object)config.getWeapon(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Ricin.class)));
        }
        finally {
            if (event != null) {
                ((BaseEventContext)event.getContext()).success();
            }
        }
    }

    @Test
    public void getHealthProgression() throws Exception {
        CoreEvent event = null;
        try {
            event = this.getHeisenbergEvent();
            HeisenbergExtension config = this.lookupHeisenberg("heisenberg", event);
            Assert.assertThat((Object)config.getHealthProgression(), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)CoreMatchers.nullValue())));
            Assert.assertThat((Object)config.getHealthProgression().size(), (Matcher)CoreMatchers.is((Object)3));
            Assert.assertThat((Object)config.getHealthProgression(), (Matcher)Matchers.contains((Object[])new HealthStatus[]{HealthStatus.HEALTHY, HealthStatus.CANCER, HealthStatus.DEAD}));
        }
        finally {
            if (event != null) {
                ((BaseEventContext)event.getContext()).success();
            }
        }
    }
}

