/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.config;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class StereotypedInternalReferenceTestCase
extends AbstractExtensionFunctionalTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String getConfigFile() {
        return "stereotype-config-reference.xml";
    }

    @Test
    public void softReferencesAreResolvedOnlyAtRuntimeWithoutException() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("matchingOperationFlow");
        flow.start();
    }

    @Test
    public void flowReferenceWithoutException() throws Exception {
        this.flowRunner("referencedFlow").run().getMessage().getPayload();
    }

    @Test
    public void softReferencesFailsAtRuntime() throws Exception {
        this.expectedException.expectMessage("does not match the expected operation");
        Flow flow = (Flow)this.getFlowConstruct("operationMismatch");
        flow.start();
    }

    @Test
    public void invalidFlowReference() throws Exception {
        this.flowRunner("nonReferencedFlow").runExpectingException(ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"referenced flow does not exist")));
    }
}

