/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.metadata;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runners.Parameterized;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.Typed;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataComponent;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.metadata.NullMetadataKey;
import org.mule.runtime.module.extension.api.metadata.MultilevelMetadataKeyBuilder;
import org.mule.tck.junit4.matcher.metadata.MetadataKeyResultFailureMatcher;
import org.mule.tck.junit4.matcher.metadata.MetadataKeyResultSuccessMatcher;
import org.mule.test.metadata.extension.resolver.TestMetadataResolverUtils;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
@Feature(value="SDK Tooling Support")
@Story(value="Metadata Service")
public abstract class MetadataExtensionFunctionalTestCase<T extends ComponentModel>
extends AbstractExtensionFunctionalTestCase {
    protected static final String METADATA_TEST = "metadata-tests.xml";
    protected static final String RUNTIME_METADATA_CONFIG = "metadata-runtime-tests.xml";
    protected static final String DSQL_QUERY = "dsql:SELECT id FROM Circle WHERE (diameter < 18)";
    protected static final String METADATA_TEST_STATIC_NO_REF_CONFIGURATION = "metadata-tests-static-no-ref-configuration.xml";
    protected static final String METADATA_TEST_DYNAMIC_NO_REF_CONFIGURATION = "metadata-tests-dynamic-no-ref-configuration.xml";
    protected static final String METADATA_TEST_DYNAMIC_IMPLICIT_CONFIGURATION = "metadata-tests-dynamic-implicit-configuration.xml";
    protected static final String CONTENT_METADATA_WITH_KEY_ID = "contentMetadataWithKeyId";
    protected static final String OUTPUT_METADATA_WITH_KEY_ID = "outputMetadataWithKeyId";
    protected static final String OUTPUT_METADATA_WITH_KEY_ID_USING_CONFIG = "outputMetadataWithKeyIdUsingConfig";
    protected static final String CONTENT_AND_OUTPUT_METADATA_WITH_KEY_ID = "contentAndOutputMetadataWithKeyId";
    protected static final String OUTPUT_ONLY_WITHOUT_CONTENT_PARAM = "outputOnlyWithoutContentParam";
    protected static final String CONTENT_ONLY_IGNORES_OUTPUT = "contentOnlyIgnoresOutput";
    protected static final String CONTENT_METADATA_WITHOUT_KEY_ID = "contentMetadataWithoutKeyId";
    protected static final String OUTPUT_METADATA_WITHOUT_KEY_PARAM = "outputMetadataWithoutKeyId";
    protected static final String CONTENT_AND_OUTPUT_METADATA_WITHOUT_KEY_ID = "contentAndOutputMetadataWithoutKeyId";
    protected static final String CONTENT_METADATA_WITHOUT_KEYS_WITH_KEY_ID = "contentMetadataWithoutKeysWithKeyId";
    protected static final String OUTPUT_METADATA_WITHOUT_KEYS_WITH_KEY_ID = "outputMetadataWithoutKeysWithKeyId";
    protected static final String CONTENT_AND_OUTPUT_CACHE_RESOLVER = "contentAndOutputWithCacheResolver";
    protected static final String CONTENT_AND_OUTPUT_CACHE_RESOLVER_WITH_ALTERNATIVE_CONFIG = "contentAndOutputWithCacheResolverWithSpecificConfig";
    protected static final String QUERY_FLOW = "queryOperation";
    protected static final String QUERY_LIST_FLOW = "queryListOperation";
    protected static final String NATIVE_QUERY_FLOW = "nativeQueryOperation";
    protected static final String NATIVE_QUERY_LIST_FLOW = "nativeQueryListOperation";
    protected static final String CONTENT_ONLY_CACHE_RESOLVER = "contentOnlyCacheResolver";
    protected static final String OUTPUT_AND_METADATA_KEY_CACHE_RESOLVER = "outputAndMetadataKeyCacheResolver";
    protected static final String EMPTY_PARTIAL_MULTILEVEL_KEYS = "emptyPartialMultilevelKeys";
    protected static final String SOURCE_METADATA = "sourceMetadata";
    protected static final String SOURCE_METADATA_WITH_MULTILEVEL = "sourceMetadataWithMultilevel";
    protected static final String SOURCE_METADATA_WITH_PARTIAL_MULTILEVEL = "sourceMetadataWithPartialMultilevel";
    protected static final String SOURCE_METADATA_WITH_PARTIAL_MULTILEVEL_SHOW_IN_DSL = "sourceMetadataWithPartialMultiLevelShowInDsl";
    protected static final String SOURCE_METADATA_WITH_CALLBACK_PARAMETERS = "sourceMetadataWithCallbackParameters";
    protected static final String SHOULD_INHERIT_OPERATION_PARENT_RESOLVERS = "shouldInheritOperationParentResolvers";
    protected static final String SIMPLE_MULTILEVEL_KEY_RESOLVER = "simpleMultiLevelKeyResolver";
    protected static final String INCOMPLETE_MULTILEVEL_KEY_RESOLVER = "incompleteMultiLevelKeyResolver";
    protected static final String TYPE_WITH_DECLARED_SUBTYPES_METADATA = "typeWithDeclaredSubtypesMetadata";
    protected static final String RESOLVER_WITH_DYNAMIC_CONFIG = "resolverWithDynamicConfig";
    protected static final String RESOLVER_WITH_IMPLICIT_DYNAMIC_CONFIG = "resolverWithImplicitDynamicConfig";
    protected static final String RESOLVER_WITH_IMPLICIT_STATIC_CONFIG = "resolverWithImplicitStaticConfig";
    protected static final String OUTPUT_ATTRIBUTES_WITH_DYNAMIC_METADATA = "sdkOutputAttributesWithDynamicMetadata";
    protected static final String OUTPUT_ATTRIBUTES_WITH_DECLARED_SUBTYPES_METADATA = "outputAttributesWithDeclaredSubtypesMetadata";
    protected static final String RESOLVER_CONTENT_WITH_CONTEXT_CLASSLOADER = "resolverContentWithContextClassLoader";
    protected static final String RESOLVER_OUTPUT_WITH_CONTEXT_CLASSLOADER = "resolverOutputWithContextClassLoader";
    protected static final String ENUM_METADATA_KEY = "enumMetadataKey";
    protected static final String BOOLEAN_METADATA_KEY = "booleanMetadataKey";
    protected static final String METADATA_KEY_DEFAULT_VALUE = "metadataKeyDefaultValue";
    protected static final String METADATA_KEY_OPTIONAL = "metadataKeyOptional";
    protected static final String MULTILEVEL_METADATA_KEY_DEFAULT_VALUE = "multilevelMetadataKeyDefaultValue";
    protected static final String OUTPUT_AND_MULTIPLE_INPUT_WITH_KEY_ID = "outputAndMultipleInputWithKeyId";
    protected static final String CONTINENT = "continent";
    protected static final String COUNTRY = "country";
    protected static final String CITY = "city";
    protected static final String SUCCESS_OBJECT_PARAMETER_NAME = "successObject";
    protected static final String ERROR_OBJECT_PARAMETER_NAME = "errorObject";
    protected static final String RESPONSE_PARAMETER_NAME = "response";
    protected static final MetadataKey PERSON_METADATA_KEY = MetadataKeyBuilder.newKey((String)"PERSON").build();
    protected static final MetadataKey CAR_KEY = MetadataKeyBuilder.newKey((String)"CAR").build();
    protected static final MetadataKey LOCATION_MULTILEVEL_KEY = MultilevelMetadataKeyBuilder.newKey((String)"AMERICA", (String)"continent").withChild(MultilevelMetadataKeyBuilder.newKey((String)"USA", (String)"country").withChild((MetadataKeyBuilder)MultilevelMetadataKeyBuilder.newKey((String)"SFO", (String)"city"))).build();
    protected static final NullMetadataKey NULL_METADATA_KEY = new NullMetadataKey();
    protected static final ClassTypeLoader TYPE_LOADER = ExtensionsTestUtils.TYPE_LOADER;
    @Inject
    @Named(value="_muleMetadataService")
    protected MetadataService metadataService;
    protected MetadataType personType;
    protected MetadataType houseType;
    protected MetadataType carType;
    protected Location location;
    protected CoreEvent event;
    protected ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    protected BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
    protected MetadataComponentDescriptorProvider<T> provider;
    protected ResolutionType resolutionType;

    public boolean enableLazyInit() {
        return true;
    }

    public boolean disableXmlValidations() {
        return true;
    }

    public boolean addToolingObjectsToRegistry() {
        return true;
    }

    MetadataExtensionFunctionalTestCase(ResolutionType resolutionType) {
        this.resolutionType = resolutionType;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({ResolutionType.EXPLICIT_RESOLUTION}, {ResolutionType.DSL_RESOLUTION});
    }

    @Before
    public void setup() throws Exception {
        this.event = CoreEvent.builder((CoreEvent)this.testEvent()).message(Message.of((Object)"")).build();
        this.personType = TestMetadataResolverUtils.getPersonMetadata();
        this.houseType = TestMetadataResolverUtils.getHouseMetadata();
        this.carType = TestMetadataResolverUtils.getCarMetadata();
    }

    protected boolean isDisposeContextPerClass() {
        return false;
    }

    MetadataResult<ComponentMetadataDescriptor<T>> getComponentDynamicMetadata(MetadataKey key) {
        Preconditions.checkArgument((this.location != null ? 1 : 0) != 0, (String)"Unable to resolve Metadata. The location has not been configured.");
        return this.provider.resolveDynamicMetadata(this.metadataService, this.location, key);
    }

    ComponentMetadataDescriptor getSuccessComponentDynamicMetadata() {
        return this.getSuccessComponentDynamicMetadata(PERSON_METADATA_KEY);
    }

    ComponentMetadataDescriptor<T> getSuccessComponentDynamicMetadataWithKey(MetadataKey key) {
        return this.getSuccessComponentDynamicMetadata(key, this::assertResolvedKey);
    }

    ComponentMetadataDescriptor<T> getSuccessComponentDynamicMetadata(MetadataKey key) {
        return this.getSuccessComponentDynamicMetadata(key, (a, b) -> {});
    }

    private ComponentMetadataDescriptor<T> getSuccessComponentDynamicMetadata(MetadataKey key, BiConsumer<MetadataResult<ComponentMetadataDescriptor<T>>, MetadataKey> assertKeys) {
        MetadataResult<ComponentMetadataDescriptor<T>> componentMetadata = this.getComponentDynamicMetadata(key);
        Assert.assertThat(componentMetadata, (Matcher)MetadataKeyResultSuccessMatcher.isSuccess());
        assertKeys.accept(componentMetadata, key);
        return (ComponentMetadataDescriptor)componentMetadata.get();
    }

    void assertMetadataFailure(MetadataFailure failure, String msgContains, FailureCode failureCode, String traceContains, MetadataComponent failingComponent) {
        this.assertMetadataFailure(failure, msgContains, failureCode, traceContains, failingComponent, "");
    }

    void assertMetadataFailure(MetadataFailure failure, String msgContains, FailureCode failureCode, String traceContains, MetadataComponent failingComponent, String failingElement) {
        Assert.assertThat((Object)failure.getFailureCode(), (Matcher)Is.is((Object)failureCode));
        if (!StringUtils.isBlank((CharSequence)msgContains)) {
            Assert.assertThat((Object)failure.getMessage(), (Matcher)Matchers.containsString((String)msgContains));
        }
        if (!StringUtils.isBlank((CharSequence)traceContains)) {
            Assert.assertThat((Object)failure.getReason(), (Matcher)Matchers.containsString((String)traceContains));
        }
        Assert.assertThat((Object)failure.getFailingComponent(), (Matcher)Is.is((Object)failingComponent));
        if (!StringUtils.isBlank((CharSequence)failingElement)) {
            Assert.assertThat((Object)failure.getFailingElement().isPresent(), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)((String)failure.getFailingElement().get()), (Matcher)Is.is((Object)failingElement));
        }
    }

    void assertExpectedOutput(ConnectableComponentModel model, Type payloadType, Type attributesType) {
        this.assertExpectedOutput(model.getOutput(), model.getOutputAttributes(), TYPE_LOADER.load(payloadType), TYPE_LOADER.load(attributesType));
    }

    void assertExpectedOutput(ConnectableComponentModel model, MetadataType payloadType, Type attributesType) {
        this.assertExpectedOutput(model.getOutput(), model.getOutputAttributes(), payloadType, TYPE_LOADER.load(attributesType));
    }

    void assertExpectedOutput(ConnectableComponentModel model, MetadataType payloadType, MetadataType attributesType) {
        this.assertExpectedOutput(model.getOutput(), model.getOutputAttributes(), payloadType, attributesType);
    }

    void assertExpectedOutput(OutputModel output, OutputModel attributes, MetadataType payloadType, MetadataType attributesType) {
        this.assertExpectedType(output.getType(), payloadType);
        this.assertExpectedType(attributes.getType(), attributesType);
    }

    protected void assertExpectedType(MetadataType type, MetadataType expectedType) {
        Assert.assertThat((Object)type, (Matcher)Is.is((Object)expectedType));
    }

    protected void assertExpectedParameterMetadataDescriptor(ParameterMetadataDescriptor parameterMetadataDescriptor, Type type, boolean dynamic) {
        Assert.assertThat((Object)parameterMetadataDescriptor.isDynamic(), (Matcher)Is.is((Object)dynamic));
        this.assertExpectedType(parameterMetadataDescriptor.getType(), type);
    }

    protected void assertExpectedParameterMetadataDescriptor(ParameterMetadataDescriptor parameterMetadataDescriptor, MetadataType type) {
        Assert.assertThat((Object)parameterMetadataDescriptor.isDynamic(), (Matcher)Is.is((Object)true));
        this.assertExpectedType(parameterMetadataDescriptor.getType(), type);
    }

    protected void assertExpectedType(Typed type, Type expectedType) {
        Assert.assertThat((Object)type.getType(), (Matcher)Is.is((Object)TYPE_LOADER.load(expectedType)));
    }

    protected void assertExpectedType(MetadataType metadataType, Type expectedType) {
        this.assertExpectedType(metadataType, TYPE_LOADER.load(expectedType));
    }

    protected void assertExpectedType(Typed typedModel, MetadataType expectedType, boolean isDynamic) {
        Assert.assertThat((Object)typedModel.getType(), (Matcher)Is.is((Object)expectedType));
        Assert.assertThat((Object)typedModel.hasDynamicType(), (Matcher)Is.is((Object)isDynamic));
    }

    protected <T extends ComponentModel> void assertResolvedKey(MetadataResult<ComponentMetadataDescriptor<T>> result, MetadataKey metadataKey) {
        Assert.assertThat((Object)((ComponentMetadataDescriptor)result.get()).getMetadataAttributes().getKey().isPresent(), (Matcher)Is.is((Object)true));
        MetadataKey resultKey = (MetadataKey)((ComponentMetadataDescriptor)result.get()).getMetadataAttributes().getKey().get();
        this.assertSameKey(metadataKey, resultKey);
        MetadataKey child = metadataKey.getChilds().stream().findFirst().orElseGet(() -> null);
        MetadataKey otherChild = resultKey.getChilds().stream().findFirst().orElseGet(() -> null);
        while (child != null && otherChild != null) {
            this.assertSameKey(child, otherChild);
            child = child.getChilds().stream().findFirst().orElseGet(() -> null);
            otherChild = otherChild.getChilds().stream().findFirst().orElseGet(() -> null);
        }
        Assert.assertThat((Object)(child == null && otherChild == null ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    private void assertSameKey(MetadataKey metadataKey, MetadataKey resultKey) {
        Assert.assertThat((Object)resultKey.getId(), (Matcher)Is.is((Object)metadataKey.getId()));
        Assert.assertThat((Object)resultKey.getChilds(), (Matcher)Matchers.hasSize((int)metadataKey.getChilds().size()));
    }

    public Set<MetadataKey> getKeysFromContainer(MetadataKeysContainer metadataKeysContainer) {
        return (Set)metadataKeysContainer.getKeys((String)metadataKeysContainer.getCategories().iterator().next()).get();
    }

    public void assertSuccessResult(MetadataResult<?> result) {
        Assert.assertThat(result, (Matcher)MetadataKeyResultSuccessMatcher.isSuccess());
    }

    void assertFailureResult(MetadataResult<?> result, int failureNumber) {
        Assert.assertThat(result, (Matcher)MetadataKeyResultFailureMatcher.isFailure((Matcher)Matchers.hasSize((int)failureNumber)));
    }

    static interface MetadataComponentDescriptorProvider<T extends ComponentModel> {
        public MetadataResult<ComponentMetadataDescriptor<T>> resolveDynamicMetadata(MetadataService var1, Location var2, MetadataKey var3);
    }

    public static enum ResolutionType {
        EXPLICIT_RESOLUTION,
        DSL_RESOLUTION;

    }
}

