/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.extension.test.extension.reconnection.ReconnectionExtension;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
import org.mule.runtime.module.extension.internal.capability.xml.schema.DefaultExtensionSchemaGenerator;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.GlobalInnerPojoConnector;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.GlobalPojoConnector;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.ListConnector;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.MapConnector;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.StringListConnector;
import org.mule.runtime.module.extension.internal.runtime.connectivity.basic.TestConnector;
import org.mule.tck.size.SmallTest;
import org.mule.test.function.extension.WeaveFunctionExtension;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.implicit.config.extension.extension.api.ImplicitConfigExtension;
import org.mule.test.marvel.MarvelExtension;
import org.mule.test.metadata.extension.MetadataExtension;
import org.mule.test.module.extension.internal.FileGenerationParameterizedExtensionModelTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.nonimplicit.config.extension.extension.api.NonImplicitConfigExtension;
import org.mule.test.oauth.TestOAuthExtension;
import org.mule.test.petstore.extension.PetStoreConnector;
import org.mule.test.ram.RickAndMortyExtension;
import org.mule.test.semantic.extension.SemanticTermsExtension;
import org.mule.test.soap.extension.FootballSoapExtension;
import org.mule.test.substitutiongroup.extension.SubstitutionGroupExtension;
import org.mule.test.subtypes.extension.SubTypesMappingConnector;
import org.mule.test.transactional.TransactionalExtension;
import org.mule.test.typed.value.extension.extension.TypedValueExtension;
import org.mule.test.values.extension.ValuesExtension;
import org.mule.test.vegan.extension.VeganExtension;

@SmallTest
@RunWith(value=Parameterized.class)
public class DefaultExtensionSchemaGeneratorTestCase
extends FileGenerationParameterizedExtensionModelTestCase {
    private static final boolean UPDATE_EXPECTED_FILES_ON_ERROR = Boolean.getBoolean("mule.extensionSchemas.updateExpectedFilesOnError");
    private final ExtensionSchemaGenerator generator = new DefaultExtensionSchemaGenerator();

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() {
        List<FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest> extensions = Arrays.asList(FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, MapConnector.class, "map.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, ListConnector.class, "list.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, TestConnector.class, "basic.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, StringListConnector.class, "string-list.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, GlobalPojoConnector.class, "global-pojo.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, GlobalInnerPojoConnector.class, "global-inner-pojo.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, VeganExtension.class, "vegan.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, PetStoreConnector.class, "petstore.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, MetadataExtension.class, "metadata.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, HeisenbergExtension.class, "heisenberg.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, SubstitutionGroupExtension.class, "substitutiongroup.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, TransactionalExtension.class, "tx-ext.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, SubTypesMappingConnector.class, "subtypes.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, MarvelExtension.class, "marvel.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(SOAP_LOADER, FootballSoapExtension.class, "soap.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(SOAP_LOADER, RickAndMortyExtension.class, "ram.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, TypedValueExtension.class, "typed-value.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, TestOAuthExtension.class, "test-oauth.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, WeaveFunctionExtension.class, "test-fn.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, ValuesExtension.class, "values.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, ImplicitConfigExtension.class, "implicit-config.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, NonImplicitConfigExtension.class, "non-implicit-config.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, SemanticTermsExtension.class, "semantic-terms-extension.xsd"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, ReconnectionExtension.class, "reconnection-extension.xsd"));
        return DefaultExtensionSchemaGeneratorTestCase.createExtensionModels(extensions);
    }

    @Override
    protected boolean shouldUpdateExpectedFilesOnError() {
        return UPDATE_EXPECTED_FILES_ON_ERROR;
    }

    @Override
    protected String getExpectedFilesDir() {
        return "schemas/";
    }

    @Override
    protected String doGenerate(ExtensionModel extensionUnderTest) throws Exception {
        return this.generator.generate(extensionUnderTest, (DslResolvingContext)new SchemaTestDslContext());
    }

    @Override
    protected void assertEquals(String expectedContent, String actualContent) throws Exception {
        ExtensionsTestUtils.compareXML((String)expectedContent, (String)actualContent);
    }

    private static class SchemaTestDslContext
    implements DslResolvingContext {
        private SchemaTestDslContext() {
        }

        public Optional<ExtensionModel> getExtension(String name) {
            return Optional.ofNullable((ExtensionModel)EXTENSION_MODELS.get(name));
        }

        public Optional<ExtensionModel> getExtensionForType(String typeId) {
            return this.getTypeCatalog().getDeclaringExtension(typeId).flatMap(this::getExtension);
        }

        public Set<ExtensionModel> getExtensions() {
            return ImmutableSet.copyOf(EXTENSION_MODELS.values());
        }

        public TypeCatalog getTypeCatalog() {
            return TypeCatalog.getDefault((Set)ImmutableSet.copyOf(EXTENSION_MODELS.values()));
        }
    }
}

