/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.connector;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.petstore.extension.PetStoreClient;

public class PetStoreISO8601DateParsingTestCase
extends AbstractExtensionFunctionalTestCase {
    public static final int YEAR = 2008;
    public static final int MONTH = 9;
    public static final int DAY = 15;
    public static final int HOUR = 15;
    public static final int MINUTE = 53;
    public static final int SECOND = 23;

    protected String getConfigFile() {
        return "petstore-iso8601-config.xml";
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @Test
    public void testDateTimeWithTimeZone() throws Exception {
        Date date = this.getDate("getWithTimeZone");
        ZonedDateTime openingDate = ZonedDateTime.ofInstant(date.toInstant(), ZoneId.of("+05:00"));
        this.assertTimeZoneDate(openingDate);
        this.assertTimeZoneDateTime(openingDate);
    }

    @Test
    public void testDateTimeWithTimeZoneNoSeconds() throws Exception {
        Date date = this.getDate("getWithTimeZoneNoSeconds");
        ZonedDateTime openingDate = ZonedDateTime.ofInstant(date.toInstant(), ZoneId.of("+05:00"));
        this.assertTimeZoneDate(openingDate);
        this.assertTimeZoneWithoutSeconds(openingDate);
    }

    @Test
    public void testDateTimeWithTimeZoneNoMinutes() throws Exception {
        Date date = this.getDate("getWithTimeZoneNoMinutes");
        ZonedDateTime openingDate = ZonedDateTime.ofInstant(date.toInstant(), ZoneId.of("+05:00"));
        this.assertTimeZoneDate(openingDate);
        this.assertTimeZoneHour(openingDate);
    }

    @Test
    public void testDateTime() throws Exception {
        Date date = this.getDate("getWithDateTime");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.assertDate(calendar);
        this.assertTime(calendar);
    }

    @Test
    public void testDate() throws Exception {
        Date date = this.getDate("getWithDate");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.assertDate(calendar);
    }

    @Test
    public void testDateList() throws Exception {
        Calendar calendar = Calendar.getInstance();
        PetStoreClient client = this.getClient("getDateList");
        List dates = client.getClosedForHolidays();
        calendar.setTime((Date)dates.get(0));
        Assert.assertEquals((long)dates.size(), (long)1L);
        this.assertDate(calendar);
    }

    @Test
    public void testDateTimeList() throws Exception {
        PetStoreClient client = this.getClient("getDateTimeList");
        List dates = client.getDiscountDates();
        Assert.assertEquals((long)dates.size(), (long)1L);
        this.assertDateTime((LocalDateTime)dates.get(0));
    }

    public Date getDate(String flowName) throws Exception {
        PetStoreClient client = this.getClient(flowName);
        return client.getOpeningDate();
    }

    public PetStoreClient getClient(String flowName) throws Exception {
        return (PetStoreClient)this.flowRunner(flowName).run().getMessage().getPayload().getValue();
    }

    private void assertDate(Calendar openingDate) {
        Assert.assertEquals((long)openingDate.get(1), (long)2008L);
        Assert.assertEquals((long)(openingDate.get(2) + 1), (long)9L);
        Assert.assertEquals((long)openingDate.get(5), (long)15L);
    }

    private void assertDateTime(LocalDateTime localDateTime) {
        Assert.assertEquals((long)localDateTime.getYear(), (long)2008L);
        Assert.assertEquals((long)localDateTime.getMonthValue(), (long)9L);
        Assert.assertEquals((long)localDateTime.getDayOfMonth(), (long)15L);
        Assert.assertEquals((long)localDateTime.getHour(), (long)15L);
        Assert.assertEquals((long)localDateTime.getMinute(), (long)53L);
        Assert.assertEquals((long)localDateTime.getSecond(), (long)23L);
    }

    private void assertTime(Calendar openingDate) {
        Assert.assertEquals((long)openingDate.get(11), (long)15L);
        Assert.assertEquals((long)openingDate.get(12), (long)53L);
        Assert.assertEquals((long)openingDate.get(13), (long)23L);
    }

    private void assertTimeZoneDate(ZonedDateTime openingDate) {
        Assert.assertEquals((long)openingDate.getYear(), (long)2008L);
        Assert.assertEquals((long)openingDate.getMonthValue(), (long)9L);
        Assert.assertEquals((long)openingDate.getDayOfMonth(), (long)15L);
    }

    private void assertTimeZoneDateTime(ZonedDateTime openingDate) {
        Assert.assertEquals((long)openingDate.getHour(), (long)15L);
        Assert.assertEquals((long)openingDate.getMinute(), (long)53L);
        Assert.assertEquals((long)openingDate.getSecond(), (long)23L);
    }

    private void assertTimeZoneWithoutSeconds(ZonedDateTime openingDate) {
        Assert.assertEquals((long)openingDate.getHour(), (long)15L);
        Assert.assertEquals((long)openingDate.getMinute(), (long)53L);
    }

    private void assertTimeZoneHour(ZonedDateTime openingDate) {
        Assert.assertEquals((long)openingDate.getHour(), (long)15L);
    }
}

