/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.junit4.matchers.ThrowableCauseMatcher;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.sdk.api.error.ErrorTypeDefinition;
import org.mule.sdk.api.exception.ModuleException;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.util.TestConnectivityUtils;
import org.mule.test.heisenberg.extension.HeisenbergErrors;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.some.extension.CustomConnectionException;

public class ConnectivityErrorPropagationTestCase
extends AbstractExtensionFunctionalTestCase {
    private TestConnectivityUtils utils;
    @Rule
    public SystemProperty rule = TestConnectivityUtils.disableAutomaticTestConnectivity();

    @Before
    public void setUp() {
        this.utils = new TestConnectivityUtils(this.registry);
    }

    @BeforeClass
    public static void disableConnectivityTesting() {
        TestConnectivityUtils.disableAutomaticTestConnectivity();
    }

    protected String getConfigFile() {
        return "connectivity-error-propagation-config.xml";
    }

    public boolean addToolingObjectsToRegistry() {
        return true;
    }

    @Test
    public void failAtConnectWithConnectionException() {
        Matcher exceptionMatcher = CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.instanceOf(ConnectionException.class), ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.instanceOf(ModuleException.class))}));
        this.utils.assertFailedConnection("failAtConnectWithConnectionException", exceptionMatcher, CoreMatchers.is((Matcher)ErrorTypeMatcher.errorType((ErrorTypeDefinition)HeisenbergErrors.HEALTH)));
    }

    @Test
    public void failAtConnectWithDomainException() {
        Matcher exceptionMatcher = CoreMatchers.is((Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.instanceOf(ConnectionException.class), ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.instanceOf(CustomConnectionException.class))}));
        this.utils.assertFailedConnection("failAtConnectWithDomainException", exceptionMatcher, CoreMatchers.is((Matcher)ErrorTypeMatcher.errorType((ErrorTypeDefinition)HeisenbergErrors.HEALTH)));
    }

    @Test
    public void failAtValidateWithModuleException() {
        Matcher exceptionMatcher = CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ModuleException.class));
        this.utils.assertFailedConnection("failAtValidateWithModuleException", exceptionMatcher, CoreMatchers.is((Matcher)ErrorTypeMatcher.errorType((ErrorTypeDefinition)HeisenbergErrors.OAUTH2)));
    }

    @Test
    public void failAtValidateWithDomainException() {
        Matcher exceptionMatcher = CoreMatchers.is((Matcher)CoreMatchers.instanceOf(CustomConnectionException.class));
        this.utils.assertFailedConnection("failAtValidateWithDomainException", exceptionMatcher, CoreMatchers.is((Matcher)ErrorTypeMatcher.errorType((ErrorTypeDefinition)HeisenbergErrors.OAUTH2)));
    }
}

