/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.metadata;

import io.qameta.allure.Issue;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.functional.listener.Callback;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.Typed;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.RouterOutputMetadataContext;
import org.mule.runtime.api.metadata.ScopeOutputMetadataContext;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.RouterInputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ScopeInputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.metadata.NullMetadataKey;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ParameterTypeWrapper;
import org.mule.tck.junit4.matcher.MetadataKeyMatcher;
import org.mule.tck.message.StringAttributes;
import org.mule.test.metadata.extension.MetadataConnection;
import org.mule.test.metadata.extension.model.animals.Animal;
import org.mule.test.metadata.extension.model.animals.AnimalClade;
import org.mule.test.metadata.extension.model.animals.Bear;
import org.mule.test.metadata.extension.model.animals.SwordFish;
import org.mule.test.metadata.extension.model.attribute.AbstractOutputAttributes;
import org.mule.test.metadata.extension.model.shapes.Rectangle;
import org.mule.test.metadata.extension.model.shapes.Shape;
import org.mule.test.metadata.extension.resolver.TestThreadContextClassLoaderResolver;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.module.extension.metadata.AbstractMetadataOperationTestCase;
import org.mule.test.module.extension.metadata.MetadataExtensionFunctionalTestCase;

public class MetadataOperationTestCase
extends AbstractMetadataOperationTestCase {
    private static final String MESSAGE_ATTRIBUTES_PERSON_TYPE_METADATA = "messageAttributesPersonTypeMetadata";
    private static final String MESSAGE_ATTRIBUTES_ANY_TYPE_METADATA = "messageAttributesAnyTypeMetadata";
    private static final String PAGED_OPERATION_METADATA = "pagedOperationMetadata";
    private static final String PAGED_OPERATION_METADATA_RESULT = "pagedOperationMetadataResult";
    private static final String PAGED_OPERATION_METADATA_RESULT_WITH_ATTRIBUTES = "pagedOperationMetadataResultWithAttributesResolver";

    public MetadataOperationTestCase(MetadataExtensionFunctionalTestCase.ResolutionType resolutionType) {
        super(resolutionType);
    }

    protected String getConfigFile() {
        return "metadata-tests.xml";
    }

    @Test
    public void getMetadataKeysWithKeyId() throws Exception {
        this.location = Location.builder().globalName("outputMetadataWithKeyId").addProcessorsPart().addIndexPart(0).build();
        MetadataResult metadataKeysResult = this.metadataService.getMetadataKeys(this.location);
        this.assertSuccessResult(metadataKeysResult);
        Set<MetadataKey> metadataKeys = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        MatcherAssert.assertThat((Object)metadataKeys.size(), (Matcher)Is.is((Object)3));
        MatcherAssert.assertThat(metadataKeys, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{MetadataKeyMatcher.metadataKeyWithId((String)"PERSON"), MetadataKeyMatcher.metadataKeyWithId((String)"CAR"), MetadataKeyMatcher.metadataKeyWithId((String)"HOUSE")}));
    }

    @Test
    public void getMetadataKeysWithoutKeyId() throws Exception {
        this.location = Location.builder().globalName("contentMetadataWithoutKeyId").addProcessorsPart().addIndexPart(0).build();
        MetadataResult metadataKeys = this.metadataService.getMetadataKeys(this.location);
        this.assertSuccessResult(metadataKeys);
        Set<MetadataKey> keys = this.getKeysFromContainer((MetadataKeysContainer)metadataKeys.get());
        MatcherAssert.assertThat((Object)keys.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)keys.iterator().next(), (Matcher)Matchers.instanceOf(NullMetadataKey.class));
    }

    @Test
    public void getMultilevelKeys() throws Exception {
        this.location = Location.builder().globalName("simpleMultiLevelKeyResolver").addProcessorsPart().addIndexPart(0).build();
        MetadataResult metadataKeysResult = this.metadataService.getMetadataKeys(this.location);
        this.assertSuccessResult(metadataKeysResult);
        Set<MetadataKey> continents = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        MatcherAssert.assertThat(continents, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(continents, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{MetadataKeyMatcher.metadataKeyWithId((String)"AMERICA").withDisplayName("AMERICA").withPartName("continent"), MetadataKeyMatcher.metadataKeyWithId((String)"EUROPE").withDisplayName("EUROPE").withPartName("continent")}));
        MetadataKey americaKey = continents.iterator().next();
        MatcherAssert.assertThat((Object)americaKey.getChilds(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{MetadataKeyMatcher.metadataKeyWithId((String)"ARGENTINA").withDisplayName("ARGENTINA").withPartName("country"), MetadataKeyMatcher.metadataKeyWithId((String)"USA").withDisplayName("United States").withPartName("country")}));
        MetadataKey argentinaKey = (MetadataKey)americaKey.getChilds().iterator().next();
        MatcherAssert.assertThat((Object)argentinaKey.getChilds(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{MetadataKeyMatcher.metadataKeyWithId((String)"BA").withDisplayName("BA").withPartName("city"), MetadataKeyMatcher.metadataKeyWithId((String)"LPLT").withDisplayName("LPLT").withPartName("city")}));
    }

    @Test
    public void partialMultilevelKeys() throws Exception {
        this.location = Location.builder().globalName("partialMultiLevelKeyResolver").addProcessorsPart().addIndexPart(0).build();
        MetadataResult metadataKeysResult = this.metadataService.getMetadataKeys(this.location);
        this.assertSuccessResult(metadataKeysResult);
        Set<MetadataKey> continents = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        MatcherAssert.assertThat(continents, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(continents, (Matcher)Matchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)"AMERICA").withDisplayName("AMERICA").withPartName("continent")));
        MatcherAssert.assertThat(continents, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)"EUROPE").withDisplayName("EUROPE").withPartName("continent"))));
    }

    @Test
    public void partialMultilevelKeysExplicitResolution() throws Exception {
        this.location = Location.builder().globalName("emptyPartialMultilevelKeys").addProcessorsPart().addIndexPart(0).build();
        MetadataResult metadataKeysResult = this.metadataService.getMetadataKeys(this.location, MetadataKeyBuilder.newKey((String)"AMERICA").withPartName("continent").build());
        this.assertSuccessResult(metadataKeysResult);
        Set<MetadataKey> continents = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        MatcherAssert.assertThat(continents, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(continents, (Matcher)Matchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)"AMERICA").withDisplayName("AMERICA").withPartName("continent")));
        MatcherAssert.assertThat(continents, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)"EUROPE").withDisplayName("EUROPE").withPartName("continent"))));
    }

    @Test
    public void emptyPartialMultilevelKeys() throws Exception {
        this.location = Location.builder().globalName("emptyPartialMultilevelKeys").addProcessorsPart().addIndexPart(0).build();
        MetadataResult metadataKeysResult = this.metadataService.getMetadataKeys(this.location);
        this.assertSuccessResult(metadataKeysResult);
        Set<MetadataKey> continents = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        MatcherAssert.assertThat(continents, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(continents, (Matcher)Matchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)"AMERICA").withDisplayName("AMERICA").withPartName("continent")));
        MatcherAssert.assertThat(continents, (Matcher)Matchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)"EUROPE").withDisplayName("EUROPE").withPartName("continent")));
    }

    @Test
    public void twoLevelPartialMultilevelKeys() throws Exception {
        this.location = Location.builder().globalName("twoLevelPartialMultiLevelKeyResolver").addProcessorsPart().addIndexPart(0).build();
        MetadataResult metadataKeysResult = this.metadataService.getMetadataKeys(this.location);
        this.assertSuccessResult(metadataKeysResult);
        Set<MetadataKey> continents = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        MatcherAssert.assertThat(continents, (Matcher)Matchers.hasSize((int)1));
        Set countries = continents.iterator().next().getChilds();
        MatcherAssert.assertThat((Object)countries, (Matcher)Matchers.hasSize((int)1));
        Set cities = ((MetadataKey)countries.iterator().next()).getChilds();
        MatcherAssert.assertThat((Object)cities, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)cities, (Matcher)Matchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)"BA").withPartName("city")));
        MatcherAssert.assertThat((Object)cities, (Matcher)Matchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)"LPLT").withPartName("city")));
    }

    @Test
    public void twoLevelPartialMultilevelKeysExplicitResolution() throws Exception {
        this.location = Location.builder().globalName("emptyPartialMultilevelKeys").addProcessorsPart().addIndexPart(0).build();
        MetadataResult metadataKeysResult = this.metadataService.getMetadataKeys(this.location, MetadataKeyBuilder.newKey((String)"AMERICA").withPartName("continent").withChild(MetadataKeyBuilder.newKey((String)"ARGENTINA").withPartName("country")).build());
        this.assertSuccessResult(metadataKeysResult);
        Set<MetadataKey> continents = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        MatcherAssert.assertThat(continents, (Matcher)Matchers.hasSize((int)1));
        Set countries = continents.iterator().next().getChilds();
        MatcherAssert.assertThat((Object)countries, (Matcher)Matchers.hasSize((int)1));
        Set cities = ((MetadataKey)countries.iterator().next()).getChilds();
        MatcherAssert.assertThat((Object)cities, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)cities, (Matcher)Matchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)"BA").withPartName("city")));
        MatcherAssert.assertThat((Object)cities, (Matcher)Matchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)"LPLT").withPartName("city")));
    }

    @Test
    public void injectComposedMetadataKeyIdInstanceInMetadataResolver() throws Exception {
        this.location = Location.builder().globalName("simpleMultiLevelKeyResolver").addProcessorsPart().addIndexPart(0).build();
        MetadataKey key = LOCATION_MULTILEVEL_KEY;
        MetadataResult metadataResult = this.metadataService.getOperationMetadata(this.location, key);
        this.assertSuccessResult(metadataResult);
        this.assertResolvedKey(metadataResult, LOCATION_MULTILEVEL_KEY);
    }

    @Test
    public void dynamicOperationMetadata() throws Exception {
        this.location = Location.builder().globalName("contentAndOutputMetadataWithKeyId").addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadataWithKey(PERSON_METADATA_KEY);
        OperationModel typedModel = (OperationModel)metadataDescriptor.getModel();
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "type"), (Type)((Object)String.class));
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "content"), this.personType, true);
    }

    @Test
    public void outputAndMultipleInputWithKeyId() throws Exception {
        this.location = Location.builder().globalName("outputAndMultipleInputWithKeyId").addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadataWithKey(PERSON_METADATA_KEY);
        OperationModel typedModel = (OperationModel)metadataDescriptor.getModel();
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "type"), (Type)((Object)String.class));
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "firstPerson"), this.personType, true);
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "otherPerson"), this.personType, true);
    }

    @Test
    public void multipleInputWithKeyIdExplicitParameterResolution() throws Exception {
        this.location = Location.builder().globalName("outputAndMultipleInputWithKeyId").addProcessorsPart().addIndexPart(0).build();
        MetadataResult inputMetadataResult = this.metadataService.getInputMetadata(this.location, PERSON_METADATA_KEY);
        MatcherAssert.assertThat((Object)inputMetadataResult.isSuccess(), (Matcher)Is.is((Object)true));
        InputMetadataDescriptor inputMetadataDescriptor = (InputMetadataDescriptor)inputMetadataResult.get();
        this.assertExpectedParameterMetadataDescriptor(inputMetadataDescriptor.getParameterMetadata("type"), (Type)((Object)String.class), false);
        this.assertExpectedParameterMetadataDescriptor(inputMetadataDescriptor.getParameterMetadata("firstPerson"), this.personType);
        this.assertExpectedParameterMetadataDescriptor(inputMetadataDescriptor.getParameterMetadata("otherPerson"), this.personType);
    }

    @Test
    @Issue(value="W-15158118")
    public void outputMultipleInputWithKeyIdExplicitParameterResolution() throws Exception {
        this.location = Location.builder().globalName("outputAndMultipleInputWithKeyId").addProcessorsPart().addIndexPart(0).build();
        MetadataResult outputMetadataResult = this.metadataService.getOutputMetadata(this.location, CAR_KEY);
        MatcherAssert.assertThat((Object)outputMetadataResult.isSuccess(), (Matcher)Is.is((Object)true));
        OutputMetadataDescriptor outputMetadataDescriptor = (OutputMetadataDescriptor)outputMetadataResult.get();
        MatcherAssert.assertThat((Object)outputMetadataDescriptor.getPayloadMetadata().isDynamic(), (Matcher)Is.is((Object)true));
        this.assertExpectedType(outputMetadataDescriptor.getPayloadMetadata().getType(), this.carType);
    }

    @Test
    @Issue(value="W-15158118")
    public void outputResolverForScope() throws Exception {
        this.location = Location.builder().globalName("scopeWithOutputResolver").addProcessorsPart().addIndexPart(0).build();
        ScopeOutputMetadataContext scopeContext = new ScopeOutputMetadataContext(){

            public Supplier<MessageMetadataType> getInnerChainOutputMessageType() {
                return () -> MessageMetadataType.builder().payload(MetadataOperationTestCase.this.carType).build();
            }

            public Supplier<MessageMetadataType> getScopeInputMessageType() {
                return () -> null;
            }
        };
        MetadataResult outputMetadataResult = this.metadataService.getScopeOutputMetadata(this.location, CAR_KEY, scopeContext);
        MatcherAssert.assertThat((Object)outputMetadataResult.isSuccess(), (Matcher)Is.is((Object)true));
        OutputMetadataDescriptor outputMetadataDescriptor = (OutputMetadataDescriptor)outputMetadataResult.get();
        MatcherAssert.assertThat((Object)outputMetadataDescriptor.getPayloadMetadata().isDynamic(), (Matcher)Is.is((Object)true));
        this.assertExpectedType(outputMetadataDescriptor.getPayloadMetadata().getType(), this.carType);
    }

    @Test
    @Issue(value="W-14969942")
    public void passthroughInputResolverForScope() throws Exception {
        this.location = Location.builder().globalName("scopeWithOutputResolver").addProcessorsPart().addIndexPart(0).build();
        MessageMetadataType inputMessageType = MessageMetadataType.builder().payload(this.carType).attributes((MetadataType)this.typeBuilder.voidType().build()).build();
        MetadataResult inputMetadata = this.metadataService.getScopeInputMetadata(this.location, CAR_KEY, () -> inputMessageType);
        MatcherAssert.assertThat((Object)inputMetadata.isSuccess(), (Matcher)Is.is((Object)true));
        ScopeInputMetadataDescriptor metadataDescriptor = (ScopeInputMetadataDescriptor)inputMetadata.get();
        MatcherAssert.assertThat((Object)metadataDescriptor.getChainInputMessageType(), (Matcher)Is.is((Matcher)Matchers.sameInstance((Object)inputMessageType)));
    }

    @Test
    @Issue(value="W-14969942")
    public void inputResolverForScope() throws Exception {
        this.location = Location.builder().globalName("scopeWithInputResolver").addProcessorsPart().addIndexPart(0).build();
        MessageMetadataType inputMessageType = MessageMetadataType.builder().payload((MetadataType)this.typeBuilder.withFormat(MetadataFormat.JAVA).objectType().build()).attributes((MetadataType)this.typeBuilder.withFormat(MetadataFormat.JAVA).objectType().build()).build();
        MetadataResult inputMetadata = this.metadataService.getScopeInputMetadata(this.location, null, () -> inputMessageType);
        MatcherAssert.assertThat((Object)inputMetadata.isSuccess(), (Matcher)Is.is((Object)true));
        ScopeInputMetadataDescriptor metadataDescriptor = (ScopeInputMetadataDescriptor)inputMetadata.get();
        MessageMetadataType chainInputMessageType = metadataDescriptor.getChainInputMessageType();
        MatcherAssert.assertThat((Object)((MetadataType)chainInputMessageType.getPayloadType().get()), (Matcher)Is.is((Matcher)Matchers.sameInstance((Object)metadataDescriptor.getParameterMetadata("jsonValue").getType())));
        MatcherAssert.assertThat((Object)((MetadataType)chainInputMessageType.getPayloadType().get()).getMetadataFormat(), (Matcher)Is.is((Object)MetadataFormat.JSON));
        MatcherAssert.assertThat((Object)((MetadataType)chainInputMessageType.getAttributesType().get()), (Matcher)Is.is((Matcher)Matchers.instanceOf(VoidType.class)));
    }

    @Test
    @Issue(value="W-16408471")
    public void scopeWithOnlyChainInputResolver() {
        this.location = Location.builderFromStringRepresentation((String)"scopeWithOnlyChainInputResolver/processors/0").build();
        MessageMetadataType inputMessageType = MessageMetadataType.builder().payload((MetadataType)this.typeBuilder.withFormat(MetadataFormat.JAVA).objectType().build()).attributes((MetadataType)this.typeBuilder.withFormat(MetadataFormat.JAVA).objectType().build()).build();
        MetadataResult inputMetadataResult = this.metadataService.getScopeInputMetadata(this.location, null, () -> inputMessageType);
        MatcherAssert.assertThat((Object)inputMetadataResult.getFailures(), (Matcher)Is.is((Matcher)IsEmptyCollection.empty()));
        ScopeInputMetadataDescriptor inputMetadata = (ScopeInputMetadataDescriptor)inputMetadataResult.get();
        MessageMetadataType routeInputType = inputMetadata.getChainInputMessageType();
        MatcherAssert.assertThat((Object)((MetadataType)routeInputType.getPayloadType().get()), (Matcher)Is.is((Object)STRING_TYPE));
    }

    @Test
    public void outputResolverForRouter() throws Exception {
        this.location = Location.builder().globalName("routerWithMetadataResolver").addProcessorsPart().addIndexPart(0).build();
        RouterOutputMetadataContext routerOutputMetadataContext = new RouterOutputMetadataContext(){

            public Map<String, Supplier<MessageMetadataType>> getRouteOutputMessageTypes() {
                return Collections.singletonMap("metaroute", () -> MessageMetadataType.builder().payload(MetadataOperationTestCase.this.carType).build());
            }

            public Supplier<MessageMetadataType> getRouterInputMessageType() {
                return () -> null;
            }
        };
        MetadataResult outputMetadataResult = this.metadataService.getRouterOutputMetadata(this.location, CAR_KEY, routerOutputMetadataContext);
        MatcherAssert.assertThat((Object)outputMetadataResult.isSuccess(), (Matcher)Is.is((Object)true));
        OutputMetadataDescriptor outputMetadataDescriptor = (OutputMetadataDescriptor)outputMetadataResult.get();
        MatcherAssert.assertThat((Object)outputMetadataDescriptor.getPayloadMetadata().isDynamic(), (Matcher)Is.is((Object)true));
        this.assertExpectedType(outputMetadataDescriptor.getPayloadMetadata().getType(), this.carType);
    }

    @Test
    public void inputResolverForRouter() throws Exception {
        this.location = Location.builder().globalName("routerWithMetadataResolver").addProcessorsPart().addIndexPart(0).build();
        MessageMetadataType inputMessageType = MessageMetadataType.builder().payload((MetadataType)this.typeBuilder.withFormat(MetadataFormat.JAVA).objectType().build()).attributes((MetadataType)this.typeBuilder.withFormat(MetadataFormat.JAVA).objectType().build()).build();
        MetadataResult inputMetadataResult = this.metadataService.getRouterInputMetadata(this.location, null, () -> inputMessageType);
        MatcherAssert.assertThat((Object)inputMetadataResult.isSuccess(), (Matcher)Is.is((Object)true));
        RouterInputMetadataDescriptor inputMetadata = (RouterInputMetadataDescriptor)inputMetadataResult.get();
        MessageMetadataType routeInputType = (MessageMetadataType)inputMetadata.getRouteInputMessageTypes().get("metaroute");
        MatcherAssert.assertThat((Object)((MetadataType)routeInputType.getPayloadType().get()).getMetadataFormat(), (Matcher)Is.is((Object)MetadataFormat.JSON));
    }

    @Test
    @Issue(value="W-16408471")
    public void routerWithOnlyChainInputResolver() {
        this.location = Location.builderFromStringRepresentation((String)"routerWithOnlyChainInputMetadataResolver/processors/0").build();
        MessageMetadataType inputMessageType = MessageMetadataType.builder().payload((MetadataType)this.typeBuilder.withFormat(MetadataFormat.JAVA).objectType().build()).attributes((MetadataType)this.typeBuilder.withFormat(MetadataFormat.JAVA).objectType().build()).build();
        MetadataResult inputMetadataResult = this.metadataService.getRouterInputMetadata(this.location, null, () -> inputMessageType);
        MatcherAssert.assertThat((Object)inputMetadataResult.getFailures(), (Matcher)Is.is((Matcher)IsEmptyCollection.empty()));
        RouterInputMetadataDescriptor inputMetadata = (RouterInputMetadataDescriptor)inputMetadataResult.get();
        MessageMetadataType routeInputType = (MessageMetadataType)inputMetadata.getRouteInputMessageTypes().get("metaroute");
        MatcherAssert.assertThat((Object)((MetadataType)routeInputType.getPayloadType().get()), (Matcher)Is.is((Object)STRING_TYPE));
    }

    @Test
    @Issue(value="W-16433612")
    public void routerWithChainInputResolverOnAliasedRoute() {
        this.location = Location.builderFromStringRepresentation((String)"routerWithChainInputResolverOnAliasedRoute/processors/0").build();
        MessageMetadataType inputMessageType = MessageMetadataType.builder().payload((MetadataType)this.typeBuilder.withFormat(MetadataFormat.JAVA).objectType().build()).attributes((MetadataType)this.typeBuilder.withFormat(MetadataFormat.JAVA).objectType().build()).build();
        MetadataResult inputMetadataResult = this.metadataService.getRouterInputMetadata(this.location, null, () -> inputMessageType);
        MatcherAssert.assertThat((Object)inputMetadataResult.getFailures(), (Matcher)Is.is((Matcher)IsEmptyCollection.empty()));
        RouterInputMetadataDescriptor inputMetadata = (RouterInputMetadataDescriptor)inputMetadataResult.get();
        MatcherAssert.assertThat(inputMetadata.getRouteInputMessageTypes().keySet(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"aliasedRoute"}));
        MessageMetadataType routeInputType = (MessageMetadataType)inputMetadata.getRouteInputMessageTypes().get("aliasedRoute");
        MatcherAssert.assertThat((Object)((MetadataType)routeInputType.getPayloadType().get()).getMetadataFormat(), (Matcher)Is.is((Object)MetadataFormat.JSON));
    }

    @Test
    public void dynamicOutputWithoutContentParam() throws Exception {
        this.location = Location.builder().globalName("outputOnlyWithoutContentParam").addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadataWithKey(PERSON_METADATA_KEY);
        OperationModel typedModel = (OperationModel)metadataDescriptor.getModel();
        this.assertExpectedOutput((ConnectableComponentModel)typedModel, this.personType, Void.TYPE);
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "type"), (Type)((Object)String.class));
    }

    @Test
    public void dynamicContentWithoutOutput() throws Exception {
        this.location = Location.builder().globalName("contentOnlyIgnoresOutput").addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadataWithKey(PERSON_METADATA_KEY);
        OperationModel typedModel = (OperationModel)metadataDescriptor.getModel();
        this.assertExpectedOutput((ConnectableComponentModel)typedModel, Void.TYPE, Void.TYPE);
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "type"), (Type)((Object)String.class));
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "content"), this.personType, true);
    }

    @Test
    public void operationOutputWithoutKeyId() throws Exception {
        this.location = Location.builder().globalName("outputMetadataWithoutKeyId").addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadata((MetadataKey)NULL_METADATA_KEY);
        OperationModel typedModel = (OperationModel)metadataDescriptor.getModel();
        MetadataType objectMetadataType = new ParameterTypeWrapper(Object.class, this.typeLoader).asMetadataType();
        this.assertExpectedOutput((ConnectableComponentModel)typedModel, this.personType, Void.TYPE);
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "content"), objectMetadataType, false);
    }

    @Test
    public void contentAndOutputMetadataWithoutKeyId() throws Exception {
        this.location = Location.builder().globalName("contentAndOutputMetadataWithoutKeyId").addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadata((MetadataKey)NULL_METADATA_KEY);
        OperationModel typedModel = (OperationModel)metadataDescriptor.getModel();
        this.assertExpectedOutput((ConnectableComponentModel)typedModel, this.personType, Void.TYPE);
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "content"), this.personType, true);
    }

    @Test
    public void contentMetadataWithoutKeysWithKeyId() throws Exception {
        this.location = Location.builder().globalName("contentMetadataWithoutKeysWithKeyId").addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadataWithKey(PERSON_METADATA_KEY);
        OperationModel typedModel = (OperationModel)metadataDescriptor.getModel();
        this.assertExpectedOutput((ConnectableComponentModel)typedModel, Void.TYPE, Void.TYPE);
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "type"), (Type)((Object)String.class));
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "content"), this.personType, true);
    }

    @Test
    public void outputMetadataWithoutKeysWithKeyId() throws Exception {
        this.location = Location.builder().globalName("outputMetadataWithoutKeysWithKeyId").addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadataWithKey(PERSON_METADATA_KEY);
        OperationModel typedModel = (OperationModel)metadataDescriptor.getModel();
        this.assertExpectedOutput((ConnectableComponentModel)typedModel, this.personType, Void.TYPE);
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "type"), (Type)((Object)String.class));
    }

    @Test
    public void messageAttributesVoidTypeMetadata() throws Exception {
        this.location = Location.builder().globalName(MESSAGE_ATTRIBUTES_ANY_TYPE_METADATA).addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadata((MetadataKey)NULL_METADATA_KEY);
        OperationModel typedModel = (OperationModel)metadataDescriptor.getModel();
        this.assertExpectedOutput((ConnectableComponentModel)typedModel, (MetadataType)ExtensionsTestUtils.TYPE_BUILDER.anyType().build(), (MetadataType)ExtensionsTestUtils.TYPE_BUILDER.anyType().build());
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "target"), (Type)((Object)String.class));
    }

    @Test
    public void messageAttributesStringTypeMetadata() throws Exception {
        this.location = Location.builder().globalName(MESSAGE_ATTRIBUTES_PERSON_TYPE_METADATA).addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadataWithKey(PERSON_METADATA_KEY);
        OperationModel typedModel = (OperationModel)metadataDescriptor.getModel();
        this.assertExpectedOutput((ConnectableComponentModel)typedModel, this.personType, (Type)((Object)StringAttributes.class));
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "type"), (Type)((Object)String.class));
    }

    @Test
    public void attributesDynamicPersonTypeMetadata() throws Exception {
        this.location = Location.builder().globalName("sdkOutputAttributesWithDynamicMetadata").addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadataWithKey(PERSON_METADATA_KEY);
        OperationModel typedModel = (OperationModel)metadataDescriptor.getModel();
        OutputModel attributesOutputModel = typedModel.getOutputAttributes();
        MatcherAssert.assertThat((Object)attributesOutputModel.hasDynamicType(), (Matcher)Is.is((Object)true));
        MetadataType type = typedModel.getOutputAttributes().getType();
        MatcherAssert.assertThat((Object)type, (Matcher)Is.is((Matcher)Matchers.instanceOf(ObjectType.class)));
        ObjectType dictionary = (ObjectType)type;
        MatcherAssert.assertThat((Object)((MetadataType)dictionary.getOpenRestriction().get()), (Matcher)Is.is((Matcher)Matchers.instanceOf(StringType.class)));
    }

    @Test
    public void messageAttributesStringTypeMetadataExplicitResolution() throws Exception {
        this.location = Location.builder().globalName("sdkOutputAttributesWithDynamicMetadata").addProcessorsPart().addIndexPart(0).build();
        MetadataResult outputMetadataDescriptorResult = this.metadataService.getOutputMetadata(this.location, PERSON_METADATA_KEY);
        MatcherAssert.assertThat((Object)outputMetadataDescriptorResult.isSuccess(), (Matcher)Is.is((Object)true));
        OutputMetadataDescriptor outputMetadataDescriptor = (OutputMetadataDescriptor)outputMetadataDescriptorResult.get();
        TypeMetadataDescriptor attributesMetadata = outputMetadataDescriptor.getAttributesMetadata();
        MatcherAssert.assertThat((Object)attributesMetadata.isDynamic(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)attributesMetadata.getType(), (Matcher)Is.is((Matcher)Matchers.instanceOf(ObjectType.class)));
        ObjectType dictionary = (ObjectType)attributesMetadata.getType();
        MatcherAssert.assertThat((Object)((MetadataType)dictionary.getOpenRestriction().get()), (Matcher)Is.is((Matcher)Matchers.instanceOf(StringType.class)));
    }

    @Test
    public void attributesUnionTypeMetadata() throws Exception {
        this.location = Location.builder().globalName("outputAttributesWithDeclaredSubtypesMetadata").addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadata((MetadataKey)NULL_METADATA_KEY);
        OperationModel typedModel = (OperationModel)metadataDescriptor.getModel();
        this.assertExpectedOutput((ConnectableComponentModel)typedModel, (Type)((Object)Shape.class), (Type)((Object)AbstractOutputAttributes.class));
    }

    @Test
    public void getContentMetadataWithKey() throws Exception {
        this.location = Location.builder().globalName("contentMetadataWithKeyId").addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadataWithKey(PERSON_METADATA_KEY);
        OperationModel typedModel = (OperationModel)metadataDescriptor.getModel();
        this.assertExpectedOutput((ConnectableComponentModel)typedModel, (MetadataType)this.typeBuilder.anyType().build(), Void.TYPE);
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "type"), (Type)((Object)String.class));
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "content"), this.personType, true);
    }

    @Test
    public void getContentMetadataWithoutRequiredKeyId() throws Exception {
        this.location = Location.builder().globalName("contentMetadataWithKeyId").addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadata(PERSON_METADATA_KEY);
        OperationModel typedModel = (OperationModel)metadataDescriptor.getModel();
        this.assertExpectedOutput((ConnectableComponentModel)typedModel, (MetadataType)this.typeBuilder.anyType().build(), Void.TYPE);
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "type"), (Type)((Object)String.class));
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "content"), this.personType, true);
    }

    @Test
    public void getOutputMetadataWithKey() throws Exception {
        this.location = Location.builder().globalName("outputMetadataWithKeyId").addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadataWithKey(PERSON_METADATA_KEY);
        OperationModel typedModel = (OperationModel)metadataDescriptor.getModel();
        MetadataType objectMetadataType = new ParameterTypeWrapper(Object.class, this.typeLoader).asMetadataType();
        this.assertExpectedOutput((ConnectableComponentModel)typedModel, this.personType, Void.TYPE);
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "type"), (Type)((Object)String.class));
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "content"), objectMetadataType, false);
    }

    @Test
    public void dynamicContentWithoutKeyId() throws Exception {
        this.location = Location.builder().globalName("contentMetadataWithoutKeyId").addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadata((MetadataKey)NULL_METADATA_KEY);
        OperationModel typedModel = (OperationModel)metadataDescriptor.getModel();
        this.assertExpectedOutput((ConnectableComponentModel)typedModel, (MetadataType)this.typeBuilder.anyType().build(), Void.TYPE);
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "content"), this.personType, true);
    }

    @Test
    public void dynamicOutputWithoutKeyId() throws Exception {
        this.location = Location.builder().globalName("outputMetadataWithoutKeyId").addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadata((MetadataKey)NULL_METADATA_KEY);
        OperationModel typedModel = (OperationModel)metadataDescriptor.getModel();
        MetadataType objectMetadataType = new ParameterTypeWrapper(Object.class, this.typeLoader).asMetadataType();
        this.assertExpectedOutput((ConnectableComponentModel)typedModel, this.personType, Void.TYPE);
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "content"), objectMetadataType, false);
    }

    @Test
    public void dynamicOutputAndContentWithCache() throws Exception {
        this.location = Location.builder().globalName("contentAndOutputWithCacheResolver").addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadataWithKey(PERSON_METADATA_KEY);
        OperationModel typedModel = (OperationModel)metadataDescriptor.getModel();
        MetadataType outputType = typedModel.getOutput().getType();
        MetadataType contentType = this.getParameter((ComponentModel)typedModel, "content").getType();
        MatcherAssert.assertThat((Object)contentType, (Matcher)Is.is((Matcher)Matchers.equalTo((Object)outputType)));
    }

    @Test
    public void resolverContentWithContextClassLoader() throws Exception {
        this.location = Location.builder().globalName("outputMetadataWithKeyId").addProcessorsPart().addIndexPart(0).build();
        this.resolveTestWithContextClassLoader("resolverContentWithContextClassLoader", (Callback<MetadataOperationTestCase>)((Callback)MetadataExtensionFunctionalTestCase::getSuccessComponentDynamicMetadata));
    }

    @Test
    public void resolverOutputWithContextClassLoader() throws Exception {
        this.location = Location.builder().globalName("outputMetadataWithKeyId").addProcessorsPart().addIndexPart(0).build();
        this.resolveTestWithContextClassLoader("resolverOutputWithContextClassLoader", (Callback<MetadataOperationTestCase>)((Callback)MetadataExtensionFunctionalTestCase::getSuccessComponentDynamicMetadata));
    }

    @Test
    public void shouldInheritOperationResolvers() throws Exception {
        this.location = Location.builder().globalName("shouldInheritOperationParentResolvers").addProcessorsPart().addIndexPart(0).build();
        MetadataResult metadataKeysResult = this.metadataService.getMetadataKeys(this.location);
        this.assertSuccessResult(metadataKeysResult);
        Set<MetadataKey> metadataKeys = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        MatcherAssert.assertThat((Object)metadataKeys.size(), (Matcher)Is.is((Object)3));
        MatcherAssert.assertThat(metadataKeys, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{MetadataKeyMatcher.metadataKeyWithId((String)"PERSON"), MetadataKeyMatcher.metadataKeyWithId((String)"CAR"), MetadataKeyMatcher.metadataKeyWithId((String)"HOUSE")}));
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadata(PERSON_METADATA_KEY);
        OperationModel typedModel = (OperationModel)metadataDescriptor.getModel();
        this.assertExpectedOutput((ConnectableComponentModel)typedModel, this.personType, Void.TYPE);
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "type"), (Type)((Object)String.class));
    }

    @Test
    public void pagedOperationMetadataTestCase() throws Exception {
        this.location = Location.builder().globalName(PAGED_OPERATION_METADATA).addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadata((MetadataKey)NULL_METADATA_KEY);
        ComponentModel typedModel = metadataDescriptor.getModel();
        this.assertExpectedType((Typed)this.getParameter(typedModel, "animal"), (Type)((Object)Animal.class));
    }

    @Test
    public void pagedOperationResultMetadataTestCase() throws Exception {
        this.location = Location.builder().globalName(PAGED_OPERATION_METADATA_RESULT).addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadata(PERSON_METADATA_KEY);
        MetadataType param = ((OperationModel)metadataDescriptor.getModel()).getOutput().getType();
        MatcherAssert.assertThat((Object)param, (Matcher)Is.is((Matcher)Matchers.instanceOf(ArrayType.class)));
        MatcherAssert.assertThat((Object)((String)ExtensionMetadataTypeUtils.getId((MetadataType)param).get()), (Matcher)Is.is((Object)Iterator.class.getName()));
        ExtensionsTestUtils.assertMessageType((MetadataType)((ArrayType)param).getType(), (MetadataType)this.personType, (MetadataType)TYPE_LOADER.load(Animal.class));
    }

    @Test
    public void pagedOperationResultWithAttributeResolverMetadataTestCase() throws Exception {
        this.location = Location.builder().globalName(PAGED_OPERATION_METADATA_RESULT_WITH_ATTRIBUTES).addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadata(PERSON_METADATA_KEY);
        MetadataType param = ((OperationModel)metadataDescriptor.getModel()).getOutput().getType();
        MatcherAssert.assertThat((Object)param, (Matcher)Is.is((Matcher)Matchers.instanceOf(ArrayType.class)));
        MatcherAssert.assertThat((Object)((String)ExtensionMetadataTypeUtils.getId((MetadataType)param).get()), (Matcher)Is.is((Object)Iterator.class.getName()));
        ExtensionsTestUtils.assertMessageType((MetadataType)((ArrayType)param).getType(), (MetadataType)this.personType, (MetadataType)this.personType);
    }

    @Test
    public void componentWithStaticInputs() throws IOException {
        this.location = Location.builder().globalName("typeWithDeclaredSubtypesMetadata").addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadata((MetadataKey)NULL_METADATA_KEY);
        ComponentModel typedModel = metadataDescriptor.getModel();
        this.assertExpectedType((Typed)this.getParameter(typedModel, "plainShape"), (Type)((Object)Shape.class));
        this.assertExpectedType((Typed)this.getParameter(typedModel, "animal"), (Type)((Object)Animal.class));
        this.assertExpectedType((Typed)this.getParameter(typedModel, "rectangleSubtype"), (Type)((Object)Rectangle.class));
    }

    @Test
    public void retrieveKeysFromBooleanMetadataKey() {
        this.location = Location.builder().globalName("booleanMetadataKey").addProcessorsPart().addIndexPart(0).build();
        MetadataResult result = this.metadataService.getMetadataKeys(this.location);
        this.assertSuccessResult(result);
        String booleanMetadataResolver = "BooleanMetadataResolver";
        MatcherAssert.assertThat((Object)((MetadataKeysContainer)result.get()).getCategories(), (Matcher)Matchers.contains((Object[])new String[]{booleanMetadataResolver}));
        Set metadataKeys = (Set)((MetadataKeysContainer)result.get()).getKeys(booleanMetadataResolver).get();
        MatcherAssert.assertThat((Object)metadataKeys, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{MetadataKeyMatcher.metadataKeyWithId((String)"FALSE"), MetadataKeyMatcher.metadataKeyWithId((String)"TRUE")}));
    }

    @Test
    public void booleanMetadataKey() throws IOException {
        this.location = Location.builder().globalName("booleanMetadataKey").addProcessorsPart().addIndexPart(0).build();
        MetadataResult result = this.metadataService.getOperationMetadata(this.location, MetadataKeyBuilder.newKey((String)"true").build());
        this.assertSuccessResult(result);
        this.assertExpectedType((Typed)this.getParameter(((ComponentMetadataDescriptor)result.get()).getModel(), "content"), TYPE_LOADER.load(SwordFish.class), true);
    }

    @Test
    public void retrieveKeysFromEnumMetadataKey() {
        this.location = Location.builder().globalName("enumMetadataKey").addProcessorsPart().addIndexPart(0).build();
        MetadataResult result = this.metadataService.getMetadataKeys(this.location);
        this.assertSuccessResult(result);
        String enumMetadataResolver = "EnumMetadataResolver";
        MatcherAssert.assertThat((Object)((MetadataKeysContainer)result.get()).getCategories(), (Matcher)Matchers.contains((Object[])new String[]{enumMetadataResolver}));
        Set metadataKeys = (Set)((MetadataKeysContainer)result.get()).getKeys(enumMetadataResolver).get();
        MetadataKeyMatcher[] metadataKeyMatchers = (MetadataKeyMatcher[])Stream.of(AnimalClade.values()).map(Object::toString).map(MetadataKeyMatcher::metadataKeyWithId).toArray(MetadataKeyMatcher[]::new);
        MatcherAssert.assertThat((Object)metadataKeys, (Matcher)Matchers.hasItems((Matcher[])metadataKeyMatchers));
    }

    @Test
    public void enumMetadataKey() throws IOException {
        this.location = Location.builder().globalName("enumMetadataKey").addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadata(MetadataKeyBuilder.newKey((String)"MAMMAL").build());
        ComponentModel typedModel = metadataDescriptor.getModel();
        this.assertExpectedType((Typed)this.getParameter(typedModel, "content"), TYPE_LOADER.load(Bear.class), true);
    }

    @Test
    public void metadataKeyDefaultValue() throws Exception {
        this.location = Location.builder().globalName("metadataKeyDefaultValue").addProcessorsPart().addIndexPart(0).build();
        MetadataResult result = this.metadataService.getOperationMetadata(this.location);
        this.assertSuccessResult(result);
        MetadataType type = ((OperationModel)((ComponentMetadataDescriptor)result.get()).getModel()).getOutput().getType();
        MatcherAssert.assertThat((Object)type, (Matcher)Is.is((Matcher)Matchers.instanceOf(ObjectType.class)));
        ObjectType objectType = (ObjectType)type;
        MatcherAssert.assertThat((Object)objectType.getFields(), (Matcher)Matchers.hasSize((int)2));
        objectType.getFields().forEach(f -> MatcherAssert.assertThat((Object)f.getKey().getName().getLocalPart(), (Matcher)Matchers.isOneOf((Object[])new String[]{"Tires", "Brand"})));
        Optional metadataKeyOptional = ((ComponentMetadataDescriptor)result.get()).getMetadataAttributes().getKey();
        MatcherAssert.assertThat((Object)metadataKeyOptional.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((MetadataKey)metadataKeyOptional.get()).getId(), (Matcher)Is.is((Object)"CAR"));
    }

    @Test
    public void defaultValueMetadataKey() throws Exception {
        this.location = Location.builder().globalName("metadataKeyDefaultValue").addProcessorsPart().addIndexPart(0).build();
        MetadataResult result = this.metadataService.getOperationMetadata(this.location);
        this.assertSuccessResult(result);
        this.assertResolvedKey(result, CAR_KEY);
        ComponentMetadataDescriptor descriptor = (ComponentMetadataDescriptor)result.get();
        MetadataType type = ((OperationModel)descriptor.getModel()).getOutput().getType();
        MatcherAssert.assertThat((Object)type, (Matcher)Is.is((Matcher)Matchers.instanceOf(ObjectType.class)));
        MatcherAssert.assertThat((Object)((ObjectType)type).getFields(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void operationWithOptionalMetadataKeyIdNotConfigured() throws Exception {
        this.location = Location.builder().globalName("metadataKeyOptional").addProcessorsPart().addIndexPart(0).build();
        MetadataResult result = this.metadataService.getOperationMetadata(this.location);
        this.assertSuccessResult(result);
    }

    @Test
    public void operationWhichReturnsListOfMessages() throws Exception {
        this.location = Location.builder().globalName("listOfMessages").addProcessorsPart().addIndexPart(0).build();
        MetadataResult result = this.metadataService.getOperationMetadata(this.location);
        this.assertSuccessResult(result);
        ComponentMetadataDescriptor descriptor = (ComponentMetadataDescriptor)result.get();
        MetadataType param = ((OperationModel)descriptor.getModel()).getOutput().getType();
        MatcherAssert.assertThat((Object)param, (Matcher)Is.is((Matcher)Matchers.instanceOf(ArrayType.class)));
        ExtensionsTestUtils.assertMessageType((MetadataType)((ArrayType)param).getType(), (MetadataType)TYPE_LOADER.load(String.class), (MetadataType)TYPE_LOADER.load(StringAttributes.class));
    }

    @Test
    public void operationWhichReturnsDynamicListOfMessages() throws Exception {
        this.location = Location.builder().globalName("dynamicListOfMessages").addProcessorsPart().addIndexPart(0).build();
        MetadataType param = this.getResolvedTypeFromList();
        ExtensionsTestUtils.assertMessageType((MetadataType)((ArrayType)param).getType(), (MetadataType)this.personType, (MetadataType)ExtensionsTestUtils.TYPE_BUILDER.anyType().build());
    }

    @Test
    public void operationWhichReturnsDynamicListOfObjects() throws Exception {
        this.location = Location.builder().globalName("dynamicListOfObjects").addProcessorsPart().addIndexPart(0).build();
        MetadataType param = this.getResolvedTypeFromList();
        this.assertExpectedType(((ArrayType)param).getType(), this.personType);
    }

    @Test
    public void operationReceivesListOfObjects() throws Exception {
        this.location = Location.builder().globalName("objectListAsInput").addProcessorsPart().addIndexPart(0).build();
        MetadataResult operationMetadata = this.metadataService.getOperationMetadata(this.location);
        MetadataType objects = this.getParameter(((ComponentMetadataDescriptor)operationMetadata.get()).getModel(), "objects").getType();
        MatcherAssert.assertThat((Object)objects, (Matcher)Is.is((Matcher)Matchers.instanceOf(ArrayType.class)));
        MatcherAssert.assertThat((Object)((ArrayType)objects).getType(), (Matcher)Is.is((Object)this.personType));
    }

    @Test
    public void operationReceivesNullTypeOfList() throws Exception {
        this.location = Location.builder().globalName("nullListAsInput").addProcessorsPart().addIndexPart(0).build();
        MetadataResult operationMetadata = this.metadataService.getOperationMetadata(this.location);
        MetadataType objects = this.getParameter(((ComponentMetadataDescriptor)operationMetadata.get()).getModel(), "objects").getType();
        MatcherAssert.assertThat((Object)objects, (Matcher)Is.is((Matcher)Matchers.instanceOf(NullType.class)));
    }

    @Test
    public void operationReceivesExclusiveOptionalParameterGroup() throws Exception {
        this.location = Location.builder().globalName("inputHasExclusiveOptionalParameterGroup").addProcessorsPart().addIndexPart(0).build();
        MetadataResult operationMetadata = this.metadataService.getOperationMetadata(this.location);
        ParameterGroupModel dessert = this.getParameterGroup(((ComponentMetadataDescriptor)operationMetadata.get()).getModel(), "dessert");
        MatcherAssert.assertThat((Object)dessert.getName(), (Matcher)Is.is((Object)"dessert"));
    }

    @Test
    public void operationReceivesPojoWithExclusiveOptionalParameterGroup() throws Exception {
        this.location = Location.builder().globalName("inputHasPojoWithExclusiveOptionalParameterGroup").addProcessorsPart().addIndexPart(0).build();
        MetadataResult operationMetadata = this.metadataService.getOperationMetadata(this.location);
        ParameterModel dessertOrder = this.getParameter(((ComponentMetadataDescriptor)operationMetadata.get()).getModel(), "dessertOrder");
        MatcherAssert.assertThat((Object)dessertOrder.getName(), (Matcher)Is.is((Object)"dessertOrder"));
    }

    @Test
    public void partialMultiLevelKeyShowInDslResolver() throws Exception {
        this.location = Location.builder().globalName("partialMultiLevelKeyShowInDslResolver").addProcessorsPart().addIndexPart(0).build();
        MetadataResult metadataKeysResult = this.metadataService.getMetadataKeys(this.location);
        this.assertSuccessResult(metadataKeysResult);
        Set<MetadataKey> continents = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        MatcherAssert.assertThat(continents, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(continents, (Matcher)Matchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)"AMERICA").withDisplayName("AMERICA").withPartName("continent")));
        MatcherAssert.assertThat(continents, (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)"EUROPE").withDisplayName("EUROPE").withPartName("continent"))));
    }

    @Test
    public void outputMetadataWithoutKeysWithKeyIdWithConfig() throws Exception {
        this.location = Location.builder().globalName("outputMetadataWithKeyIdUsingConfig").addProcessorsPart().addIndexPart(0).build();
        ComponentMetadataDescriptor metadataDescriptor = this.getSuccessComponentDynamicMetadataWithKey(PERSON_METADATA_KEY);
        OperationModel typedModel = (OperationModel)metadataDescriptor.getModel();
        this.assertExpectedOutput((ConnectableComponentModel)typedModel, this.personType, Void.TYPE);
        this.assertExpectedType((Typed)this.getParameter((ComponentModel)typedModel, "type"), (Type)((Object)String.class));
    }

    private MetadataType getResolvedTypeFromList() {
        MetadataResult result = this.metadataService.getOperationMetadata(this.location);
        this.assertSuccessResult(result);
        ComponentMetadataDescriptor descriptor = (ComponentMetadataDescriptor)result.get();
        MetadataType param = ((OperationModel)descriptor.getModel()).getOutput().getType();
        MatcherAssert.assertThat((Object)param, (Matcher)Is.is((Matcher)Matchers.instanceOf(ArrayType.class)));
        MatcherAssert.assertThat((Object)((String)ExtensionMetadataTypeUtils.getId((MetadataType)param).get()), (Matcher)Is.is((Object)List.class.getName()));
        return param;
    }

    private void resolveTestWithContextClassLoader(String flowName, Callback<MetadataOperationTestCase> doAction) throws Exception {
        this.location = Location.builder().globalName(flowName).addProcessorsPart().addIndexPart(0).build();
        TestThreadContextClassLoaderResolver.reset();
        ClassLoader originalClassLoader = MetadataConnection.class.getClassLoader();
        ClassUtils.withContextClassLoader((ClassLoader)((ClassLoader)Mockito.mock(ClassLoader.class)), () -> {
            doAction.execute((Object)this);
            MatcherAssert.assertThat((Object)TestThreadContextClassLoaderResolver.getCurrentState(), (Matcher)Is.is((Matcher)Matchers.sameInstance((Object)originalClassLoader)));
        });
    }

    private ParameterModel getParameter(ComponentModel model, String parameterName) {
        return model.getAllParameterModels().stream().filter(p -> p.getName().equals(parameterName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Parameter not found"));
    }

    private ParameterGroupModel getParameterGroup(ComponentModel model, String parameterName) {
        return model.getParameterGroupModels().stream().filter(p -> p.getName().equals(parameterName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Parameter Group not found"));
    }
}

