/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.parameter.group;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.some.extension.SomeAliasedParameterGroupOneRequiredConfig;
import org.mule.test.some.extension.SomeParameterGroupOneRequiredConfig;

@Feature(value="Java SDK")
@Story(value="Parameters definitions in Java SDK")
public class ParameterGroupExclusiveOptionalsOneRequiredTestCase
extends AbstractExtensionFunctionalTestCase {
    protected String getConfigFile() {
        return "values/some-parameter-group-config.xml";
    }

    @Test
    public void testShowInDslTrueWithSimpleParameter() throws Exception {
        SomeParameterGroupOneRequiredConfig config = (SomeParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("dslTrueSomeParameter");
        Assert.assertThat((Object)config.getSomeParameter(), (Matcher)CoreMatchers.is((Object)"hello dog!"));
    }

    @Test
    public void testShowInDslTrueWithComplexParameter() throws Exception {
        SomeParameterGroupOneRequiredConfig config = (SomeParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("dslTrueComplexParameter");
        Assert.assertThat((Object)config.getComplexParameter().getAnotherParameter(), (Matcher)CoreMatchers.is((Object)"hello bird!"));
    }

    @Test
    public void testShowInDslTrueWithDynamicSimpleParameter() throws Exception {
        SomeParameterGroupOneRequiredConfig config = (SomeParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("dslTrueSomeParameterDynamic", "someParameter", "hello dog!");
        Assert.assertThat((Object)config.getSomeParameter(), (Matcher)CoreMatchers.is((Object)"hello dog!"));
    }

    @Test
    public void testShowInDslTrueWithDynamicComplexParameter() throws Exception {
        SomeParameterGroupOneRequiredConfig config = (SomeParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("dslTrueComplexParameterDynamic", "anotherParameter", "hello bird!");
        Assert.assertThat((Object)config.getComplexParameter().getAnotherParameter(), (Matcher)CoreMatchers.is((Object)"hello bird!"));
    }

    @Test
    public void testWithSimpleParameter() throws Exception {
        SomeParameterGroupOneRequiredConfig config = (SomeParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("someParameter");
        Assert.assertThat((Object)config.getSomeParameter(), (Matcher)CoreMatchers.is((Object)"hello dog!"));
    }

    @Test
    public void testWithComplexParameter() throws Exception {
        SomeParameterGroupOneRequiredConfig config = (SomeParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("complexParameter");
        Assert.assertThat((Object)config.getComplexParameter().getAnotherParameter(), (Matcher)CoreMatchers.is((Object)"hello bird!"));
    }

    @Test
    public void testWithDynamicSimpleParameter() throws Exception {
        SomeParameterGroupOneRequiredConfig config = (SomeParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("someParameterDynamic", "someParameter", "hello dog!");
        Assert.assertThat((Object)config.getSomeParameter(), (Matcher)CoreMatchers.is((Object)"hello dog!"));
    }

    @Test
    public void testWithDynamicComplexParameter() throws Exception {
        SomeParameterGroupOneRequiredConfig config = (SomeParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("complexParameterDynamic", "anotherParameter", "hello bird!");
        Assert.assertThat((Object)config.getComplexParameter().getAnotherParameter(), (Matcher)CoreMatchers.is((Object)"hello bird!"));
    }

    @Test
    public void testShowInDslTrueWithRepeatedNameParameter() throws Exception {
        SomeParameterGroupOneRequiredConfig config = (SomeParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("dslTrueRepeatedNameParameter");
        Assert.assertThat((Object)config.getRepeatedNameParameter(), (Matcher)CoreMatchers.is((Object)"hello cat!"));
    }

    @Test
    public void testShowInDslTrueWithComplexParameterWithRepeatedNameParameter() throws Exception {
        SomeParameterGroupOneRequiredConfig config = (SomeParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("dslTrueComplexParameterWithRepeatedNameParameter");
        Assert.assertThat((Object)config.getComplexParameter().getRepeatedNameParameter(), (Matcher)CoreMatchers.is((Object)"hi bird!"));
    }

    @Test
    public void testShowInDslTrueWithDynamicSimpleParameterWithRepeatedNameParameter() throws Exception {
        SomeParameterGroupOneRequiredConfig config = (SomeParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("dslTrueSomeParameterDynamicWithRepeatedNameParameter", "repeatedNameParameter", "hello cat!");
        Assert.assertThat((Object)config.getRepeatedNameParameter(), (Matcher)CoreMatchers.is((Object)"hello cat!"));
    }

    @Test
    public void testShowInDslTrueWithDynamicComplexParameterWithRepeatedNameParameter() throws Exception {
        SomeParameterGroupOneRequiredConfig config = (SomeParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("dslTrueComplexParameterDynamicWithRepeatedNameParameter", "repeatedNameParameter", "hi bird!");
        Assert.assertThat((Object)config.getComplexParameter().getRepeatedNameParameter(), (Matcher)CoreMatchers.is((Object)"hi bird!"));
    }

    @Test
    public void testWithRepeatedNameParameter() throws Exception {
        SomeParameterGroupOneRequiredConfig config = (SomeParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("repeatedNameParameter");
        Assert.assertThat((Object)config.getRepeatedNameParameter(), (Matcher)CoreMatchers.is((Object)"hello cat!"));
    }

    @Test
    public void testWithComplexParameterWithRepeatedNameParameter() throws Exception {
        SomeParameterGroupOneRequiredConfig config = (SomeParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("complexParameterWithRepeatedNameParameter");
        Assert.assertThat((Object)config.getComplexParameter().getRepeatedNameParameter(), (Matcher)CoreMatchers.is((Object)"hi bird!"));
    }

    @Test
    public void testWithDynamicRepeatedNameParameter() throws Exception {
        SomeParameterGroupOneRequiredConfig config = (SomeParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("repeatedNameParameterDynamic", "repeatedNameParameter", "hello cat!");
        Assert.assertThat((Object)config.getRepeatedNameParameter(), (Matcher)CoreMatchers.is((Object)"hello cat!"));
    }

    @Test
    public void testWithDynamicComplexParameterWithRepeatedNameParameter() throws Exception {
        SomeParameterGroupOneRequiredConfig config = (SomeParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("complexParameterWithRepeatedNameParameterDynamic", "repeatedNameParameter", "hi bird!");
        Assert.assertThat((Object)config.getComplexParameter().getRepeatedNameParameter(), (Matcher)CoreMatchers.is((Object)"hi bird!"));
    }

    @Test
    public void testWithDslTrueRepeatedParameterNameInComplexParameter() throws Exception {
        Map<String, String> values = this.runFlowAndGetValues("dslTrueRepeatedParameterNameInComplexParameter");
        Assert.assertThat((Object)values.get("pojoParameter"), (Matcher)CoreMatchers.is((Object)"hi lizard!"));
        Assert.assertThat((Object)values.get("oneParameterGroup"), (Matcher)CoreMatchers.is((Object)"hi bird!"));
    }

    @Test
    public void testWithDslTrueRepeatedParameterNameInComplexParameterDynamic() throws Exception {
        Map<String, String> values = this.runFlowAndGetValues("dslTrueRepeatedParameterNameInComplexParameterDynamic");
        Assert.assertThat((Object)values.get("pojoParameter"), (Matcher)CoreMatchers.is((Object)"hi lizard!"));
        Assert.assertThat((Object)values.get("oneParameterGroup"), (Matcher)CoreMatchers.is((Object)"hi bird!"));
    }

    @Test
    public void testWithDslTrueRepeatedParameterNameInParameterGroup() throws Exception {
        Map<String, String> values = this.runFlowAndGetValues("dslTrueRepeatedParameterNameInParameterGroup");
        Assert.assertThat((Object)values.get("pojoParameter"), (Matcher)CoreMatchers.is((Object)"hi lizard!"));
        Assert.assertThat((Object)values.get("oneParameterGroup"), (Matcher)CoreMatchers.is((Object)"hello cat!"));
    }

    @Test
    public void testWithDslTrueRepeatedParameterNameInParameterGroupDynamic() throws Exception {
        Map<String, String> values = this.runFlowAndGetValues("dslTrueRepeatedParameterNameInParameterGroupDynamic");
        Assert.assertThat((Object)values.get("pojoParameter"), (Matcher)CoreMatchers.is((Object)"hi lizard!"));
        Assert.assertThat((Object)values.get("oneParameterGroup"), (Matcher)CoreMatchers.is((Object)"hello cat!"));
    }

    @Test
    public void testWithRepeatedParameterNameInComplexParameter() throws Exception {
        Map<String, String> values = this.runFlowAndGetValues("repeatedParameterNameInComplexParameter");
        Assert.assertThat((Object)values.get("pojoParameter"), (Matcher)CoreMatchers.is((Object)"hi lizard!"));
        Assert.assertThat((Object)values.get("oneParameterGroup"), (Matcher)CoreMatchers.is((Object)"hi bird!"));
    }

    @Test
    public void testWithRepeatedParameterNameInComplexParameterDynamic() throws Exception {
        Map<String, String> values = this.runFlowAndGetValues("repeatedParameterNameInComplexParameterDynamic");
        Assert.assertThat((Object)values.get("pojoParameter"), (Matcher)CoreMatchers.is((Object)"hi lizard!"));
        Assert.assertThat((Object)values.get("oneParameterGroup"), (Matcher)CoreMatchers.is((Object)"hi bird!"));
    }

    @Test
    public void testWithRepeatedParameterNameInParameterGroup() throws Exception {
        Map<String, String> values = this.runFlowAndGetValues("repeatedParameterNameInParameterGroup");
        Assert.assertThat((Object)values.get("pojoParameter"), (Matcher)CoreMatchers.is((Object)"hi lizard!"));
        Assert.assertThat((Object)values.get("oneParameterGroup"), (Matcher)CoreMatchers.is((Object)"hello cat!"));
    }

    @Test
    public void testWithRepeatedParameterNameInParameterGroupDynamic() throws Exception {
        Map<String, String> values = this.runFlowAndGetValues("repeatedParameterNameInParameterGroupDynamic");
        Assert.assertThat((Object)values.get("pojoParameter"), (Matcher)CoreMatchers.is((Object)"hi lizard!"));
        Assert.assertThat((Object)values.get("oneParameterGroup"), (Matcher)CoreMatchers.is((Object)"hello cat!"));
    }

    public void testShowInDslTrueWithSimpleParameterAlias() throws Exception {
        SomeAliasedParameterGroupOneRequiredConfig config = (SomeAliasedParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("dslTrueSomeParameterAlias");
        Assert.assertThat((Object)config.getSomeParameter(), (Matcher)CoreMatchers.is((Object)"hello dog!"));
    }

    @Test
    public void testShowInDslTrueWithComplexParameterAlias() throws Exception {
        SomeAliasedParameterGroupOneRequiredConfig config = (SomeAliasedParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("dslTrueComplexParameterAlias");
        Assert.assertThat((Object)config.getComplexParameter().getAnotherParameter(), (Matcher)CoreMatchers.is((Object)"hello bird!"));
    }

    @Test
    public void testShowInDslTrueWithDynamicSimpleParameterAlias() throws Exception {
        SomeAliasedParameterGroupOneRequiredConfig config = (SomeAliasedParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("dslTrueSomeParameterAliasDynamic", "someParameter", "hello dog!");
        Assert.assertThat((Object)config.getSomeParameter(), (Matcher)CoreMatchers.is((Object)"hello dog!"));
    }

    @Test
    public void testShowInDslTrueWithDynamicComplexParameterAlias() throws Exception {
        SomeAliasedParameterGroupOneRequiredConfig config = (SomeAliasedParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("dslTrueComplexParameterAliasDynamic", "anotherParameter", "hello bird!");
        Assert.assertThat((Object)config.getComplexParameter().getAnotherParameter(), (Matcher)CoreMatchers.is((Object)"hello bird!"));
    }

    @Test
    public void testWithSimpleParameterAlias() throws Exception {
        SomeAliasedParameterGroupOneRequiredConfig config = (SomeAliasedParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("someParameterAlias");
        Assert.assertThat((Object)config.getSomeParameter(), (Matcher)CoreMatchers.is((Object)"hello dog!"));
    }

    @Test
    public void testWithComplexParameterAlias() throws Exception {
        SomeAliasedParameterGroupOneRequiredConfig config = (SomeAliasedParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("complexParameterAlias");
        Assert.assertThat((Object)config.getComplexParameter().getAnotherParameter(), (Matcher)CoreMatchers.is((Object)"hello bird!"));
    }

    @Test
    public void testWithDynamicSimpleParameterAlias() throws Exception {
        SomeAliasedParameterGroupOneRequiredConfig config = (SomeAliasedParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("someParameterAliasDynamic", "someParameter", "hello dog!");
        Assert.assertThat((Object)config.getSomeParameter(), (Matcher)CoreMatchers.is((Object)"hello dog!"));
    }

    @Test
    public void testWithDynamicComplexParameterAlias() throws Exception {
        SomeAliasedParameterGroupOneRequiredConfig config = (SomeAliasedParameterGroupOneRequiredConfig)this.runFlowAndGetConfig("complexParameterAliasDynamic", "anotherParameter", "hello bird!");
        Assert.assertThat((Object)config.getComplexParameter().getAnotherParameter(), (Matcher)CoreMatchers.is((Object)"hello bird!"));
    }

    private <T> T runFlowAndGetConfig(String flowName) throws Exception {
        return this.runFlowAndGetConfig(flowName, "", "");
    }

    private <T> T runFlowAndGetConfig(String flowName, String variableName, String variableValue) throws Exception {
        return (T)((FlowRunner)this.flowRunner(flowName).withVariable(variableName, (Object)variableValue)).run().getMessage().getPayload().getValue();
    }

    private Map<String, String> runFlowAndGetValues(String flowName) throws Exception {
        return (Map)this.flowRunner(flowName).run().getMessage().getPayload().getValue();
    }
}

