/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.tck.probe.PollingProber;
import org.mule.test.metadata.extension.CustomStaticMetadataOperations;
import org.mule.test.metadata.extension.CustomStaticMetadataSource;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class CustomStaticMetadataOperationExecutionTestCase
extends AbstractExtensionFunctionalTestCase {
    @Inject
    public Flow onSuccessCustomType;
    @Inject
    public Flow onErrorCustomType;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String[] getConfigFiles() {
        return new String[]{"metadata-static.xml"};
    }

    @Test
    public void xmlOutput() throws Exception {
        Object payload = this.flowRunner("output").keepStreamsOpen().run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)IOUtils.toString((InputStream)((InputStream)((CursorStreamProvider)payload).openCursor())), (Matcher)CoreMatchers.is((Object)CustomStaticMetadataOperations.XML_VALUE));
    }

    @Test
    public void xmlInput() throws Exception {
        Object payload = ((FlowRunner)this.flowRunner("input").withPayload((Object)CustomStaticMetadataOperations.XML_VALUE)).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)payload, (Matcher)CoreMatchers.is((Object)CustomStaticMetadataOperations.XML_VALUE));
    }

    @Test
    public void jsonInputToMap() throws Exception {
        Object payload = this.flowRunner("jsonInputToMap").keepStreamsOpen().run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)payload, (Matcher)CoreMatchers.is((Object)12));
    }

    @Test
    public void jsonInputToStream() throws Exception {
        String payload = (String)this.flowRunner("jsonInputToStream").keepStreamsOpen().run().getMessage().getPayload().getValue();
        this.assertEqualJsons(payload, "{\"age\":12,\"dni\": 1478231}");
    }

    @Test
    public void jsonOutput() throws Exception {
        Object payload = this.flowRunner("jsonOutput").keepStreamsOpen().run().getMessage().getPayload().getValue();
        this.assertEqualJsons(IOUtils.toString((InputStream)((InputStream)((CursorStreamProvider)payload).openCursor())), "{\"age\":12,\"dni\": 1478231}");
    }

    @Test
    public void customOutput() throws Exception {
        Object payload = this.flowRunner("custom-output").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)payload, (Matcher)CoreMatchers.is((Object)"Name,LastName\\njuan,desimoni\\nesteban,wasinger"));
    }

    @Test
    public void onErrorCustomType() throws MuleException {
        this.onErrorCustomType.start();
        PollingProber.probe((long)5000L, (long)20L, () -> {
            if (CustomStaticMetadataSource.onErrorResult != null) {
                JsonParser parser = new JsonParser();
                JsonElement payloadTree = parser.parse(CustomStaticMetadataSource.onErrorResult);
                JsonElement expectedTree = parser.parse("{\"age\":12,\"dni\": 1478231}");
                return payloadTree.equals(expectedTree);
            }
            return false;
        }, () -> "OnError was not called");
    }

    @Test
    public void onSuccessCustomType() throws MuleException {
        String expected = "<?xml version='1.0' encoding='UTF-8'?>\n<person>\n  <age>12</age>\n</person>";
        this.onSuccessCustomType.start();
        PollingProber.probe((long)5000L, (long)20L, () -> {
            if (CustomStaticMetadataSource.onSuccessResult != null) {
                if (CustomStaticMetadataSource.onSuccessResult.equals(expected)) {
                    return true;
                }
                throw new RuntimeException("That Xml was not expected");
            }
            return false;
        }, () -> "OnSuccess was not called");
    }

    @Test
    public void customInput() throws Exception {
        String payload = (String)this.flowRunner("custom-input").run().getMessage().getPayload().getValue();
        this.assertEqualJsons(payload, "{\"age\":12,\"dni\": 1478231}");
    }

    @Test
    public void customIntersectionTypeInput() throws Exception {
        String payload = (String)this.flowRunner("custom-intersection-type-input").run().getMessage().getPayload().getValue();
        this.assertEqualJsons(payload, "{\"age\":12,\"dni\": 1478231}");
    }

    @Test
    public void customIntersectionTypeOutput() throws Exception {
        String payload = (String)this.flowRunner("custom-intersection-type-output").run().getMessage().getPayload().getValue();
        this.assertEqualJsons(payload, "{\"age\":12,\"dni\": 1478231}");
    }

    private void assertEqualJsons(String payload, String expected) throws IOException {
        JsonParser parser = new JsonParser();
        JsonElement payloadTree = parser.parse(payload);
        JsonElement expectedTree = parser.parse(expected);
        Assert.assertThat((Object)payloadTree, (Matcher)CoreMatchers.is((Object)expectedTree));
    }
}

