/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.classloading;

import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.util.TestConnectivityUtils;
import org.mule.test.classloading.api.ClassLoadingHelper;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class ClassLoadingOnConnectionsTestCase
extends AbstractExtensionFunctionalTestCase {
    @Rule
    public SystemProperty disableTestConnectivity = TestConnectivityUtils.disableAutomaticTestConnectivity();

    protected void doTearDown() throws Exception {
        ClassLoadingHelper.createdClassLoaders.clear();
    }

    protected String getConfigFile() {
        return "classloading/classloading-extension-config.xml";
    }

    @Test
    public void noneConnectionProvider() throws Exception {
        this.flowRunner("none-operation").run();
        ClassLoadingHelper.verifyUsedClassLoaders((String[])new String[]{"allOptionalParameterGroup", "Connect", "Disconnect"});
    }

    @Test
    public void cachedConnectionProvider() throws Exception {
        this.flowRunner("cached-operation").run();
        ClassLoadingHelper.verifyUsedClassLoaders((String[])new String[]{"allOptionalParameterGroup", "Connect"});
    }

    @Test
    public void poolingConnectionProvider() throws Exception {
        this.flowRunner("pooling-operation").run();
        ClassLoadingHelper.verifyUsedClassLoaders((String[])new String[]{"allOptionalParameterGroup", "Connect", "OnBorrow", "OnReturn"});
    }

    @Test
    public void allOptionalParameterGroup() throws Exception {
        ClassLoadingHelper.verifyUsedClassLoaders((String[])new String[]{"allOptionalParameterGroup"});
    }
}

