/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.HeisenbergOperations;
import org.mule.test.heisenberg.extension.MoneyLaunderingOperation;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class DynamicConfigExpirationTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final int PROBER_TIMEOUT = 20000;
    private static final int POLLING_FREQUENCY = 2500;
    @Inject
    @Named(value="sourceWithDynamicConfig")
    public Flow sourceWithDynamicConfig;
    private static List<Integer> disposedStatuses;
    private static HeisenbergExtension config;

    protected String getConfigFile() {
        return "dynamic-config-expiration.xml";
    }

    @Before
    public void setUp() {
        disposedStatuses = new ArrayList<Integer>();
        config = null;
        DynamicConfigExpirationTestCase.resetCounters();
    }

    protected void doTearDown() throws Exception {
        disposedStatuses = null;
        config = null;
        super.doTearDown();
    }

    @Test
    public void expireDynamicConfig() throws Exception {
        HeisenbergExtension config = this.invokeDynamicConfig("dynamic", "heisenberg", "Walt");
        this.assertExpired(config, 5000L, 1000L);
        this.assertInitialised(config);
    }

    @Test
    public void expireDynamicConfigWithCustomExpiration() throws Exception {
        HeisenbergExtension config = this.invokeDynamicConfig("dynamicWithCustomExpiration", "heisenbergWithCustomExpiration", "Walter Jr.");
        try {
            this.assertExpired(config, 1500L, 100L);
            throw new IllegalStateException("Config should not have been expired");
        }
        catch (AssertionError assertionError) {
            this.assertExpired(config, 5000L, 1000L);
            this.assertInitialised(config);
            return;
        }
    }

    @Test
    public void doNotExpireDynamicConfigWithCustomExpirationUsedBySource() throws Exception {
        HeisenbergExtension config = this.invokeDynamicConfig("dynamicWithCustomExpirationForSource", "heisenbergWithCustomExpirationForSource", "Walter Blanco");
        try {
            this.assertExpired(config, 10000L, 1000L);
            throw new IllegalStateException("Config should not have been expired");
        }
        catch (AssertionError assertionError) {
            this.assertInitialised(config);
            this.sourceWithDynamicConfig.stop();
            this.assertExpired(config, 6000L, 100L);
            return;
        }
    }

    @Test
    public void expirationWorksAfterRestartingSource() throws Exception {
        this.doNotExpireDynamicConfigWithCustomExpirationUsedBySource();
        this.sourceWithDynamicConfig.start();
        this.doNotExpireDynamicConfigWithCustomExpirationUsedBySource();
    }

    @Test
    public void dynamicConfigIsExpiredBeforeFlowEnds() throws Exception {
        this.flowRunner("dynamicConfigIsExpiredBeforeFlowEnds").run();
        this.assertDisposedStatuses(Arrays.asList(0, 1));
    }

    @Test
    public void dynamicConfigIsExpiredBeforeFlowEndsWhenOperationFails() throws Exception {
        this.flowRunner("dynamicConfigIsExpiredBeforeFlowEndsWhenOperationFails").run();
        this.assertDisposedStatuses(Arrays.asList(0, 1));
    }

    @Test
    public void doNotExpireConfigUsedByPagedOperation() throws Exception {
        ((FlowRunner)this.flowRunner("dynamicWithShortExpirationForPagedOperation").withVariable("failOn", (Object)-1)).run();
        this.assertDisposedStatuses(Arrays.asList(0, 0, 0, 0, 1));
    }

    @Test
    public void doNotExpireConfigWhenPagedOperationWithReconnectionFailsOnFirstPage() throws Exception {
        ((FlowRunner)this.flowRunner("dynamicWithShortExpirationForPagedOperation").withVariable("failOn", (Object)1)).run();
        this.assertDisposedStatuses(Arrays.asList(0, 0, 0, 1));
    }

    @Test
    public void doNotExpireConfigWhenPagedOperationWithReconnectionFailsOnSecondPage() throws Exception {
        ((FlowRunner)this.flowRunner("dynamicWithShortExpirationForPagedOperation").withVariable("failOn", (Object)2)).run();
        this.assertDisposedStatuses(Arrays.asList(0, 0, 0, 1));
    }

    @Test
    public void expireConfigBeforeFlowEndsWhenPagedOperationWithoutReconnectionFailsOnFirstPage() throws Exception {
        ((FlowRunner)this.flowRunner("dynamicWithShortExpirationForPagedOperationWithoutReconnection").withVariable("failOn", (Object)1)).run();
        this.assertDisposedStatuses(Arrays.asList(0, 1));
    }

    @Test
    public void expireConfigBeforeFlowEndsWhenPagedOperationWithoutReconnectionFailsOnSecondPage() throws Exception {
        ((FlowRunner)this.flowRunner("dynamicWithShortExpirationForPagedOperationWithoutReconnection").withVariable("failOn", (Object)2)).run();
        this.assertDisposedStatuses(Arrays.asList(0, 0));
        this.assertConfigIsExpiredAfterFlowIsDisposed();
    }

    @Test
    public void expireConfigBeforeFlowEndsWhenUsedByStreamingOperation() throws Exception {
        this.flowRunner("dynamicWithShortExpirationForStreamingOperation").run();
        this.assertDisposedStatuses(Arrays.asList(0, 1, 1));
    }

    @Test
    public void doNotExpireConfigUsedByConnectedStreamingOperation() throws Exception {
        ((FlowRunner)this.flowRunner("dynamicWithShortExpirationForConnectedStreamingOperation").withVariable("failOn", (Object)-1)).run();
        this.assertDisposedStatuses(Arrays.asList(0, 0, 1));
    }

    @Test
    public void doNotExpireConfigWhenConnectedStreamingOperationWithReconnectionFailsObtainingTheStream() throws Exception {
        ((FlowRunner)this.flowRunner("dynamicWithShortExpirationForConnectedStreamingOperation").withVariable("failOn", (Object)0)).run();
        this.assertDisposedStatuses(Arrays.asList(0, 0, 1));
    }

    @Test
    public void doNotExpireConfigWhenConnectedStreamingOperationWithoutReconnectionFailsObtainingTheStream() throws Exception {
        ((FlowRunner)this.flowRunner("dynamicWithShortExpirationForConnectedStreamingOperationWithoutReconnection").withVariable("failOn", (Object)0)).run();
        this.assertDisposedStatuses(Arrays.asList(0, 1));
    }

    @Test
    public void doNotExpireConfigWhenConnectedStreamingOperationWithoutReconnectionFailsReadingTheStream() throws Exception {
        ((FlowRunner)this.flowRunner("dynamicWithShortExpirationForConnectedStreamingOperationWithoutReconnection").withVariable("failOn", (Object)1)).run();
        this.assertDisposedStatuses(Arrays.asList(0, 0, 0));
        this.assertConfigIsExpiredAfterFlowIsDisposed();
    }

    private void assertInitialised(HeisenbergExtension config) {
        Assert.assertThat((Object)config.getInitialise(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)config.getStart(), (Matcher)CoreMatchers.is((Object)1));
    }

    private void assertExpired(HeisenbergExtension config, long timeoutMilis, long pollDelayMillis) {
        PollingProber prober = new PollingProber(timeoutMilis, pollDelayMillis);
        prober.check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)config.getStop(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)config.getDispose(), (Matcher)CoreMatchers.is((Object)1));
            return true;
        }, "config was not stopped or disposed"));
    }

    private void assertDisposedStatuses(List<Integer> statuses) {
        Assert.assertThat(disposedStatuses, (Matcher)Matchers.contains((Object[])statuses.toArray()));
    }

    private void assertConfigIsExpiredAfterFlowIsDisposed() {
        PollingProber.check((long)20000L, (long)2500L, () -> {
            List<Integer> list = disposedStatuses;
            synchronized (list) {
                return config.getDispose() == 1;
            }
        });
    }

    private HeisenbergExtension invokeDynamicConfig(String flowName, String configName, String payload) throws Exception {
        FlowRunner runner = (FlowRunner)this.flowRunner(flowName).withPayload((Object)payload);
        CoreEvent event = runner.buildEvent();
        String returnedName = this.getPayloadAsString(runner.run().getMessage());
        HeisenbergExtension config = (HeisenbergExtension)muleContext.getExtensionManager().getConfiguration(configName, event).getValue();
        Assert.assertThat((Object)returnedName, (Matcher)CoreMatchers.is((Object)payload));
        Assert.assertThat((Object)config.getPersonalInfo().getName(), (Matcher)CoreMatchers.is((Object)payload));
        return config;
    }

    public static void resetCounters() {
        MoneyLaunderingOperation.closePagingProviderCalls = 0;
        MoneyLaunderingOperation.getPageCalls = 0;
        HeisenbergOperations.streamRead = -1;
    }

    public static class CaptureProcessor
    implements Processor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CoreEvent process(CoreEvent event) throws MuleException {
            List<Integer> list = disposedStatuses;
            synchronized (list) {
                if (config == null) {
                    config = (HeisenbergExtension)muleContext.getExtensionManager().getConfiguration("heisenbergWithShortExpiration", event).getValue();
                }
                disposedStatuses.add(config.getDispose());
            }
            return event;
        }
    }
}

