/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.parameter.value;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Java SDK")
@Story(value="Parameters definitions in Java SDK")
@Issue(value="MULE-19803")
@RunnerDelegateTo(value=Parameterized.class)
public class PojoCdataTextWhitespaceTrimmingTestCase
extends AbstractExtensionFunctionalTestCase {
    private final boolean disableWhitespaceTrimming;
    @Rule
    public SystemProperty disableWhitespaceTrimmingRule;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"disable whitespace trimming (expected behavior)", true}, {"enable whitespace trimming (previous behaviour)", false});
    }

    public PojoCdataTextWhitespaceTrimmingTestCase(String name, boolean disableWhitespaceTrimming) {
        this.disableWhitespaceTrimming = disableWhitespaceTrimming;
        this.disableWhitespaceTrimmingRule = new SystemProperty("mule.disable.pojo.text.parameter.whitespace.trimming", "" + disableWhitespaceTrimming);
    }

    protected String getConfigFile() {
        return "values/some-parameter-group-config.xml";
    }

    @Test
    @Issue(value="MULE-20048")
    public void whitespacesForPojoTextCDATA() throws Exception {
        Object value = this.flowRunner("pojoTextCDATA").run().getMessage().getPayload().getValue();
        if (this.disableWhitespaceTrimming) {
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello    Max Mule   !"));
        } else {
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello Max Mule!"));
        }
    }
}

