/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.data.sample;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.HashMap;
import java.util.Map;
import org.junit.Test;
import org.mule.test.data.sample.extension.ComplexActingParameter;
import org.mule.test.module.extension.data.sample.AbstractSampleDataTestCase;

@Feature(value="SDK Tooling Support")
@Story(value="Resolve through Tooling API")
public class OperationSampleDataThroughApiTestCase
extends AbstractSampleDataTestCase {
    protected String getConfigFile() {
        return "data/sample/operation-sample-data.xml";
    }

    @Test
    public void connectionLess() throws Exception {
        this.assertMessage(this.getSampleByComponentName("connectionLess", this.getDefaultParameters(), null), "my payload", "my attributes");
    }

    @Test
    public void useConnection() throws Exception {
        this.assertMessage(this.getSampleByComponentName("useConnection", this.getDefaultParameters(), "config"), "my payload", "my attributes");
    }

    @Test
    public void nonBlocking() throws Exception {
        this.assertMessage(this.getSampleByComponentName("nonBlocking", this.getDefaultParameters(), "config"), "my payload", "my attributes");
    }

    @Test
    public void useConfig() throws Exception {
        this.assertMessage(this.getSampleByComponentName("useConfig", this.getDefaultParameters(), "config"), "from-conf-my payload", "from-conf-my attributes");
    }

    @Test
    public void parameterGroup() throws Exception {
        this.assertMessage(this.getSampleByComponentName("parameterGroup", this.getGroupParameters(), "config"), "my payload", "my attributes");
    }

    @Test
    public void parameterGroupWithOptional() throws Exception {
        Map<String, Object> params = this.getGroupParameters();
        params.remove("optionalParameter");
        this.assertMessage(this.getSampleByComponentName("parameterGroup", params, "config"), "my payload", "<<null>>");
    }

    @Test
    public void showInDslParameterGroup() throws Exception {
        this.assertMessage(this.getSampleByComponentName("showInDslParameterGroup", this.getGroupParameters(), "config"), "my payload", "my attributes");
    }

    @Test
    public void aliasedGroup() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("aliasedPayload", "my payload");
        params.put("aliasedAttributes", "my attributes");
        this.assertMessage(this.getSampleByComponentName("aliasedGroup", params, "config"), "my payload", "my attributes");
    }

    @Test
    public void missingActingParameter() throws Exception {
        this.expectSampleDataException("MISSING_REQUIRED_PARAMETERS");
        this.expectedException.expectMessage("Unable to retrieve Sample Data. There are missing required parameters for the resolution: [attributes]");
        Map<String, Object> params = this.getDefaultParameters();
        params.remove("attributes");
        this.assertMessage(this.getSampleByComponentName("useConnection", params, "config"), "my payload", "my attributes");
    }

    @Test
    public void muleContextAwareSampleData() throws Exception {
        this.assertMessage(this.getSampleByComponentName("muleContextAwareSampleData", this.getDefaultParameters(), null), "my payload", "my attributes");
    }

    @Test
    public void complexActingParameter() throws Exception {
        ComplexActingParameter complexActingParameter = new ComplexActingParameter();
        complexActingParameter.setPayload("my payload");
        complexActingParameter.setAttributes("my attributes");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("complex", complexActingParameter);
        this.assertMessage(this.getSampleByComponentName("complexActingParameter", params, null), "my payload", "my attributes");
    }

    @Test
    public void connectionLessTwoWithBoundActingParameter() throws Exception {
        this.assertMessage(this.getSampleByComponentName("connectionLessWithTwoBoundActingParameter", this.getDefaultParameters(), null), "my payload", "my attributes");
    }

    @Test
    public void connectionLessWithTwoBoundActingParameterOneWithAnAlias() throws Exception {
        this.assertMessage(this.getSampleByComponentName("connectionLessWithTwoBoundActingParameterOneWithAnAlias", this.getDefaultParameters(), null), "my payload", "my attributes");
    }

    @Test
    public void connectionLessWithTwoBoundActingParameterFromContentField() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("message", "{ \"payload\": \"my payload\", \"attributes\": \"my attributes\" }");
        this.assertMessage(this.getSampleByComponentName("connectionLessWithTwoBoundActingParameterFromContentField", params, null), "my payload", "my attributes");
    }

    @Test
    public void connectionLessWithTwoBoundActingParameterFromXMLContentTag() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("message", "<nested>\n  <payloadXmlTag>my payload</payloadXmlTag>\n  <attributesXmlTag>my attributes</attributesXmlTag>\n</nested>");
        this.assertMessage(this.getSampleByComponentName("connectionLessWithTwoBoundActingParameterFromXMLContentTag", params, null), "my payload", "my attributes");
    }

    @Test
    public void connectionLessWithTwoBoundActingParameterFromXMLContentTagAttribute() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("message", "<nested>\n  <xmlTag payloadXmlAttribute=\"my payload\" attributesXmlAttribute=\"my attributes\">This is content</xmlTag>\n</nested>");
        this.assertMessage(this.getSampleByComponentName("connectionLessWithTwoBoundActingParameterFromXMLContentTagAttribute", params, null), "my payload", "my attributes");
    }

    @Test
    public void useConnectionWithTwoBoundActingParameter() throws Exception {
        this.assertMessage(this.getSampleByComponentName("useConnectionWithTwoBoundActingParameter", this.getDefaultParameters(), "config"), "my payload", "my attributes");
    }

    @Test
    public void missingBoundActingParameter() throws Exception {
        this.expectSampleDataException("MISSING_REQUIRED_PARAMETERS");
        this.expectedException.expectMessage("Unable to retrieve Sample Data. There are missing required parameters for the resolution: [attributes]");
        Map<String, Object> params = this.getDefaultParameters();
        params.remove("attributes");
        this.assertMessage(this.getSampleByComponentName("useConnectionWithTwoBoundActingParameter", params, "config"), "my payload", "my attributes");
    }

    @Test
    public void missingBoundActingParameterFromContentField() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("message", "{ \"payload\" : \"my payload\" }");
        this.expectSampleDataException("MISSING_REQUIRED_PARAMETERS");
        this.expectedException.expectMessage("Unable to retrieve Sample Data. There are missing required parameters for the resolution: [attributes]");
        this.assertMessage(this.getSampleByComponentName("connectionLessWithTwoBoundActingParameterFromContentField", params, "config"), "my payload", "my attributes");
    }

    @Test
    public void complexBoundActingParameter() throws Exception {
        ComplexActingParameter complexActingParameter = new ComplexActingParameter();
        complexActingParameter.setPayload("my payload");
        complexActingParameter.setAttributes("my attributes");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("complex", complexActingParameter);
        this.assertMessage(this.getSampleByComponentName("complexBoundActingParameter", params, null), "my payload", "my attributes");
    }

    @Test
    public void pojoBoundActingParameter() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("actingParameter", "{ \"pojoFields\" : {\n \"payload\" : \"my payload\" , \"attributes\" : \"my attributes\" } }");
        this.assertMessage(this.getSampleByComponentName("pojoBoundActingParameter", params, "config"), "my payload", "my attributes");
    }

    @Test
    public void boundActingParameterFromPojoField() throws Exception {
        ComplexActingParameter complexActingParameter = new ComplexActingParameter();
        complexActingParameter.setPayload("my payload");
        complexActingParameter.setAttributes("my attributes");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("complex", complexActingParameter);
        this.assertMessage(this.getSampleByComponentName("boundActingParameterFromPojoField", params, "config"), "my payload", "my attributes");
    }
}

