/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.message.NullAttributes;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ExecutionType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.HasExternalLibraries;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.StreamingStrategyTypeBuilder;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.marvel.MarvelExtension;
import org.mule.test.vegan.extension.PaulMcCartneySource;
import org.mule.test.vegan.extension.VeganExtension;

@SmallTest
public class DefaultExtensionModelFactoryTestCase
extends AbstractMuleTestCase {
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    private ExtensionModel createExtension(Class<?> annotatedClass) {
        return MuleExtensionUtils.loadExtension(annotatedClass);
    }

    @Test
    public void flyweight() {
        ExtensionModel extensionModel = this.createExtension(VeganExtension.class);
        ConfigurationModel appleConfiguration = (ConfigurationModel)this.aggressiveGet(extensionModel.getConfigurationModel("apple-config"));
        ConfigurationModel bananaConfiguration = (ConfigurationModel)this.aggressiveGet(extensionModel.getConfigurationModel("banana-config"));
        String sourceName = PaulMcCartneySource.class.getSimpleName();
        SourceModel appleSource = (SourceModel)this.aggressiveGet(appleConfiguration.getSourceModel(sourceName));
        SourceModel bananaSource = (SourceModel)this.aggressiveGet(bananaConfiguration.getSourceModel(sourceName));
        Assert.assertThat((Object)appleSource, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)appleSource)));
        Assert.assertThat((Object)bananaSource, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)bananaSource)));
        String operationName = "spreadTheWord";
        OperationModel appleOperation = (OperationModel)this.aggressiveGet(appleConfiguration.getOperationModel("spreadTheWord"));
        OperationModel bananaOperation = (OperationModel)this.aggressiveGet(bananaConfiguration.getOperationModel("spreadTheWord"));
        Assert.assertThat((Object)appleOperation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)bananaOperation)));
    }

    @Test
    public void blockingExecutionTypes() {
        ExtensionModel extensionModel = this.createExtension(HeisenbergExtension.class);
        final Reference cpuIntensive = new Reference((Object)false);
        final Reference blocking = new Reference((Object)false);
        new IdempotentExtensionWalker(){

            protected void onOperation(OperationModel operation) {
                Assert.assertThat((Object)operation.isBlocking(), (Matcher)CoreMatchers.is((Object)true));
                String operationName = operation.getName();
                if (operationName.equals("approve")) {
                    Assert.assertThat((Object)operation.getExecutionType(), (Matcher)CoreMatchers.is((Object)ExecutionType.CPU_INTENSIVE));
                    cpuIntensive.set((Object)true);
                } else if (operation.requiresConnection()) {
                    Assert.assertThat((Object)operation.getExecutionType(), (Matcher)CoreMatchers.is((Object)ExecutionType.BLOCKING));
                    blocking.set((Object)true);
                } else {
                    Assert.assertThat((Object)operation.getExecutionType(), (Matcher)CoreMatchers.is((Object)ExecutionType.CPU_LITE));
                }
            }
        }.walk(extensionModel);
        Assert.assertThat((Object)cpuIntensive.get(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)blocking.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void nonBlockingExecutionType() {
        ExtensionModel extensionModel = this.createExtension(MarvelExtension.class);
        OperationModel operation = (OperationModel)((ConfigurationModel)extensionModel.getConfigurationModel("iron-man").get()).getOperationModel("fireMissile").get();
        Assert.assertThat((Object)operation.isBlocking(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)operation.getExecutionType(), (Matcher)CoreMatchers.is((Object)ExecutionType.CPU_LITE));
        Assert.assertThat((Object)operation.getOutput().getType(), (Matcher)CoreMatchers.equalTo((Object)this.typeLoader.load(String.class)));
        Assert.assertThat((Object)operation.getOutputAttributes().getType(), (Matcher)CoreMatchers.equalTo((Object)this.typeLoader.load(NullAttributes.class)));
    }

    @Test
    public void contentParameter() {
        this.assertSinglePrimaryContentParameter(this.createExtension(VeganExtension.class), "getAllApples", "#[payload]");
    }

    @Test
    public void contentParameterWithCustomDefault() {
        this.assertSinglePrimaryContentParameter(this.createExtension(VeganExtension.class), "tryToEatThisListOfMaps", null);
    }

    @Test
    public void exportedLibraries() {
        ExtensionModel extensionModel = this.createExtension(HeisenbergExtension.class);
        this.assertExternalLibraries((HasExternalLibraries)extensionModel);
        new IdempotentExtensionWalker(){

            protected void onConfiguration(ConfigurationModel model) {
                DefaultExtensionModelFactoryTestCase.this.assertExternalLibraries((HasExternalLibraries)model);
            }

            protected void onConnectionProvider(ConnectionProviderModel model) {
                DefaultExtensionModelFactoryTestCase.this.assertExternalLibraries((HasExternalLibraries)model);
            }
        }.walk(extensionModel);
    }

    @Test
    public void streamingHintOnOperation() throws Exception {
        ExtensionModel extensionModel = this.createExtension(HeisenbergExtension.class);
        OperationModel operationModel = (OperationModel)((ConfigurationModel)extensionModel.getConfigurationModels().get(0)).getOperationModel("sayMyName").get();
        ParameterModel streamingParameter = operationModel.getAllParameterModels().stream().filter(p -> p.getName().equals("streamingStrategy")).findFirst().get();
        this.assertStreamingStrategy(streamingParameter);
    }

    @Test
    public void streamingHintOnSource() throws Exception {
        ExtensionModel extensionModel = this.createExtension(HeisenbergExtension.class);
        SourceModel sourceModel = (SourceModel)((ConfigurationModel)extensionModel.getConfigurationModels().get(0)).getSourceModel("ListenPayments").get();
        ParameterModel streamingParameter = sourceModel.getAllParameterModels().stream().filter(p -> p.getName().equals("streamingStrategy")).findFirst().get();
        this.assertStreamingStrategy(streamingParameter);
    }

    private void assertStreamingStrategy(ParameterModel streamingParameter) {
        Assert.assertThat((Object)streamingParameter.getType(), (Matcher)CoreMatchers.equalTo((Object)new StreamingStrategyTypeBuilder().getByteStreamingStrategyType()));
        Assert.assertThat((Object)streamingParameter.isRequired(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)streamingParameter.getDefaultValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)streamingParameter.getExpressionSupport(), (Matcher)CoreMatchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
    }

    private void assertExternalLibraries(HasExternalLibraries model) {
        Assert.assertThat((Object)model.getExternalLibraryModels(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)model.getExternalLibraryModels(), (Matcher)Matchers.hasSize((int)1));
        ExternalLibraryModel library = (ExternalLibraryModel)model.getExternalLibraryModels().iterator().next();
        Assert.assertThat((Object)library.getName(), (Matcher)CoreMatchers.is((Object)"Heisenberg.so"));
        Assert.assertThat((Object)library.getDescription(), (Matcher)CoreMatchers.is((Object)"Native Heisenberg support"));
        Assert.assertThat(library.getFileName().get(), (Matcher)CoreMatchers.is((Object)"heisenberg.so"));
        Assert.assertThat(library.getRequiredClassName().get(), (Matcher)CoreMatchers.is((Object)"org.heisenberg.HeisenbergJNI"));
    }

    private void assertSinglePrimaryContentParameter(ExtensionModel extensionModel, String operationName, String defaultValue) {
        OperationModel appleOperation = (OperationModel)this.aggressiveGet(extensionModel.getOperationModel(operationName));
        List contentParameters = appleOperation.getAllParameterModels().stream().filter(ExtensionModelUtils::isContent).collect(Collectors.toList());
        Assert.assertThat(contentParameters, (Matcher)Matchers.hasSize((int)1));
        ParameterModel contentParameter = (ParameterModel)contentParameters.get(0);
        Assert.assertThat((Object)contentParameter.isRequired(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)contentParameter.getDefaultValue(), (Matcher)CoreMatchers.is((Object)defaultValue));
        Assert.assertThat((Object)contentParameter.getRole(), (Matcher)CoreMatchers.is((Object)ParameterRole.PRIMARY_CONTENT));
    }

    private <T> T aggressiveGet(Optional<T> optional) {
        return optional.orElseThrow(NoSuchElementException::new);
    }
}

