/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.core.config.MuleManifest;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.DisplayDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.test.heisenberg.extension.HeisenbergExtension;

public class DisplayDeclarationEnricherTestCase
extends AbstractMuleTestCase {
    private static final String PARAMETER_GROUP_DISPLAY_NAME = "Date of decease";
    private static final String PARAMETER_GROUP_ORIGINAL_DISPLAY_NAME = "dateOfDeath";
    private ExtensionDeclarer declarer;

    @Before
    public void setUp() {
        DefaultJavaModelLoaderDelegate loader = new DefaultJavaModelLoaderDelegate(HeisenbergExtension.class, MuleManifest.getProductVersion());
        this.declarer = loader.declare((ExtensionLoadingContext)new DefaultExtensionLoadingContext(((Object)((Object)this)).getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet())));
        new DisplayDeclarationEnricher().enrich((ExtensionLoadingContext)new DefaultExtensionLoadingContext(this.declarer, ((Object)((Object)this)).getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet())));
    }

    @Test
    public void parseDisplayAnnotationsOnParameter() {
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)this.declarer.getDeclaration();
        List parameters = ((ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(0)).getAllParameters();
        this.assertParameterDisplayName(this.findParameter(parameters, "weaponValueMap"), "Parameter Custom Display Name");
    }

    @Test
    public void parseDisplayNameAnnotationOnParameterGroup() {
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)this.declarer.getDeclaration();
        List parameters = ((ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(0)).getAllParameters();
        this.assertParameterDisplayName(this.findParameter(parameters, PARAMETER_GROUP_ORIGINAL_DISPLAY_NAME), PARAMETER_GROUP_DISPLAY_NAME);
    }

    @Test
    public void parseDisplayNameAnnotationOnOperationParameter() {
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)this.declarer.getDeclaration();
        OperationDeclaration operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, "resolverEcho");
        MatcherAssert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        List parameters = operation.getAllParameters();
        this.assertParameterDisplayName(this.findParameter(parameters, "literalExpression"), "Custom overrided display name");
    }

    @Test
    public void parseSummaryAnnotationOnConfigParameter() {
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)this.declarer.getDeclaration();
        List parameters = ((ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(0)).getAllParameters();
        this.assertParameterSummary(this.findParameter(parameters, "ricinPacks"), "A set of ricin packs");
    }

    @Test
    public void parseSummaryAnnotationOnOperationParameter() {
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)this.declarer.getDeclaration();
        OperationDeclaration operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, "knockMany");
        MatcherAssert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        List parameters = operation.getAllParameters();
        this.assertParameterSummary(this.findParameter(parameters, "doors"), "List of Knockeable Doors");
    }

    @Test
    public void parseExampleAnnotationOnConfigParameter() {
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)this.declarer.getDeclaration();
        List parameters = ((ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(0)).getAllParameters();
        this.assertParameterExample(this.findParameter(parameters, "labAddress"), "308 Negra Arroyo Lane, Albuquerque, New Mexico, 87104");
    }

    @Test
    public void parseExampleAnnotationOnOperationParameter() {
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)this.declarer.getDeclaration();
        OperationDeclaration operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, "alias");
        MatcherAssert.assertThat((Object)operation, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        List parameters = operation.getAllParameters();
        this.assertParameterExample(this.findParameter(parameters, "greeting"), "Hello my friend!");
    }

    private void assertParameterDisplayName(ParameterDeclaration param, String displayName) {
        DisplayModel display = param.getDisplayModel();
        MatcherAssert.assertThat((Object)display.getDisplayName(), (Matcher)CoreMatchers.is((Object)displayName));
    }

    private void assertParameterSummary(ParameterDeclaration param, String summary) {
        DisplayModel display = param.getDisplayModel();
        MatcherAssert.assertThat((Object)display.getSummary(), (Matcher)CoreMatchers.is((Object)summary));
    }

    private void assertParameterExample(ParameterDeclaration param, String example) {
        DisplayModel display = param.getDisplayModel();
        MatcherAssert.assertThat((Object)display.getExample(), (Matcher)CoreMatchers.is((Object)example));
    }

    private OperationDeclaration getOperation(WithOperationsDeclaration declaration, String operationName) {
        return (OperationDeclaration)CollectionUtils.find((Collection)declaration.getOperations(), object -> ((OperationDeclaration)object).getName().equals(operationName));
    }

    private ParameterDeclaration findParameter(List<ParameterDeclaration> parameters, String name) {
        return (ParameterDeclaration)CollectionUtils.find(parameters, object -> name.equals(((ParameterDeclaration)object).getName()));
    }
}

