/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ExecutionType;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.extension.api.annotation.DataTypeParameters;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.enricher.ExecutionTypeDeclarationEnricher;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ExecutionTypeDeclarationEnricherTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionLoadingContext extensionLoadingContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclarer extensionDeclarer;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionDeclaration extensionDeclaration;
    private OperationDeclaration operation = new OperationDeclaration("operation");
    private ExecutionTypeDeclarationEnricher enricher = new ExecutionTypeDeclarationEnricher();

    @Before
    @DataTypeParameters
    public void before() {
        Mockito.when((Object)this.extensionLoadingContext.getExtensionDeclarer()).thenReturn((Object)this.extensionDeclarer);
        Mockito.when((Object)this.extensionDeclarer.getDeclaration()).thenReturn((Object)this.extensionDeclaration);
        Mockito.when((Object)this.extensionDeclaration.getOperations()).thenReturn(Arrays.asList(this.operation));
    }

    @Test
    public void operationSpecifiesExecutionType() {
        this.operation.setExecutionType(ExecutionType.CPU_INTENSIVE);
        this.enrichAndExpect(ExecutionType.CPU_INTENSIVE);
    }

    @Test
    public void blockingConnectedOperation() {
        this.operation.setBlocking(true);
        this.operation.setRequiresConnection(true);
        this.enrichAndExpect(ExecutionType.BLOCKING);
    }

    @Test
    public void nonBlockingConnectedOperation() {
        this.operation.setBlocking(false);
        this.operation.setRequiresConnection(true);
        this.enrichAndExpect(ExecutionType.CPU_LITE);
    }

    @Test
    public void nonConnectedOperation() {
        this.operation.setBlocking(true);
        this.operation.setRequiresConnection(false);
        this.enrichAndExpect(ExecutionType.CPU_LITE);
    }

    private void enrichAndExpect(ExecutionType type) {
        this.enricher.enrich(this.extensionLoadingContext);
        Assert.assertThat((Object)this.operation.getExecutionType(), (Matcher)CoreMatchers.is((Object)type));
    }
}

