/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.extension.api.annotation.Extensible;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.ExtensionOf;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.java.AbstractJavaExtensionDeclarationTestCase;
import org.mule.runtime.module.extension.internal.loader.java.property.ExtendingOperationModelProperty;

public class ExtensibleExtensionOperationsTestCase
extends AbstractJavaExtensionDeclarationTestCase {
    private static final String SAY_HELLO_OPERATION = "sayHello";
    private static final String SAY_BYE_OPERATION = "sayBye";

    @Test
    public void operationIsExtensionOfSameExtension() throws Exception {
        this.setLoader(this.loaderFor(ExtensibleExtension.class));
        this.assertOperationExtensionOf(SAY_HELLO_OPERATION, ExtensibleExtension.class);
    }

    @Test
    public void operationIsExtensionOfDifferentExtension() {
        this.setLoader(this.loaderFor(ExtendingExtension.class));
        this.assertOperationExtensionOf(SAY_HELLO_OPERATION, ExtensibleExtension.class);
        this.assertOperationExtensionOf(SAY_BYE_OPERATION, ExtensibleExtension.class);
    }

    @Test
    public void operationIsExtensionOfSameAndDifferentExtension() {
        this.setLoader(this.loaderFor(ExtensibleExtendingExtension.class));
        this.assertOperationExtensionOf(SAY_HELLO_OPERATION, ExtensibleExtendingExtension.class);
        this.assertOperationExtensionOf(SAY_BYE_OPERATION, ExtensibleExtension.class);
    }

    private void assertOperationExtensionOf(String operationName, Class propertyType) {
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)this.getLoader().declare((ExtensionLoadingContext)new DefaultExtensionLoadingContext(((Object)((Object)this)).getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet()))).getDeclaration();
        OperationDeclaration operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, operationName);
        ExtendingOperationModelProperty modelProperty = (ExtendingOperationModelProperty)operation.getModelProperty(ExtendingOperationModelProperty.class).get();
        Assert.assertThat((Object)modelProperty.getType(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)propertyType)));
    }

    private static class ExtensibleExtensionOperation {
        private ExtensibleExtensionOperation() {
        }

        public String sayHello() {
            return "Hello!";
        }
    }

    private static class MethodLevelExtensionOfOperation {
        private MethodLevelExtensionOfOperation() {
        }

        @ExtensionOf(value=ExtensibleExtension.class)
        public String sayBye() {
            return "Bye!";
        }
    }

    @ExtensionOf(value=ExtensibleExtension.class)
    private static class ClassLevelExtensionOfOperation {
        private ClassLevelExtensionOfOperation() {
        }

        public String sayHello() {
            return "Hello!";
        }
    }

    @Extension(name="Heisenberg", description="My Test Extension just to unit test")
    @Operations(value={MethodLevelExtensionOfOperation.class, ExtensibleExtensionOperation.class})
    @Extensible
    public static class ExtensibleExtendingExtension {
    }

    @Extension(name="Heisenberg", description="My Test Extension just to unit test")
    @Operations(value={ClassLevelExtensionOfOperation.class, MethodLevelExtensionOfOperation.class})
    public static class ExtendingExtension {
    }

    @Extension(name="Heisenberg", description="My Test Extension just to unit test")
    @Operations(value={ExtensibleExtensionOperation.class})
    @Extensible
    public static class ExtensibleExtension {
    }
}

