/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.util.Optional;
import javafx.util.Pair;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.module.extension.internal.loader.java.AbstractJavaExtensionDeclarationTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.HeisenbergExtension;

@SmallTest
public class LayoutModelTestCase
extends AbstractJavaExtensionDeclarationTestCase {
    private static final String KILL_CUSTOM_OPERATION = "killWithCustomMessage";

    @Before
    public void setUp() {
        this.setLoader(this.loaderFor(HeisenbergExtension.class));
    }

    @Test
    public void parseLayoutAnnotationsOnParameter() {
        ExtensionDeclarer declarer = this.declareExtension();
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)declarer.getDeclaration();
        ConfigurationDeclaration configurationDeclaration = (ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(0);
        this.assertParameterPlacement(this.findParameterInGroup((ParameterizedDeclaration<?>)configurationDeclaration, "labeledRicin"), "Dangerous-Ricin", 1);
        this.assertParameterPlacement(this.findParameterInGroup((ParameterizedDeclaration<?>)configurationDeclaration, "ricinPacks"), "Dangerous-Ricin", 2);
    }

    @Test
    public void parseLayoutAnnotationsOnParameterGroup() {
        ExtensionDeclarer declarer = this.declareExtension();
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)declarer.getDeclaration();
        ConfigurationDeclaration config = (ConfigurationDeclaration)extensionDeclaration.getConfigurations().get(0);
        this.assertParameterPlacement(this.findParameterInGroup((ParameterizedDeclaration<?>)config, "myName"), "Personal Information", 1);
        this.assertParameterPlacement(this.findParameterInGroup((ParameterizedDeclaration<?>)config, "age"), "Personal Information", 2);
        this.assertParameterPlacement(this.findParameterInGroup((ParameterizedDeclaration<?>)config, "dateOfConception"), "Personal Information", 3);
        this.assertParameterPlacement(this.findParameterInGroup((ParameterizedDeclaration<?>)config, "dateOfBirth"), "Personal Information", 4);
        this.assertParameterPlacement(this.findParameterInGroup((ParameterizedDeclaration<?>)config, "dateOfDeath"), "Personal Information", 5);
    }

    @Test
    public void parseLayoutAnnotationsOnOperationParameter() {
        ExtensionDeclarer declarer = this.declareExtension();
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)declarer.getDeclaration();
        OperationDeclaration operation = this.getOperation((WithOperationsDeclaration)extensionDeclaration, KILL_CUSTOM_OPERATION);
        MatcherAssert.assertThat((Object)operation, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.assertParameterPlacement(this.findParameterInGroup((ParameterizedDeclaration<?>)operation, "victim"), "KillGroup", 1);
        this.assertParameterPlacement(this.findParameterInGroup((ParameterizedDeclaration<?>)operation, "goodbyeMessage"), "KillGroup", 2);
    }

    private void assertParameterPlacement(Pair<ParameterGroupDeclaration, ParameterDeclaration> pair, String groupName, Integer order) {
        ParameterGroupDeclaration group = (ParameterGroupDeclaration)pair.getKey();
        MatcherAssert.assertThat((Object)group.getName(), (Matcher)CoreMatchers.equalTo((Object)groupName));
        this.assertParameterPlacement((ParameterDeclaration)pair.getValue(), order);
    }

    private void assertParameterPlacement(ParameterDeclaration param, Integer order) {
        LayoutModel layout = param.getLayoutModel();
        MatcherAssert.assertThat((Object)layout, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)layout.getOrder(), (Matcher)CoreMatchers.equalTo(Optional.ofNullable(order)));
    }
}

