/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.extension.api.annotation.dsl.xml.XmlHints;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.model.source.ImmutableSourceModel;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.internal.loader.validator.NameClashModelValidator;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ConfigTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectivityModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class NameClashModelValidatorTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private static final String OPERATION_NAME = "operation";
    private static final String TOP_LEVEL_OPERATION_PARAM_NAME = "topLevelOperationParam";
    private static final String CONFIG_NAME = "config";
    private static final String CONFIG_SUFFIX = "Config";
    private static final String SOURCE_NAME = "source";
    private static final String CONNECTION_PROVIDER_NAME = "connectionProviderConnection";
    private static final String CONNECTION_PROVIDER_SUFFIX = "Connection";
    private static final String SIMPLE_PARAM_NAME = "simple";
    private static final String TOP_LEVEL_PLURAL_PARAM_NAME = "topLevelTests";
    private static final String TOP_LEVEL_SINGULAR_PARAM_NAME = "topLevelTest";
    private static final String CHILD_PLURAL_PARAM_NAME = "childTests";
    private static final String CHILD_SINGULAR_PARAM_NAME = "childTest";
    @Mock
    private ExtensionModel extensionModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ConfigurationModel configurationModel;
    @Mock
    private OperationModel operationModel;
    @Mock
    private ConnectionProviderModel connectionProviderModel;
    @Mock
    private SourceModel sourceModel;
    private XmlDslModel xmlDslModel = new XmlDslModel();
    private ParameterModel simpleConfigParam;
    private ParameterModel topLevelConfigParam;
    private ParameterModel simpleOperationParam;
    private ParameterModel topLevelOperationParam;
    private ParameterModel simpleConnectionProviderParam;
    private ParameterModel topLevelConnectionProviderParam;
    private BaseTypeBuilder baseTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
    private MetadataType childTestList = this.baseTypeBuilder.arrayType().id(ArrayList.class.getName()).of(ExtensionsTestUtils.toMetadataType(ChildTest.class)).build();
    private MetadataType topLevelTestList = this.baseTypeBuilder.arrayType().id(ArrayList.class.getName()).of(ExtensionsTestUtils.toMetadataType(TopLevelTest.class)).build();
    private MetadataType childTestMap = this.baseTypeBuilder.objectType().id(HashMap.class.getName()).openWith(ExtensionsTestUtils.toMetadataType(ChildTest.class)).with((TypeAnnotation)new ClassInformationAnnotation(HashMap.class, Arrays.asList(String.class, ChildTest.class))).build();
    private MetadataType topLevelMap = this.baseTypeBuilder.objectType().id(HashMap.class.getName()).openWith(ExtensionsTestUtils.toMetadataType(TopLevelTest.class)).with((TypeAnnotation)new ClassInformationAnnotation(HashMap.class, Arrays.asList(String.class, TopLevelTest.class))).build();
    private NameClashModelValidator validator = new NameClashModelValidator();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)"extensionName");
        Mockito.when((Object)this.extensionModel.getConfigurationModels()).thenReturn(Collections.singletonList(this.configurationModel));
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Collections.singletonList(this.operationModel));
        Mockito.when((Object)this.extensionModel.getConnectionProviders()).thenReturn(Collections.singletonList(this.connectionProviderModel));
        Mockito.when((Object)this.extensionModel.getSourceModels()).thenReturn(Collections.singletonList(this.sourceModel));
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)this.xmlDslModel);
        this.simpleConfigParam = ExtensionsTestUtils.getParameter(SIMPLE_PARAM_NAME, String.class);
        this.topLevelConfigParam = ExtensionsTestUtils.getParameter(TOP_LEVEL_OPERATION_PARAM_NAME, TopLevelTest.class);
        this.simpleOperationParam = ExtensionsTestUtils.getParameter(SIMPLE_PARAM_NAME, String.class);
        this.topLevelOperationParam = ExtensionsTestUtils.getParameter(TOP_LEVEL_OPERATION_PARAM_NAME, TopLevelTest.class);
        this.simpleConnectionProviderParam = ExtensionsTestUtils.getParameter(SIMPLE_PARAM_NAME, String.class);
        this.topLevelConnectionProviderParam = ExtensionsTestUtils.getParameter(TOP_LEVEL_OPERATION_PARAM_NAME, TopLevelTest.class);
        Mockito.when((Object)this.configurationModel.getName()).thenReturn((Object)CONFIG_NAME);
        Mockito.when((Object)this.configurationModel.getAllParameterModels()).thenReturn(Arrays.asList(this.simpleConfigParam, this.topLevelConfigParam));
        Mockito.when((Object)this.configurationModel.getOperationModels()).thenReturn((Object)ImmutableList.of());
        Mockito.when((Object)this.configurationModel.getConnectionProviders()).thenReturn((Object)ImmutableList.of());
        Mockito.when((Object)this.configurationModel.getParameterGroupModels()).thenReturn((Object)ImmutableList.of());
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)OPERATION_NAME);
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(this.simpleOperationParam, this.topLevelOperationParam));
        this.mockModelProperties((EnrichableModel)this.operationModel);
        this.mockModelProperties((EnrichableModel)this.configurationModel);
        this.mockModelProperties((EnrichableModel)this.connectionProviderModel);
        Mockito.when((Object)this.connectionProviderModel.getName()).thenReturn((Object)CONNECTION_PROVIDER_NAME);
        Mockito.when((Object)this.connectionProviderModel.getAllParameterModels()).thenReturn(Arrays.asList(this.simpleConnectionProviderParam, this.topLevelConnectionProviderParam));
        Mockito.when((Object)this.sourceModel.getName()).thenReturn((Object)SOURCE_NAME);
        Mockito.when((Object)this.sourceModel.getModelProperty((Class)Matchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceModel.getErrorCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceModel.getSuccessCallback()).thenReturn(Optional.empty());
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operationModel});
    }

    private void mockModelProperties(EnrichableModel model) {
        Mockito.when((Object)model.getModelProperty(ConfigTypeModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)model.getModelProperty(ConnectivityModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)model.getModelProperty(PagedOperationModelProperty.class)).thenReturn(Optional.empty());
    }

    @Test
    public void validModel() {
        this.validate();
    }

    @Test
    public void operationClashingWithConfig() {
        String clashingName = "operationConfig";
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)clashingName);
        this.exception.expect(IllegalModelDefinitionException.class);
        Mockito.when((Object)this.configurationModel.getName()).thenReturn((Object)clashingName);
        this.validate();
    }

    @Test
    public void configParameterWithRepeatedName() {
        this.exception.expect(IllegalModelDefinitionException.class);
        ParameterModel offending = ExtensionsTestUtils.getParameter(TOP_LEVEL_OPERATION_PARAM_NAME, Banana.class);
        Mockito.when((Object)this.configurationModel.getAllParameterModels()).thenReturn(Arrays.asList(this.simpleConfigParam, this.topLevelConfigParam, offending));
        this.validate();
    }

    @Test
    public void configNameClashesWithOperationParameterType() {
        this.exception.expect(IllegalModelDefinitionException.class);
        ParameterModel offending = ExtensionsTestUtils.getParameter(SIMPLE_PARAM_NAME, TopLevelConfig.class);
        Mockito.when((Object)this.configurationModel.getName()).thenReturn((Object)TopLevelConfig.class.getName());
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.topLevelConfigParam, offending);
        this.validate();
    }

    @Test
    public void connectionProviderTopLevelParameterCrashesWithOperationName() {
        this.exception.expect(IllegalModelDefinitionException.class);
        this.exception.expectMessage("contains 2 components 'operation' which it's transformed DSL name is 'operation'.");
        ParameterModel offending = ExtensionsTestUtils.getParameter(OPERATION_NAME, TopLevelTest.class);
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.connectionProviderModel, this.simpleConnectionProviderParam, this.topLevelConnectionProviderParam, offending);
        this.validate();
    }

    @Test
    public void connectionProviderNameClashesWithOperationParameterName() {
        String clashingName = "simpleConnection";
        this.exception.expect(IllegalModelDefinitionException.class);
        this.exception.expectMessage(String.format("Extension '%s' has a connection provider named '%s' and an operation named operation with an argument type named equally.", this.extensionModel.getName(), NameUtils.hyphenize((String)clashingName)));
        ParameterModel offending = ExtensionsTestUtils.getParameter(clashingName, ChildTest.class);
        Mockito.when((Object)this.connectionProviderModel.getName()).thenReturn((Object)clashingName);
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(this.topLevelOperationParam, offending));
        this.validate();
    }

    @Test
    public void connectionProviderNameClashesWithOperationParameterType() {
        this.exception.expect(IllegalModelDefinitionException.class);
        String clashingName = "simpleConnection";
        Mockito.when((Object)this.connectionProviderModel.getName()).thenReturn((Object)clashingName);
        ParameterModel offending = ExtensionsTestUtils.getParameter(clashingName, TopLevelTest.class);
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(this.topLevelOperationParam, offending));
        this.validate();
    }

    @Test
    public void connectionProviderNameWithOperationParameterNoChild() {
        Mockito.when((Object)this.connectionProviderModel.getName()).thenReturn((Object)SIMPLE_PARAM_NAME);
        ParameterModel offending = ExtensionsTestUtils.getParameter(this.connectionProviderModel.getName(), NoChildTest.class);
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(this.topLevelOperationParam, offending));
        this.validate();
    }

    @Test
    public void configTopLevelParameterCrashesWithConfigName() {
        this.exception.expect(IllegalModelDefinitionException.class);
        Mockito.when((Object)this.configurationModel.getName()).thenReturn((Object)CONFIG_NAME);
        ParameterModel offending = ExtensionsTestUtils.getParameter(CONFIG_NAME, TopLevelTest.class);
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.configurationModel, this.simpleConfigParam, this.topLevelConfigParam, offending);
        this.validate();
    }

    @Test
    public void connectionProviderTopLevelParameterCrashesWithConfigName() {
        this.exception.expect(IllegalModelDefinitionException.class);
        ParameterModel offending = ExtensionsTestUtils.getParameter(CONFIG_NAME, TopLevelTest.class);
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.connectionProviderModel, this.simpleConnectionProviderParam, this.topLevelConnectionProviderParam, offending);
        this.validate();
    }

    @Test
    public void operationTopLevelParameterCrashesWithOperationName() {
        this.exception.expect(IllegalModelDefinitionException.class);
        ParameterModel offending = ExtensionsTestUtils.getParameter(OPERATION_NAME, TopLevelTest.class);
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(this.simpleOperationParam, this.topLevelOperationParam, offending));
        this.validate();
    }

    @Test
    public void connectionProviderTopLevelParameterCrashesWithName() {
        this.exception.expect(IllegalModelDefinitionException.class);
        ParameterModel offending = ExtensionsTestUtils.getParameter(CONNECTION_PROVIDER_NAME, TopLevelTest.class);
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.connectionProviderModel, this.simpleConnectionProviderParam, this.topLevelConnectionProviderParam, offending);
        this.validate();
    }

    @Test
    public void configWithRepeatedParameterName() {
        this.exception.expect(IllegalModelDefinitionException.class);
        ParameterModel offending = ExtensionsTestUtils.getParameter(SIMPLE_PARAM_NAME, String.class);
        Mockito.when((Object)this.configurationModel.getAllParameterModels()).thenReturn(Arrays.asList(this.simpleConfigParam, this.topLevelConfigParam, offending));
        this.validate();
    }

    @Test
    public void operationWithRepeatedParameterName() {
        this.exception.expect(IllegalModelDefinitionException.class);
        ParameterModel offending = ExtensionsTestUtils.getParameter(SIMPLE_PARAM_NAME, String.class);
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(this.simpleOperationParam, this.topLevelOperationParam, offending));
        this.validate();
    }

    @Test
    public void operationNameClashesWithParameterTypeName() {
        this.exception.expect(IllegalModelDefinitionException.class);
        ParameterModel offending = ExtensionsTestUtils.getParameter(TOP_LEVEL_SINGULAR_PARAM_NAME, TopLevelTest.class);
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)TopLevelTest.class.getName());
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.topLevelOperationParam, offending);
        this.validate();
    }

    @Test
    public void connectionProviderWithRepeatedParameterName() {
        this.exception.expect(IllegalModelDefinitionException.class);
        ParameterModel offending = ExtensionsTestUtils.getParameter(SIMPLE_PARAM_NAME, String.class);
        Mockito.when((Object)this.connectionProviderModel.getAllParameterModels()).thenReturn(Arrays.asList(this.simpleConnectionProviderParam, this.topLevelConnectionProviderParam, offending));
        this.validate();
    }

    @Test
    public void contentParameterValidationIsSkipped() {
        ParameterModel offending = ExtensionsTestUtils.getParameter(SIMPLE_PARAM_NAME, String.class);
        Mockito.when((Object)offending.getRole()).thenReturn((Object)ParameterRole.CONTENT);
        Mockito.when((Object)this.connectionProviderModel.getAllParameterModels()).thenReturn(Arrays.asList(this.simpleConnectionProviderParam, this.topLevelConnectionProviderParam, offending));
        this.validate();
    }

    @Test
    public void sourceWithRepeatedParameterNameWithinCallback() {
        this.exception.expect(IllegalModelDefinitionException.class);
        ParameterModel offending = ExtensionsTestUtils.getParameter(SIMPLE_PARAM_NAME, String.class);
        SourceCallbackModel sourceCallbackModel = (SourceCallbackModel)Mockito.mock(SourceCallbackModel.class);
        Mockito.when((Object)sourceCallbackModel.getAllParameterModels()).thenReturn(Arrays.asList(this.simpleConnectionProviderParam, offending));
        Mockito.when((Object)this.sourceModel.getErrorCallback()).thenReturn(Optional.of(sourceCallbackModel));
        this.validate();
    }

    @Test
    public void sourceWithRepeatedParameterNameAmongCallbackAndSource() {
        this.exception.expect(IllegalModelDefinitionException.class);
        ParameterModel offending = ExtensionsTestUtils.getParameter(SIMPLE_PARAM_NAME, String.class);
        SourceCallbackModel sourceCallbackModel = (SourceCallbackModel)Mockito.mock(SourceCallbackModel.class);
        Mockito.when((Object)sourceCallbackModel.getAllParameterModels()).thenReturn(Arrays.asList(this.simpleConfigParam));
        ParameterGroupModel group = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class);
        Mockito.when((Object)group.getName()).thenReturn((Object)"General");
        Mockito.when((Object)group.getModelProperty(ParameterGroupModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)group.getParameterModels()).thenReturn(Arrays.asList(offending));
        ImmutableSourceModel sourceModel = new ImmutableSourceModel(SOURCE_NAME, "", false, Arrays.asList(group), null, null, Optional.of(sourceCallbackModel), Optional.empty(), Optional.empty(), false, false, false, null, Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        Mockito.when((Object)this.extensionModel.getSourceModels()).thenReturn(Arrays.asList(sourceModel));
        this.validate();
    }

    @Test
    public void sourceWithRepeatedParameterNameAmongCallbacks() {
        SourceCallbackModel errorCallBack = (SourceCallbackModel)Mockito.mock(SourceCallbackModel.class);
        Mockito.when((Object)errorCallBack.getAllParameterModels()).thenReturn(Arrays.asList(this.simpleConnectionProviderParam));
        Mockito.when((Object)this.sourceModel.getErrorCallback()).thenReturn(Optional.of(errorCallBack));
        SourceCallbackModel successCallback = (SourceCallbackModel)Mockito.mock(SourceCallbackModel.class);
        Mockito.when((Object)successCallback.getAllParameterModels()).thenReturn(Arrays.asList(this.simpleConnectionProviderParam));
        Mockito.when((Object)this.sourceModel.getSuccessCallback()).thenReturn(Optional.of(successCallback));
        this.validate();
    }

    @Test
    public void mapSingularizeClashOnOperation() {
        this.exception.expect(IllegalModelDefinitionException.class);
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)CHILD_SINGULAR_PARAM_NAME);
        ParameterModel offending = ExtensionsTestUtils.getParameter(CHILD_PLURAL_PARAM_NAME, this.childTestMap);
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(offending));
        this.validate();
    }

    @Test
    public void mapSingularizeClashOnConnectionProvider() {
        this.exception.expect(IllegalModelDefinitionException.class);
        String clashingName = "childTestsConnection";
        Mockito.when((Object)this.connectionProviderModel.getName()).thenReturn((Object)clashingName);
        ParameterModel offending = ExtensionsTestUtils.getParameter(clashingName, this.childTestMap);
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(offending));
        this.validate();
    }

    @Test
    public void mapSingularizeClashOnParameterSameType() {
        ParameterModel offending = ExtensionsTestUtils.getParameter(CHILD_PLURAL_PARAM_NAME, this.childTestMap);
        ParameterModel singular = ExtensionsTestUtils.getParameter(CHILD_SINGULAR_PARAM_NAME, ChildTest.class);
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(singular, offending));
        this.validate();
    }

    @Test
    public void mapSingularizeClashOnTopLevelParameterDifferentType() {
        this.exception.expect(IllegalModelDefinitionException.class);
        ParameterModel offending = ExtensionsTestUtils.getParameter(CHILD_PLURAL_PARAM_NAME, this.childTestMap);
        ParameterModel singular = ExtensionsTestUtils.getParameter(CHILD_SINGULAR_PARAM_NAME, TopLevelTest.class);
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(singular, offending));
        this.validate();
    }

    @Test
    public void mapSingularizeClashOnTopLevelParameterSameType() {
        ParameterModel offending = ExtensionsTestUtils.getParameter(TOP_LEVEL_PLURAL_PARAM_NAME, this.topLevelMap);
        ParameterModel singular = ExtensionsTestUtils.getParameter(TOP_LEVEL_SINGULAR_PARAM_NAME, TopLevelTest.class);
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(singular, offending));
        this.validate();
    }

    @Test
    public void listSingularizeClashOnOperation() {
        this.exception.expect(IllegalModelDefinitionException.class);
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)CHILD_SINGULAR_PARAM_NAME);
        ParameterModel offending = ExtensionsTestUtils.getParameter(CHILD_PLURAL_PARAM_NAME, this.childTestList);
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(offending));
        this.validate();
    }

    @Test
    public void listSingularizeClashOnConnectionProvider() {
        String clashingName = "childTestsConnection";
        this.exception.expect(IllegalModelDefinitionException.class);
        Mockito.when((Object)this.connectionProviderModel.getName()).thenReturn((Object)clashingName);
        ParameterModel offending = ExtensionsTestUtils.getParameter(clashingName, this.childTestList);
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(offending));
        this.validate();
    }

    @Test
    public void listSingularizeClashOnParameterSameType() {
        ParameterModel offending = ExtensionsTestUtils.getParameter(CHILD_PLURAL_PARAM_NAME, this.childTestList);
        ParameterModel singular = ExtensionsTestUtils.getParameter(CHILD_SINGULAR_PARAM_NAME, ChildTest.class);
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(singular, offending));
        this.validate();
    }

    @Test
    public void listSingularizeClashOnTopLevelParameterDifferentType() {
        this.exception.expect(IllegalModelDefinitionException.class);
        ParameterModel offending = ExtensionsTestUtils.getParameter(CHILD_PLURAL_PARAM_NAME, this.childTestList);
        ParameterModel singular = ExtensionsTestUtils.getParameter(CHILD_SINGULAR_PARAM_NAME, TopLevelTest.class);
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(singular, offending));
        this.validate();
    }

    @Test
    public void listSingularizeClashOnTopLevelParameterSameType() {
        ParameterModel offending = ExtensionsTestUtils.getParameter(TOP_LEVEL_PLURAL_PARAM_NAME, this.topLevelTestList);
        ParameterModel singular = ExtensionsTestUtils.getParameter(TOP_LEVEL_SINGULAR_PARAM_NAME, TopLevelTest.class);
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(singular, offending));
        this.validate();
    }

    @Test
    public void notInlineDefinitionPassSuccessful() {
        ParameterModel offending = ExtensionsTestUtils.getParameter(CHILD_PLURAL_PARAM_NAME, this.childTestList);
        ParameterModel singular = ExtensionsTestUtils.getParameter(CHILD_SINGULAR_PARAM_NAME, NoChildTest.class);
        Mockito.when((Object)this.configurationModel.getAllParameterModels()).thenReturn(Collections.singletonList(offending));
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"mapSingularizeClash");
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Collections.singletonList(singular));
        this.validate();
    }

    @Test
    public void differentNamesClashWhenHyphenized() {
        this.exception.expect(IllegalModelDefinitionException.class);
        this.exception.expectMessage("contains 2 components 'config-name");
        ConfigurationModel configuration = (ConfigurationModel)Mockito.mock(ConfigurationModel.class);
        this.mockModelProperties((EnrichableModel)configuration);
        Mockito.when((Object)configuration.getName()).thenReturn((Object)"config-name");
        Mockito.when((Object)this.configurationModel.getName()).thenReturn((Object)"ConfigName");
        Mockito.when((Object)configuration.getAllParameterModels()).thenReturn(Arrays.asList(this.simpleConfigParam, this.topLevelConfigParam));
        Mockito.when((Object)configuration.getOperationModels()).thenReturn((Object)ImmutableList.of());
        Mockito.when((Object)configuration.getConnectionProviders()).thenReturn((Object)ImmutableList.of());
        Mockito.when((Object)this.extensionModel.getConfigurationModels()).thenReturn(Arrays.asList(this.configurationModel, configuration));
        this.validate();
    }

    @Test
    public void contentParamtersWithSameNameAndDifferentType() {
        this.exception.expect(IllegalModelDefinitionException.class);
        ParameterModel firtParam = ExtensionsTestUtils.getParameter(CHILD_SINGULAR_PARAM_NAME, Object.class);
        Mockito.when((Object)firtParam.getRole()).thenReturn((Object)ParameterRole.PRIMARY_CONTENT);
        ParameterModel secondParam = ExtensionsTestUtils.getParameter(CHILD_SINGULAR_PARAM_NAME, TopLevelTest.class);
        Mockito.when((Object)secondParam.getRole()).thenReturn((Object)ParameterRole.CONTENT);
        Mockito.when((Object)this.operationModel.getAllParameterModels()).thenReturn(Arrays.asList(firtParam));
        Mockito.when((Object)this.sourceModel.getAllParameterModels()).thenReturn(Arrays.asList(secondParam));
        this.validate();
    }

    private void validate() {
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @XmlHints(allowInlineDefinition=false)
    private static class NoChildTest {
        private String id;

        private NoChildTest() {
        }

        public String getId() {
            return this.id;
        }
    }

    private static class ChildTest {
        private String id;

        public String getId() {
            return this.id;
        }
    }

    @XmlHints(allowTopLevelDefinition=true)
    private static class TopLevelConfig {
        private String id;

        public String getId() {
            return this.id;
        }
    }

    @XmlHints(allowTopLevelDefinition=true)
    private static class TopLevelTest {
        private String id;

        public String getId() {
            return this.id;
        }
    }
}

