/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.module.extension.internal.resources.AbstractGeneratedResourceFactoryTestCase;
import org.mule.runtime.module.extension.internal.resources.ExtensionModelResourceFactory;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.HeisenbergExtension;

@SmallTest
public class ExtensionModelResourceFactoryTestCase
extends AbstractGeneratedResourceFactoryTestCase {
    private ExtensionModelResourceFactory resourceFactory = new ExtensionModelResourceFactory();
    private ExtensionModel extensionModel;

    @Before
    public void before() {
        this.extensionModel = MuleExtensionUtils.loadExtension(HeisenbergExtension.class);
    }

    @Override
    protected Class<? extends GeneratedResourceFactory>[] getResourceFactoryTypes() {
        return new Class[]{ExtensionModelResourceFactory.class};
    }

    @Test
    public void generate() throws Exception {
        GeneratedResource resource = (GeneratedResource)this.resourceFactory.generateResource(this.extensionModel).get();
        Assert.assertThat((Object)resource.getPath(), (Matcher)CoreMatchers.equalTo((Object)"extension-model.json"));
        ExtensionModel deserialized = new ExtensionModelJsonSerializer().deserialize(new String(resource.getContent()));
        Assert.assertThat((Object)this.extensionModel.getName(), (Matcher)CoreMatchers.equalTo((Object)deserialized.getName()));
    }
}

