/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.execution.TransactionalExecutionTemplate;
import org.mule.runtime.core.transaction.MuleTransactionConfig;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ConnectionInterceptor;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionFactory;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.test.petstore.extension.PetStoreClient;
import org.mule.test.petstore.extension.PetStoreConnectionProvider;
import org.mule.test.petstore.extension.PetStoreConnector;
import org.mule.test.petstore.extension.SimplePetStoreConnectionProvider;
import org.mule.test.petstore.extension.TransactionalPetStoreConnectionProvider;

@RunWith(value=MockitoJUnitRunner.class)
public class StreamingInterceptorTestCase
extends AbstractMuleContextTestCase {
    private static final String USER = "john";
    private static final String PASSWORD = "doe";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExecutionContextAdapter operationContext;
    @Mock
    private ConfigurationInstance configurationInstance;
    @Mock
    private PetStoreConnector config;
    private PetStoreConnectionProvider<? extends PetStoreClient> connectionProvider;
    private ConnectionInterceptor interceptor;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.operationContext.getConfiguration()).thenReturn(Optional.of(this.configurationInstance));
        Mockito.when((Object)this.configurationInstance.getValue()).thenReturn((Object)this.config);
        this.setupConnectionProvider((PetStoreConnectionProvider<?>)new SimplePetStoreConnectionProvider());
        Mockito.when((Object)this.operationContext.getVariable("MULE_CONNECTION_PARAM")).thenReturn(null);
        Mockito.when((Object)this.operationContext.getTransactionConfig()).thenReturn(Optional.empty());
        this.interceptor = new ConnectionInterceptor();
        muleContext.getInjector().inject((Object)this.interceptor);
    }

    private void setupConnectionProvider(PetStoreConnectionProvider<?> aConnectionProvider) throws Exception {
        this.connectionProvider = (PetStoreConnectionProvider)Mockito.spy(aConnectionProvider);
        Mockito.when((Object)this.configurationInstance.getConnectionProvider()).thenReturn(Optional.of(this.connectionProvider));
        this.connectionProvider.setUsername(USER);
        this.connectionProvider.setPassword(PASSWORD);
        ConnectionManager connectionManager = (ConnectionManager)muleContext.getRegistry().lookupObject(ConnectionManager.class);
        connectionManager.bind((Object)this.config, this.connectionProvider);
    }

    @Test
    public void setConnection() throws Exception {
        PetStoreClient connection = this.getConnection();
        ((PetStoreConnectionProvider)Mockito.verify(this.connectionProvider)).connect();
        Assert.assertThat((Object)connection, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)connection.getUsername(), (Matcher)CoreMatchers.is((Object)USER));
        Assert.assertThat((Object)connection.getPassword(), (Matcher)CoreMatchers.is((Object)PASSWORD));
    }

    @Test
    public void returnsAlwaysSameConnectionAndConnectOnlyOnce() throws Exception {
        PetStoreClient connection1 = this.getConnection();
        PetStoreClient connection2 = this.getConnection();
        Assert.assertThat((Object)connection1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)connection2)));
        ((PetStoreConnectionProvider)Mockito.verify(this.connectionProvider)).connect();
    }

    @Test
    public void after() {
        ConnectionHandler connectionHandler = (ConnectionHandler)Mockito.mock(ConnectionHandler.class);
        Mockito.when((Object)this.operationContext.removeVariable("MULE_CONNECTION_PARAM")).thenReturn((Object)connectionHandler);
        this.interceptor.after((ExecutionContext)this.operationContext, null);
        ((ExecutionContextAdapter)Mockito.verify((Object)this.operationContext)).removeVariable("MULE_CONNECTION_PARAM");
        ((ConnectionHandler)Mockito.verify((Object)connectionHandler)).release();
    }

    @Test
    public void alwaysReturnSameConnectionWhileInTransaction() throws Exception {
        this.setupConnectionProvider((PetStoreConnectionProvider<?>)new TransactionalPetStoreConnectionProvider());
        MuleTransactionConfig txConfig = new MuleTransactionConfig();
        txConfig.setFactory((TransactionFactory)new ExtensionTransactionFactory());
        txConfig.setAction((byte)1);
        txConfig.setMuleContext(muleContext);
        Mockito.when((Object)this.operationContext.getTransactionConfig()).thenReturn(Optional.of(txConfig));
        TransactionalExecutionTemplate.createTransactionalExecutionTemplate((MuleContext)muleContext, (TransactionConfig)txConfig).execute(() -> {
            PetStoreClient connection = this.getConnection();
            Assert.assertThat((Object)connection, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.getConnection())));
            return null;
        });
    }

    private PetStoreClient getConnection() throws Exception {
        ArgumentCaptor connectionCaptor = ArgumentCaptor.forClass(ConnectionHandler.class);
        this.interceptor.before((ExecutionContext)this.operationContext);
        ((ExecutionContextAdapter)Mockito.verify((Object)this.operationContext, (VerificationMode)Mockito.atLeastOnce())).setVariable((String)Matchers.same((Object)"MULE_CONNECTION_PARAM"), connectionCaptor.capture());
        ConnectionHandler connectionHandler = (ConnectionHandler)connectionCaptor.getValue();
        return (PetStoreClient)connectionHandler.getConnection();
    }
}

