/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.execution.ResponseCompletionCallback;
import org.mule.runtime.module.extension.internal.runtime.source.ModuleFlowProcessingTemplate;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ExtensionFlowProcessingTemplateTestCase
extends AbstractMuleTestCase {
    @Mock
    private Message message;
    @Mock
    private Event event;
    @Mock
    private Processor messageProcessor;
    @Mock
    private SourceCompletionHandler completionHandler;
    @Mock
    private ResponseCompletionCallback responseCompletionCallback;
    @Mock
    private MessagingException messagingException;
    @Mock
    private Map<String, Object> mockParameters;
    private RuntimeException runtimeException = new RuntimeException();
    private ModuleFlowProcessingTemplate template;

    @Before
    public void before() throws Exception {
        this.template = new ModuleFlowProcessingTemplate(this.message, this.messageProcessor, this.completionHandler);
        Mockito.when((Object)this.completionHandler.onCompletion((Event)Matchers.any(), (Map)Matchers.any())).thenReturn((Object)Mono.empty());
        Mockito.when((Object)this.completionHandler.onFailure((MessagingException)Matchers.any(), (Map)Matchers.any())).thenReturn((Object)Mono.empty());
    }

    @Test
    public void getMuleEvent() throws Exception {
        Assert.assertThat((Object)this.template.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.message)));
    }

    @Test
    public void routeEvent() throws Exception {
        this.template.routeEvent(this.event);
        ((Processor)Mockito.verify((Object)this.messageProcessor)).process(this.event);
    }

    @Test
    public void routeEventAsync() throws Exception {
        Mockito.when((Object)this.messageProcessor.apply((Publisher)Matchers.any(Publisher.class))).thenReturn((Object)Mono.just((Object)this.event));
        this.template.routeEventAsync(this.event);
        ((Processor)Mockito.verify((Object)this.messageProcessor)).apply((Publisher)Matchers.any(Publisher.class));
    }

    @Test
    public void sendResponseToClient() throws Exception {
        Mono.from((Publisher)this.template.sendResponseToClient(this.event, this.mockParameters, event -> this.mockParameters, this.responseCompletionCallback)).block();
        ((SourceCompletionHandler)Mockito.verify((Object)this.completionHandler)).onCompletion((Event)Matchers.same((Object)this.event), (Map)Matchers.same(this.mockParameters));
        ((ResponseCompletionCallback)Mockito.verify((Object)this.responseCompletionCallback)).responseSentSuccessfully();
    }

    @Test
    public void failedToSendResponseToClient() throws Exception {
        Mockito.when((Object)this.completionHandler.onCompletion((Event)Matchers.same((Object)this.event), (Map)Matchers.same(this.mockParameters))).thenReturn((Object)Mono.error((Throwable)this.runtimeException));
        Mono.from((Publisher)this.template.sendResponseToClient(this.event, this.mockParameters, event -> this.mockParameters, this.responseCompletionCallback)).subscribe();
        ((SourceCompletionHandler)Mockito.verify((Object)this.completionHandler, (VerificationMode)Mockito.never())).onFailure((MessagingException)Matchers.any(MessagingException.class), (Map)Matchers.same(this.mockParameters));
        ((ResponseCompletionCallback)Mockito.verify((Object)this.responseCompletionCallback)).responseSentWithFailure((MessagingException)Matchers.argThat((Matcher)new ArgumentMatcher<MessagingException>(){

            public boolean matches(Object o) {
                return o instanceof MessagingException && ((MessagingException)o).getRootCause().equals(ExtensionFlowProcessingTemplateTestCase.this.runtimeException);
            }
        }), (Event)Matchers.eq((Object)this.event));
    }

    @Test
    public void sendFailureResponseToClient() throws Exception {
        Mono.from((Publisher)this.template.sendFailureResponseToClient(this.messagingException, this.mockParameters, this.responseCompletionCallback)).block();
        ((SourceCompletionHandler)Mockito.verify((Object)this.completionHandler)).onFailure(this.messagingException, this.mockParameters);
        ((ResponseCompletionCallback)Mockito.verify((Object)this.responseCompletionCallback)).responseSentSuccessfully();
    }

    @Test
    public void failedToSendFailureResponseToClient() throws Exception {
        Mockito.when((Object)this.messagingException.getEvent()).thenReturn((Object)this.event);
        Mockito.when((Object)this.completionHandler.onFailure(this.messagingException, this.mockParameters)).thenReturn((Object)Mono.error((Throwable)this.runtimeException));
        Mono.from((Publisher)this.template.sendFailureResponseToClient(this.messagingException, this.mockParameters, this.responseCompletionCallback)).subscribe();
        ((ResponseCompletionCallback)Mockito.verify((Object)this.responseCompletionCallback)).responseSentWithFailure((MessagingException)Matchers.argThat((Matcher)new ArgumentMatcher<MessagingException>(){

            public boolean matches(Object o) {
                return o instanceof MessagingException && ((MessagingException)o).getRootCause().equals(ExtensionFlowProcessingTemplateTestCase.this.runtimeException);
            }
        }), (Event)Matchers.eq((Object)this.event));
    }
}

