/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.UnionType;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.tck.TestHttpConnectorDeclarer;
import org.mule.runtime.extension.api.declaration.type.ReconnectionStrategyTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.RedeliveryPolicyTypeBuilder;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.module.extension.internal.loader.java.AbstractJavaExtensionDeclarationTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
public class ComplexExtensionDeclarationTestCase
extends AbstractJavaExtensionDeclarationTestCase {
    private ExtensionModel extensionModel;

    @Before
    public void before() {
        this.extensionModel = new ExtensionModelLoader(){

            public String getId() {
                return "test";
            }

            protected void declareExtension(ExtensionLoadingContext context) {
                new TestHttpConnectorDeclarer().declareOn(context.getExtensionDeclarer());
            }
        }.loadExtensionModel(((Object)((Object)this)).getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet()), new HashMap());
    }

    @Test
    public void assertDeclaration() {
        Assert.assertThat((Object)this.extensionModel.getName(), (Matcher)CoreMatchers.is((Object)"http"));
        Assert.assertThat((Object)this.extensionModel.getDescription(), (Matcher)CoreMatchers.is((Object)"Http Connector"));
        Assert.assertThat((Object)this.extensionModel.getVersion(), (Matcher)CoreMatchers.is((Object)"1.0"));
        Assert.assertThat((Object)this.extensionModel.getConfigurationModels(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)this.extensionModel.getVendor(), (Matcher)CoreMatchers.is((Object)"Mulesoft"));
        Assert.assertThat((Object)this.extensionModel.getOperationModels(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.extensionModel.getConnectionProviders(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)this.extensionModel.getSourceModels(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void listenerConfig() {
        ConfigurationModel listener = (ConfigurationModel)this.extensionModel.getConfigurationModel("listener").get();
        Assert.assertThat((Object)listener.getDescription(), (Matcher)CoreMatchers.is((Object)"http listener"));
        Assert.assertThat((Object)listener.getOperationModels(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)listener.getConnectionProviders(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)listener.getSourceModels(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void listenerSource() {
        SourceModel source = (SourceModel)((ConfigurationModel)this.extensionModel.getConfigurationModel("listener").get()).getSourceModel("listen").get();
        ExtensionsTestUtils.assertType(source.getOutput().getType(), InputStream.class, BinaryType.class);
        ExtensionsTestUtils.assertType(source.getOutputAttributes().getType(), Serializable.class, ObjectType.class);
        List parameters = source.getAllParameterModels();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)4));
        ParameterModel parameter = (ParameterModel)parameters.get(0);
        Assert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)"redeliveryPolicy"));
        Assert.assertThat((Object)parameter.getType(), (Matcher)CoreMatchers.equalTo((Object)new RedeliveryPolicyTypeBuilder().buildRedeliveryPolicyType()));
        parameter = (ParameterModel)parameters.get(1);
        this.assertStreamingStrategyParameter(parameter);
        parameter = (ParameterModel)parameters.get(2);
        Assert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)"port"));
        Assert.assertThat((Object)parameter.isRequired(), (Matcher)CoreMatchers.is((Object)false));
        ExtensionsTestUtils.assertType(parameter.getType(), Integer.class, NumberType.class);
        parameter = (ParameterModel)parameters.get(3);
        Assert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)"reconnectionStrategy"));
        Assert.assertThat((Object)parameter.getType(), (Matcher)CoreMatchers.equalTo((Object)new ReconnectionStrategyTypeBuilder().buildReconnectionStrategyType()));
    }

    @Test
    public void requesterConfig() {
        ConfigurationModel listener = (ConfigurationModel)this.extensionModel.getConfigurationModel("requester").get();
        Assert.assertThat((Object)listener.getDescription(), (Matcher)CoreMatchers.is((Object)"http requester"));
        Assert.assertThat((Object)listener.getOperationModels(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)listener.getConnectionProviders(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)listener.getSourceModels(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void requestOperation() {
        OperationModel operation = (OperationModel)((ConfigurationModel)this.extensionModel.getConfigurationModel("requester").get()).getOperationModel("request").get();
        Assert.assertThat((Object)operation.getName(), (Matcher)CoreMatchers.is((Object)"request"));
        ExtensionsTestUtils.assertType(operation.getOutput().getType(), InputStream.class, BinaryType.class);
        List parameterModels = operation.getAllParameterModels();
        Assert.assertThat((Object)parameterModels, (Matcher)Matchers.hasSize((int)3));
        ParameterModel parameter = (ParameterModel)parameterModels.get(0);
        this.assertStreamingStrategyParameter(parameter);
        parameter = (ParameterModel)parameterModels.get(1);
        Assert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)"path"));
        ExtensionsTestUtils.assertType(parameter.getType(), String.class, StringType.class);
        parameter = (ParameterModel)parameterModels.get(2);
        this.assertTargetParameter(parameter);
    }

    private void assertTargetParameter(ParameterModel parameter) {
        Assert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)"target"));
        ExtensionsTestUtils.assertType(parameter.getType(), String.class, StringType.class);
    }

    private void assertStreamingStrategyParameter(ParameterModel parameter) {
        Assert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)"streamingStrategy"));
        ExtensionsTestUtils.assertType(parameter.getType(), Object.class, UnionType.class);
    }

    @Test
    public void staticResourceOperation() {
        OperationModel operation = (OperationModel)this.extensionModel.getOperationModel("staticResource").get();
        Assert.assertThat((Object)operation.getName(), (Matcher)CoreMatchers.is((Object)"staticResource"));
        ExtensionsTestUtils.assertType(operation.getOutput().getType(), InputStream.class, BinaryType.class);
        List parameters = operation.getAllParameterModels();
        Assert.assertThat((Object)parameters, (Matcher)Matchers.hasSize((int)3));
        this.assertStreamingStrategyParameter((ParameterModel)parameters.get(0));
        ParameterModel parameter = (ParameterModel)parameters.get(1);
        Assert.assertThat((Object)parameter.getName(), (Matcher)CoreMatchers.is((Object)"path"));
        ExtensionsTestUtils.assertType(parameter.getType(), String.class, StringType.class);
        this.assertTargetParameter((ParameterModel)parameters.get(2));
    }

    @Test
    public void connectionProvider() {
        ConnectionProviderModel provider = (ConnectionProviderModel)((ConfigurationModel)this.extensionModel.getConfigurationModel("requester").get()).getConnectionProviders().get(0);
        Assert.assertThat((Object)provider.getName(), (Matcher)CoreMatchers.is((Object)"requesterProvider"));
    }
}

